"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationTestBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const posix_1 = require("path/posix");
const internal_1 = require("./internal");
const component_1 = require("../component");
class IntegrationTestBase extends component_1.Component {
    constructor(project, options) {
        super(project);
        const entry = options.entrypoint;
        const name = options.name ?? (0, path_1.basename)(entry, internal_1.TYPESCRIPT_INTEG_EXT);
        this.name = name;
        const dir = (0, path_1.dirname)(entry);
        const tmpRoot = (0, posix_1.join)(dir, ".tmp");
        project.addGitIgnore(tmpRoot);
        project.addPackageIgnore(tmpRoot);
        this.tmpDir = (0, posix_1.join)(tmpRoot, `${name}.integ`);
        this.snapshotDir = (0, posix_1.join)(dir, `${name}.integ.snapshot`);
        project.addPackageIgnore(this.snapshotDir);
        this.deployTask = project.addTask(`integ:${name}:deploy`, {
            description: `deploy integration test '${name}' and capture snapshot`,
        });
        this.snapshotTask = project.addTask(`integ:${name}:snapshot`, {
            description: `update snapshot for integration test "${name}"`,
        });
        this.assertTask = project.addTask(`integ:${name}:assert`, {
            description: `assert the snapshot of integration test '${name}'`,
            exec: `[ -d "${this.snapshotDir}" ] || (echo "No snapshot available for integration test '${name}'. Run 'projen ${this.deployTask.name}' to capture." && exit 1)`,
        });
        // synth as part of our tests, which means that if outdir changes, anti-tamper will fail
        project.testTask.spawn(this.assertTask);
        let snapshotAllTask = project.tasks.tryFind("integ:snapshot-all");
        if (!snapshotAllTask) {
            snapshotAllTask = project.addTask("integ:snapshot-all", {
                description: "update snapshot for all integration tests",
            });
        }
        // integ:snapshot-all should snapshot all integration tests, including
        // this one.
        snapshotAllTask.spawn(this.snapshotTask);
    }
}
exports.IntegrationTestBase = IntegrationTestBase;
_a = JSII_RTTI_SYMBOL_1;
IntegrationTestBase[_a] = { fqn: "projen.cdk.IntegrationTestBase", version: "0.98.16" };
//# sourceMappingURL=data:application/json;base64,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