"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitHubProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const auto_approve_1 = require("./auto-approve");
const github_1 = require("./github");
const stale_1 = require("./stale");
const clobber_1 = require("../clobber");
const gitpod_1 = require("../gitpod");
const project_1 = require("../project");
const readme_1 = require("../readme");
const util_1 = require("../util");
const vscode_1 = require("../vscode");
/**
 * GitHub-based project.
 *
 * @deprecated This is a *temporary* class. At the moment, our base project
 * types such as `NodeProject` and `JavaProject` are derived from this, but we
 * want to be able to use these project types outside of GitHub as well. One of
 * the next steps to address this is to abstract workflows so that different
 * "engines" can be used to implement our CI/CD solutions.
 */
class GitHubProject extends project_1.Project {
    constructor(options) {
        super(options);
        this.projectType = options.projectType ?? project_1.ProjectType.UNKNOWN;
        // we only allow these global services to be used in root projects
        const github = options.github ?? !this.parent;
        this.github = github
            ? new github_1.GitHub(this, {
                projenTokenSecret: options.projenTokenSecret,
                projenCredentials: options.projenCredentials,
                mergify: options.mergify,
                mergifyOptions: options.mergifyOptions,
                ...options.githubOptions,
            })
            : undefined;
        const vscode = options.vscode ?? !this.parent;
        this.vscode = vscode ? new vscode_1.VsCode(this) : undefined;
        this.gitpod = options.gitpod ? new gitpod_1.Gitpod(this) : undefined;
        this.devContainer = options.devContainer
            ? new vscode_1.DevContainer(this)
            : undefined;
        if (options.clobber ?? !this.parent) {
            new clobber_1.Clobber(this);
        }
        new readme_1.SampleReadme(this, options.readme);
        if (options.autoApproveOptions && this.github) {
            this.autoApprove = new auto_approve_1.AutoApprove(this.github, options.autoApproveOptions);
        }
        const stale = options.stale ?? false;
        if (stale && this.github) {
            new stale_1.Stale(this.github, options.staleOptions);
        }
    }
    /**
     * Marks the provided file(s) as being generated. This is achieved using the
     * github-linguist attributes. Generated files do not count against the
     * repository statistics and language breakdown.
     *
     * @param glob the glob pattern to match (could be a file path).
     *
     * @see https://github.com/github/linguist/blob/master/docs/overrides.md
     */
    annotateGenerated(glob) {
        this.gitattributes.addAttributes((0, util_1.normalizePersistedPath)(glob), "linguist-generated");
    }
}
exports.GitHubProject = GitHubProject;
_a = JSII_RTTI_SYMBOL_1;
GitHubProject[_a] = { fqn: "projen.github.GitHubProject", version: "0.98.16" };
//# sourceMappingURL=data:application/json;base64,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