"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MergeQueue = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const auto_queue_1 = require("./auto-queue");
const component_1 = require("../component");
const gh = require("../github");
const github_1 = require("../github");
/**
 * Merge pull requests using a merge queue
 */
class MergeQueue extends component_1.Component {
    constructor(scope, options = {}) {
        super(scope);
        this.options = options;
        const workflowEngine = gh.GitHub.of(this.project);
        if (!workflowEngine) {
            throw new Error(`Cannot add ${new.target.name} to project without GitHub enabled. Please enable GitHub for this project.`);
        }
        const autoMerge = options.autoQueue ?? true;
        if (autoMerge) {
            // Validate the autoQueue.targetBranches w.r.t. the mergeQueue.targetBranches
            //
            // - mergeQueue.targetBranches: those branches we CAN use merge queues for
            // - autoQueue.targetBranches: those branches we AUTOMATICALLY use merge queues for (subset of former)
            //
            //                                 mergeBranches
            //                       |   undefined   |   defined    |
            //                       |---------------|--------------|
            //  auto       undefined |      ok       |     copy     |
            //  Branches     defined |      ok       |   validate   |
            //                       |---------------|--------------|
            if (options.autoQueueOptions?.targetBranches && options.targetBranches) {
                if (!isSubset(options.autoQueueOptions?.targetBranches, options.targetBranches)) {
                    throw new Error(`autoQueueOptions.targetBranches (${JSON.stringify(options.autoQueueOptions?.targetBranches)} must be a subset of targetBranches (${JSON.stringify(options.targetBranches)})`);
                }
            }
            new auto_queue_1.AutoQueue(this, {
                ...options.autoQueueOptions,
                // Copy over maximal set of merge branches if necessary
                targetBranches: options.autoQueueOptions?.targetBranches ?? options.targetBranches,
            });
        }
    }
    preSynthesize() {
        const targetBranches = this.options.targetBranches;
        const mergeGroup = targetBranches
            ? {
                branches: targetBranches,
            }
            : {};
        const workflowEngine = github_1.GitHub.of(this.project);
        workflowEngine?.tryFindWorkflow("build")?.on({
            mergeGroup,
        });
    }
}
exports.MergeQueue = MergeQueue;
_a = JSII_RTTI_SYMBOL_1;
MergeQueue[_a] = { fqn: "projen.github.MergeQueue", version: "0.98.16" };
function isSubset(xs, ys) {
    return xs.every((x) => ys.includes(x));
}
//# sourceMappingURL=data:application/json;base64,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