"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PullRequestTemplate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const textfile_1 = require("../textfile");
/**
 * Template for GitHub pull requests.
 */
class PullRequestTemplate extends textfile_1.TextFile {
    /**
     * Returns the `PullRequestTemplate` instance associated with a project or `undefined` if
     * there is no PullRequestTemplate.
     * @param project The project
     * @returns A PullRequestTemplate
     */
    static of(project) {
        const isPrTemplate = (o) => o instanceof PullRequestTemplate;
        return project.components.find(isPrTemplate);
    }
    constructor(github, options = {}) {
        super(github.project, ".github/pull_request_template.md", {
            lines: options.lines && options.lines?.length > 0
                ? options.lines
                : ["Fixes #"],
            marker: false,
            // GitHub needs to read the file from the repository in order to work.
            committed: true,
        });
    }
}
exports.PullRequestTemplate = PullRequestTemplate;
_a = JSII_RTTI_SYMBOL_1;
PullRequestTemplate[_a] = { fqn: "projen.github.PullRequestTemplate", version: "0.98.16" };
//# sourceMappingURL=data:application/json;base64,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