"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IgnoreFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const file_1 = require("./file");
const util_1 = require("./util");
class IgnoreFile extends file_1.FileBase {
    /**
     *
     * @param project The project to tie this file to.
     * @param filePath - the relative path in the project to put the file
     * @param minify - whether comments/blank lines should be filtered
     */
    constructor(project, filePath, options) {
        super(project, filePath, { editGitignore: filePath !== ".gitignore" });
        this.filterCommentLines = options?.filterCommentLines ?? true;
        this.filterEmptyLines = options?.filterEmptyLines ?? true;
        this._patterns = options?.ignorePatterns ?? [];
    }
    /**
     * Add ignore patterns. Files that match this pattern will be ignored. If the
     * pattern starts with a negation mark `!`, files that match will _not_ be
     * ignored.
     *
     * Comment lines (start with `#`) and blank lines ("") are filtered by default
     * but can be included using options specified when instantiating the component.
     *
     * @param patterns Ignore patterns.
     */
    addPatterns(...patterns) {
        for (const pattern of patterns) {
            const isComment = pattern.startsWith("#");
            const isEmptyLine = Boolean(pattern.trim().length === 0);
            if (isComment && this.filterCommentLines) {
                continue;
            }
            if (isEmptyLine && this.filterEmptyLines) {
                continue;
            }
            if (!isComment && !isEmptyLine) {
                this.normalizePatterns(pattern);
            }
            const normalizedPattern = (0, util_1.normalizePersistedPath)(pattern);
            this._patterns.push(normalizedPattern);
        }
    }
    normalizePatterns(pattern) {
        const opposite = pattern.startsWith("!") ? pattern.slice(1) : "!" + pattern;
        remove(this._patterns, pattern); // prevent duplicates
        remove(this._patterns, opposite);
        if (pattern.endsWith("/")) {
            const prefix = opposite;
            for (const p of [...this._patterns]) {
                if (p.startsWith(prefix)) {
                    remove(this._patterns, p);
                }
            }
        }
    }
    /**
     * Removes patterns previously added from the ignore file.
     *
     * If `addPattern()` is called after this, the pattern will be added again.
     *
     * @param patterns patters to remove.
     */
    removePatterns(...patterns) {
        for (const p of patterns) {
            remove(this._patterns, p);
        }
    }
    /**
     * Ignore the files that match these patterns.
     * @param patterns The patterns to match.
     */
    exclude(...patterns) {
        return this.addPatterns(...patterns);
    }
    /**
     * Always include the specified file patterns.
     * @param patterns Patterns to include in git commits.
     */
    include(...patterns) {
        for (let pattern of patterns) {
            if (!pattern.startsWith("!")) {
                pattern = "!" + pattern;
            }
            this.addPatterns(pattern);
        }
    }
    synthesizeContent(resolver) {
        const lines = [
            ...(this.marker ? [`# ${this.marker}`] : []),
            ...this._patterns,
        ];
        return `${resolver.resolve(lines).join("\n")}\n`;
    }
}
exports.IgnoreFile = IgnoreFile;
_a = JSII_RTTI_SYMBOL_1;
IgnoreFile[_a] = { fqn: "projen.IgnoreFile", version: "0.98.16" };
// O(n) hooray!
function remove(arr, value) {
    const idx = arr.indexOf(value);
    if (idx >= 0) {
        arr.splice(idx, 1);
    }
}
//# sourceMappingURL=data:application/json;base64,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