"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LicenseChecker = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const dependencies_1 = require("../dependencies");
/**
 * Enforces allowed licenses used by dependencies.
 */
class LicenseChecker extends component_1.Component {
    constructor(scope, options) {
        const taskName = options.taskName ?? "check-licenses";
        super(scope, `LicenseChecker#${taskName}`);
        const { production = true, development = false, allow: allowedLicenses = [], deny: prohibitedLicenses = [], } = options;
        if (!production && !development) {
            throw new Error("LicenseChecker: At least one of `production` or `development` must be enabled.");
        }
        if (!allowedLicenses.length && !prohibitedLicenses.length) {
            throw new Error("LicenseChecker: Neither `allow` nor `deny` found. Exactly one must be provided and not empty.");
        }
        if (allowedLicenses.length && prohibitedLicenses.length) {
            throw new Error("LicenseChecker: `allow` and `deny` can not be used at the same time. Choose one or the other.");
        }
        const cmd = ["license-checker", "--summary"];
        if (production && !development) {
            cmd.push("--production");
        }
        if (development && !production) {
            cmd.push("--development");
        }
        if (allowedLicenses.length) {
            cmd.push("--onlyAllow");
            cmd.push(`"${allowedLicenses.join(";")}"`);
        }
        if (prohibitedLicenses.length) {
            cmd.push("--failOn");
            cmd.push(`"${prohibitedLicenses.join(";")}"`);
        }
        this.project.deps.addDependency("license-checker", dependencies_1.DependencyType.BUILD);
        this.task = this.project.addTask(taskName, {
            exec: cmd.join(" "),
            receiveArgs: true,
        });
        this.project.preCompileTask.spawn(this.task);
    }
}
exports.LicenseChecker = LicenseChecker;
_a = JSII_RTTI_SYMBOL_1;
LicenseChecker[_a] = { fqn: "projen.javascript.LicenseChecker", version: "0.98.16" };
//# sourceMappingURL=data:application/json;base64,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