import type { Project } from "../project";
import { ProjenrcFile } from "../projenrc";
export interface ProjenrcOptions {
    /**
     * The name of the projenrc file.
     * @default ".projenrc.js"
     */
    readonly filename?: string;
}
/**
 * A projenrc file written in JavaScript
 *
 * This component can be instantiated in any type of project
 * and has no expectations around the project's main language.
 */
export declare class Projenrc extends ProjenrcFile {
    readonly filePath: string;
    constructor(project: Project, options?: ProjenrcOptions);
    preSynthesize(): void;
    private generateProjenrc;
}
