"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const object_file_1 = require("./object-file");
/**
 * Represents a JSON file.
 */
class JsonFile extends object_file_1.ObjectFile {
    constructor(scope, filePath, options) {
        super(scope, filePath, options);
        this.newline = options.newline ?? true;
        this.supportsComments =
            options.allowComments ??
                (filePath.toLowerCase().endsWith("json5") ||
                    filePath.toLowerCase().endsWith("jsonc"));
        if (!options.obj) {
            throw new Error('"obj" cannot be undefined');
        }
    }
    synthesizeContent(resolver) {
        const json = super.synthesizeContent(resolver);
        if (!json) {
            return undefined;
        }
        const sanitized = JSON.parse(json);
        if (this.marker && !this.supportsComments) {
            sanitized["//"] = this.marker;
        }
        let content = JSON.stringify(sanitized, undefined, 2);
        if (this.marker && this.supportsComments) {
            content = `// ${this.marker}\n${content}`;
        }
        if (this.newline) {
            content += "\n";
        }
        return content;
    }
}
exports.JsonFile = JsonFile;
_a = JSII_RTTI_SYMBOL_1;
JsonFile[_a] = { fqn: "projen.JsonFile", version: "0.98.16" };
//# sourceMappingURL=data:application/json;base64,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