"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjenrcFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
/**
 * A component representing the projen runtime configuration
 */
class ProjenrcFile extends component_1.Component {
    /**
     * Returns the `Projenrc` instance associated with a project or `undefined` if
     * there is no Projenrc.
     * @param project The project
     * @returns A Projenrc
     */
    static of(project) {
        const isProjenrc = (o) => o instanceof ProjenrcFile;
        return project.components.find(isProjenrc);
    }
    preSynthesize() {
        this.project.gitignore.include(`/${this.filePath}`); // This is INCLUDING in .gitignore, not excluding, so it WON'T be ignored
    }
}
exports.ProjenrcFile = ProjenrcFile;
_a = JSII_RTTI_SYMBOL_1;
ProjenrcFile[_a] = { fqn: "projen.ProjenrcFile", version: "0.98.16" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJvamVucmMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvcHJvamVucmMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSwyQ0FBd0M7QUFHeEM7O0dBRUc7QUFDSCxNQUFzQixZQUFhLFNBQVEscUJBQVM7SUFDbEQ7Ozs7O09BS0c7SUFDSSxNQUFNLENBQUMsRUFBRSxDQUFDLE9BQWdCO1FBQy9CLE1BQU0sVUFBVSxHQUFHLENBQUMsQ0FBWSxFQUFxQixFQUFFLENBQ3JELENBQUMsWUFBWSxZQUFZLENBQUM7UUFDNUIsT0FBTyxPQUFPLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBT00sYUFBYTtRQUNsQixJQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxPQUFPLENBQUMsSUFBSSxJQUFJLENBQUMsUUFBUSxFQUFFLENBQUMsQ0FBQyxDQUFDLHlFQUF5RTtJQUNoSSxDQUFDOztBQXBCSCxvQ0FxQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQgfSBmcm9tIFwiLi9jb21wb25lbnRcIjtcbmltcG9ydCB7IFByb2plY3QgfSBmcm9tIFwiLi9wcm9qZWN0XCI7XG5cbi8qKlxuICogQSBjb21wb25lbnQgcmVwcmVzZW50aW5nIHRoZSBwcm9qZW4gcnVudGltZSBjb25maWd1cmF0aW9uXG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBQcm9qZW5yY0ZpbGUgZXh0ZW5kcyBDb21wb25lbnQge1xuICAvKipcbiAgICogUmV0dXJucyB0aGUgYFByb2plbnJjYCBpbnN0YW5jZSBhc3NvY2lhdGVkIHdpdGggYSBwcm9qZWN0IG9yIGB1bmRlZmluZWRgIGlmXG4gICAqIHRoZXJlIGlzIG5vIFByb2plbnJjLlxuICAgKiBAcGFyYW0gcHJvamVjdCBUaGUgcHJvamVjdFxuICAgKiBAcmV0dXJucyBBIFByb2plbnJjXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIG9mKHByb2plY3Q6IFByb2plY3QpOiBQcm9qZW5yY0ZpbGUgfCB1bmRlZmluZWQge1xuICAgIGNvbnN0IGlzUHJvamVucmMgPSAobzogQ29tcG9uZW50KTogbyBpcyBQcm9qZW5yY0ZpbGUgPT5cbiAgICAgIG8gaW5zdGFuY2VvZiBQcm9qZW5yY0ZpbGU7XG4gICAgcmV0dXJuIHByb2plY3QuY29tcG9uZW50cy5maW5kKGlzUHJvamVucmMpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBwYXRoIG9mIHRoZSBwcm9qZW5yYyBmaWxlLlxuICAgKi9cbiAgYWJzdHJhY3QgcmVhZG9ubHkgZmlsZVBhdGg6IHN0cmluZztcblxuICBwdWJsaWMgcHJlU3ludGhlc2l6ZSgpOiB2b2lkIHtcbiAgICB0aGlzLnByb2plY3QuZ2l0aWdub3JlLmluY2x1ZGUoYC8ke3RoaXMuZmlsZVBhdGh9YCk7IC8vIFRoaXMgaXMgSU5DTFVESU5HIGluIC5naXRpZ25vcmUsIG5vdCBleGNsdWRpbmcsIHNvIGl0IFdPTidUIGJlIGlnbm9yZWRcbiAgfVxufVxuIl19