"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const file_1 = require("./file");
/**
 * A text file.
 */
class TextFile extends file_1.FileBase {
    /**
     * Defines a text file.
     *
     * @param project The project
     * @param filePath File path
     * @param options Options
     */
    constructor(scope, filePath, options = {}) {
        super(scope, filePath, options);
        this.lines = options.lines ?? [];
    }
    /**
     * Adds a line to the text file.
     * @param line the line to add (can use tokens)
     */
    addLine(line) {
        this.lines.push(line);
    }
    synthesizeContent(_) {
        return this.lines.join("\n");
    }
}
exports.TextFile = TextFile;
_a = JSII_RTTI_SYMBOL_1;
TextFile[_a] = { fqn: "projen.TextFile", version: "0.98.16" };
//# sourceMappingURL=data:application/json;base64,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