"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjenrcTs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const path_1 = require("path");
const javascript_1 = require("../javascript");
const render_options_1 = require("../javascript/render-options");
const projenrc_1 = require("../projenrc");
const DEFAULT_FILENAME = ".projenrc.ts";
/**
 * A projenrc file written in TypeScript
 *
 * This component can be instantiated in any type of project
 * and has no expectations around the project's main language.
 *
 * Requires that `npx` is available.
 */
class ProjenrcTs extends projenrc_1.ProjenrcFile {
    constructor(project, options = {}) {
        super(project);
        this.filePath = options.filename ?? DEFAULT_FILENAME;
        this._projenCodeDir = options.projenCodeDir ?? "projenrc";
        project.addPackageIgnore(`/${this.filePath}`);
        // Create a dedicated tsconfig for projen source files
        this.tsconfig = new javascript_1.TypescriptConfig(project, {
            fileName: options.tsconfigFileName ?? "tsconfig.projen.json",
            compilerOptions: {},
        });
        // Use npx since project's deps manager is not guaranteed to be JS-based
        project.defaultTask?.exec(`npx -y ts-node --project ${this.tsconfig.fileName} ${this.filePath}`);
        this.generateProjenrc();
    }
    preSynthesize() {
        super.preSynthesize();
        this.tsconfig.addInclude(this.filePath);
        this.tsconfig.addInclude(`${this._projenCodeDir}/**/*.ts`);
    }
    generateProjenrc() {
        const rcfile = (0, path_1.resolve)(this.project.outdir, this.filePath);
        if ((0, fs_1.existsSync)(rcfile)) {
            return; // already exists
        }
        const bootstrap = this.project.initProject;
        if (!bootstrap) {
            return;
        }
        const parts = bootstrap.fqn.split(".");
        const moduleName = parts[0];
        const importName = parts[1];
        const className = parts.slice(1).join(".");
        const { renderedOptions, imports } = (0, render_options_1.renderJavaScriptOptions)({
            args: bootstrap.args,
            type: bootstrap.type,
            comments: bootstrap.comments,
        });
        imports.add(moduleName, importName);
        const lines = new Array();
        lines.push(...imports.asEsmImports());
        lines.push();
        lines.push(`const project = new ${className}(${renderedOptions});`);
        lines.push();
        lines.push("project.synth();");
        (0, fs_1.writeFileSync)(rcfile, lines.join("\n"));
        this.project.logger.info(`Project definition file was created at ${rcfile}`);
    }
}
exports.ProjenrcTs = ProjenrcTs;
_a = JSII_RTTI_SYMBOL_1;
ProjenrcTs[_a] = { fqn: "projen.typescript.ProjenrcTs", version: "0.98.16" };
//# sourceMappingURL=data:application/json;base64,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