# Contributor Covenant Code of Conduct

## Our Pledge

We as members, contributors, and leaders pledge to make participation in our community a harassment-free experience for everyone, regardless of age, body size, visible or invisible disability, ethnicity, sex characteristics, gender identity and expression, level of experience, education, socio-economic status, nationality, personal appearance, race, caste, color, religion, or sexual identity and orientation.

We pledge to act and interact in ways that contribute to an open, welcoming, diverse, inclusive, and healthy community.

## Our Standards

Examples of behavior that contributes to a positive environment for our community include:

* Using welcoming and inclusive language
* Being respectful of differing viewpoints and experiences
* Gracefully accepting constructive criticism
* Focusing on what is best for the community
* Showing empathy towards other community members

Examples of unacceptable behavior include:

* The use of sexualized language or imagery, and sexual attention or advances of any kind
* Trolling, insulting or derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others' private information, such as a physical or email address, without their explicit permission
* Other conduct which could reasonably be considered inappropriate in a professional setting

## Enforcement Responsibilities

Community leaders are responsible for clarifying and enforcing our standards of acceptable behavior and will take appropriate and fair corrective action in response to any behavior that they deem inappropriate, threatening, offensive, or harmful.

Community leaders have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, and will communicate reasons for moderation decisions when appropriate.

## Scope

This Code of Conduct applies within all community spaces, and also applies when an individual is officially representing the community in public spaces. Examples of representing our community include using an official project e-mail address, posting via an official social media account, or acting as an appointed representative at an online or offline event.

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be reported to the community leaders responsible for enforcement at [INSERT EMAIL ADDRESS]. All complaints will be reviewed and investigated promptly and fairly.

All community leaders are obligated to respect the privacy and security of the reporter of any incident.

## Enforcement Guidelines

Community leaders will follow these Community Impact Guidelines in determining the consequences for any action they deem in violation of this Code of Conduct:

### 1. Correction

**Community Impact**: Use of inappropriate language or other behavior deemed unprofessional or unwelcome in the community.

**Consequence**: A private, written warning from community leaders, providing clarity around the nature of the violation and an explanation of why the behavior was inappropriate. A public apology may be requested.

### 2. Warning

**Community Impact**: A violation through a single incident or series of actions.

**Consequence**: A warning with consequences for continued behavior. No interaction with the people involved, including unsolicited interaction with those enforcing the Code of Conduct, for a specified period of time. This includes avoiding interactions in community spaces as well as external channels like social media. Violating these terms may lead to a temporary or permanent ban.

### 3. Temporary Ban

**Community Impact**: A serious violation of community standards, including sustained inappropriate behavior.

**Consequence**: A temporary ban from any sort of interaction or public communication with the community for a specified period of time. No public or private interaction with the people involved, including unsolicited interaction with those enforcing the Code of Conduct, is allowed during this period. Violating these terms may lead to a permanent ban.

### 4. Permanent Ban

**Community Impact**: Demonstrating a pattern of violation of community standards, including sustained inappropriate behavior, harassment of an individual, or aggression toward or disparagement of classes of individuals.

**Consequence**: A permanent ban from any sort of public interaction within the community.

## Reporting

If you experience or witness unacceptable behavior, or have any other concerns, please report it by contacting the project maintainers. All reports will be handled with discretion.

**Contact Information**:
- **Email**: conduct@aiogram-sentinel.dev
- **GitHub**: [Create a private issue](https://github.com/ArmanAvanesyan/aiogram-sentinel/issues/new?template=security_issue.yml)

When reporting, please include:
- Your contact information
- Names (real, nicknames, or pseudonyms) of any individuals involved
- Description of the incident
- Any additional context that may be helpful

## Response Process

1. **Acknowledgment**: We will acknowledge receipt of your report within 48 hours
2. **Investigation**: We will investigate the incident promptly and fairly
3. **Resolution**: We will take appropriate action based on our enforcement guidelines
4. **Follow-up**: We will follow up with you about the resolution

## Confidentiality

All reports will be handled with the utmost confidentiality. We will not disclose the identity of reporters without their explicit consent, except where required by law.

## Appeals

If you disagree with the resolution of your report, you may appeal by contacting the project maintainers. Appeals will be reviewed by a different member of the community leadership team.

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage], version 2.1, available at [https://www.contributor-covenant.org/version/2/1/code_of_conduct.html][v2.1].

Community Impact Guidelines were inspired by [Mozilla's code of conduct enforcement ladder][Mozilla CoC].

For answers to common questions about this code of conduct, see the FAQ at [https://www.contributor-covenant.org/faq][FAQ]. Translations are available at [https://www.contributor-covenant.org/translations][translations].

[homepage]: https://www.contributor-covenant.org
[v2.1]: https://www.contributor-covenant.org/version/2/1/code_of_conduct.html
[Mozilla CoC]: https://github.com/mozilla/diversity
[FAQ]: https://www.contributor-covenant.org/faq
[translations]: https://www.contributor-covenant.org/translations

## Project-Specific Guidelines

### For aiogram-sentinel

In addition to the general Code of Conduct, we have specific guidelines for our project:

#### Technical Discussions

- **Be constructive**: Focus on improving the code and documentation
- **Provide context**: Include relevant code examples and error messages
- **Be patient**: Remember that everyone is learning and contributing

#### Issue and Pull Request Guidelines

- **Use clear titles**: Make it easy to understand what the issue or PR is about
- **Provide details**: Include steps to reproduce, expected behavior, and actual behavior
- **Be responsive**: Respond to feedback and questions promptly

#### Code Review

- **Be respectful**: Focus on the code, not the person
- **Be specific**: Point out exact lines and suggest improvements
- **Be appreciative**: Acknowledge good work and improvements

#### Community Support

- **Help others**: Share your knowledge and experience
- **Be inclusive**: Welcome newcomers and help them get started
- **Be patient**: Everyone has different levels of experience

## Contact

For questions about this Code of Conduct or to report violations:

- **Email**: conduct@aiogram-sentinel.dev
- **GitHub**: [Create a private issue](https://github.com/ArmanAvanesyan/aiogram-sentinel/issues/new?template=security_issue.yml)

## Updates

This Code of Conduct may be updated from time to time. Changes will be communicated through:

- GitHub releases
- Project announcements
- Community discussions

Last updated: September 2024
