#
#   Copyright 2024 Hopsworks AB
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
#

from hopsworks_common.constants import (
    ARTIFACT_VERSION,
    DEFAULT,
    DEPLOYABLE_COMPONENT,
    DEPLOYMENT,
    ENV_VARS,
    GIT,
    HOSTS,
    INFERENCE_BATCHER,
    INFERENCE_ENDPOINTS,
    INFERENCE_LOGGER,
    JOBS,
    KAFKA_CONSUMER_CONFIG,
    KAFKA_PRODUCER_CONFIG,
    KAFKA_SSL_CONFIG,
    KAFKA_TOPIC,
    MODEL,
    MODEL_REGISTRY,
    MODEL_SERVING,
    OPENSEARCH_CONFIG,
    PREDICTOR,
    PREDICTOR_STATE,
    RESOURCES,
    SERVICES,
    SSL_CONFIG,
    Default,
)


__all__ = [
    "ARTIFACT_VERSION",
    "DEFAULT",
    "DEPLOYABLE_COMPONENT",
    "DEPLOYMENT",
    "ENV_VARS",
    "GIT",
    "HOSTS",
    "INFERENCE_BATCHER",
    "INFERENCE_ENDPOINTS",
    "INFERENCE_LOGGER",
    "JOBS",
    "KAFKA_CONSUMER_CONFIG",
    "KAFKA_PRODUCER_CONFIG",
    "KAFKA_SSL_CONFIG",
    "KAFKA_TOPIC",
    "MODEL",
    "MODEL_REGISTRY",
    "MODEL_SERVING",
    "OPENSEARCH_CONFIG",
    "PREDICTOR",
    "PREDICTOR_STATE",
    "RESOURCES",
    "SERVICES",
    "SSL_CONFIG",
    "Default",
]
