# mypy-boto3-iot1click-projects

[![PyPI - mypy-boto3-iot1click-projects](https://img.shields.io/pypi/v/mypy-boto3-iot1click-projects.svg?color=blue)](https://pypi.org/project/mypy-boto3-iot1click-projects)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-iot1click-projects.svg?color=blue)](https://pypi.org/project/mypy-boto3-iot1click-projects)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-iot1click-projects?color=blue)](https://pypistats.org/packages/mypy-boto3-iot1click-projects)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.IoT1ClickProjects 1.17.65](https://boto3.amazonaws.com/v1/documentation/api/1.17.65/reference/services/iot1click-projects.html#IoT1ClickProjects)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.10.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-iot1click-projects docs](https://github.com/vemel/mypy_boto3_builder/service_docs/mypy_boto3_iot1click_projects/README.md)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-iot1click-projects](#mypy-boto3-iot1click-projects)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)

## How to install

Install `boto3-stubs` for `IoT1ClickProjects` service.

```bash
python -m pip install boto3-stubs[iot1click-projects]
```

## Usage

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[iot1click-projects]` in your environment:
  `python -m pip install 'boto3-stubs[iot1click-projects]'`

Both type checking and auto-complete should work for `IoT1ClickProjects`
service. No explicit type annotations required, write your `boto3` code as
usual.

### PyCharm

- Install `boto-stubs[iot1click-projects]` in your environment:
  `python -m pip install 'boto3-stubs[iot1click-projects]'`

Both type checking and auto-complete should work for `IoT1ClickProjects`
service. No explicit type annotations required, write your `boto3` code as
usual. Auto-complete can be slow on big projects or if you have a lot of
installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[iot1click-projects]` in your environment:
  `python -m pip install 'boto3-stubs[iot1click-projects]'`
- Run `mypy` as usual

Type checking should work for `IoT1ClickProjects` service. No explicit type
annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[iot1click-projects]` in your environment:
  `python -m pip install 'boto3-stubs[iot1click-projects]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `IoT1ClickProjects` service. No explicit type
annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`IoT1ClickProjectsClient` provides annotations for
`boto3.client("iot1click-projects")`.

```python
import boto3

from mypy_boto3_iot1click_projects import IoT1ClickProjectsClient

client: IoT1ClickProjectsClient = boto3.client("iot1click-projects")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: IoT1ClickProjectsClient = session.client("iot1click-projects")
```

### Paginators annotations

`mypy_boto3_iot1click_projects.paginator` module contains type annotations for
all paginators.

```python
from mypy_boto3_iot1click_projects import IoT1ClickProjectsClient
from mypy_boto3_iot1click_projects.paginator import (
    ListPlacementsPaginator,
    ListProjectsPaginator,
)

client: IoT1ClickProjectsClient = boto3.client("iot1click-projects")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_placements_paginator: ListPlacementsPaginator = client.get_paginator("list_placements")
list_projects_paginator: ListProjectsPaginator = client.get_paginator("list_projects")
```

### Literals

`mypy_boto3_iot1click_projects.literals` module contains literals extracted
from shapes that can be used in user code for type checking.

```python
from mypy_boto3_iot1click_projects.literals import (
    ListPlacementsPaginatorName,
    ListProjectsPaginatorName,
)

def check_value(value: ListPlacementsPaginatorName) -> bool:
    ...
```

### Typed dictionaries

`mypy_boto3_iot1click_projects.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_iot1click_projects.type_defs import (
    DescribePlacementResponseTypeDef,
    DescribeProjectResponseTypeDef,
    DeviceTemplateTypeDef,
    GetDevicesInPlacementResponseTypeDef,
    ListPlacementsResponseTypeDef,
    ListProjectsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    PaginatorConfigTypeDef,
    PlacementDescriptionTypeDef,
    PlacementSummaryTypeDef,
    PlacementTemplateTypeDef,
    ProjectDescriptionTypeDef,
    ProjectSummaryTypeDef,
)

def get_structure() -> DescribePlacementResponseTypeDef:
    return {
      ...
    }
```
