# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AzureGatewayArgs', 'AzureGateway']

@pulumi.input_type
class AzureGatewayArgs:
    def __init__(__self__, *,
                 azure_func_region: pulumi.Input[_builtins.str],
                 cloud_connector_id: pulumi.Input[_builtins.str],
                 delete_cloud_resources_on_destroy: pulumi.Input[_builtins.bool],
                 host_name: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 resource_group: pulumi.Input[_builtins.str],
                 vpc: pulumi.Input[_builtins.str],
                 app_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 frontend_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_size: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AzureGateway resource.
        :param pulumi.Input[_builtins.str] azure_func_region: Region in which azure cloud function will be provisioned
        :param pulumi.Input[_builtins.str] cloud_connector_id: Id of the cloud connector
        :param pulumi.Input[_builtins.str] host_name: Hostname for the proxy
        :param pulumi.Input[_builtins.str] region: Region in which cloud resources are hosted
        :param pulumi.Input[_builtins.str] resource_group: Resource group in which cloud resources are hosted
        :param pulumi.Input[_builtins.str] vpc: VNet in which cloud resources are hosted. Required only for creating new AppGateway
        :param pulumi.Input[_builtins.str] app_gateway_id: ID of Azure AppGateway for importing. Required only for importing exiging AppGateway
        :param pulumi.Input[_builtins.str] certificate_id: ID of existing SSL certificate from AppGateway being imported. Required only for importing existing AppGateway. Required only for SSL based rules
        :param pulumi.Input[_builtins.str] frontend_ip: ID of IP address to be used. Required only for creating new AppGateway. See https://learn.microsoft.com/en-us/azure/application-gateway/application-gateway-components#static-versus-dynamic-public-ip-address for more details
        :param pulumi.Input[_builtins.str] name: Name of the proxy
        :param pulumi.Input[_builtins.str] sku_size: Size of machine used for the gateway. Required only for creating new AppGateway
        :param pulumi.Input[_builtins.str] subnet_id: Subnet in which cloud resources are hosted. Required only for creating new AppGateway
        """
        pulumi.set(__self__, "azure_func_region", azure_func_region)
        pulumi.set(__self__, "cloud_connector_id", cloud_connector_id)
        pulumi.set(__self__, "delete_cloud_resources_on_destroy", delete_cloud_resources_on_destroy)
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "resource_group", resource_group)
        pulumi.set(__self__, "vpc", vpc)
        if app_gateway_id is not None:
            pulumi.set(__self__, "app_gateway_id", app_gateway_id)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if frontend_ip is not None:
            pulumi.set(__self__, "frontend_ip", frontend_ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sku_size is not None:
            pulumi.set(__self__, "sku_size", sku_size)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="azureFuncRegion")
    def azure_func_region(self) -> pulumi.Input[_builtins.str]:
        """
        Region in which azure cloud function will be provisioned
        """
        return pulumi.get(self, "azure_func_region")

    @azure_func_region.setter
    def azure_func_region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "azure_func_region", value)

    @_builtins.property
    @pulumi.getter(name="cloudConnectorId")
    def cloud_connector_id(self) -> pulumi.Input[_builtins.str]:
        """
        Id of the cloud connector
        """
        return pulumi.get(self, "cloud_connector_id")

    @cloud_connector_id.setter
    def cloud_connector_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cloud_connector_id", value)

    @_builtins.property
    @pulumi.getter(name="deleteCloudResourcesOnDestroy")
    def delete_cloud_resources_on_destroy(self) -> pulumi.Input[_builtins.bool]:
        return pulumi.get(self, "delete_cloud_resources_on_destroy")

    @delete_cloud_resources_on_destroy.setter
    def delete_cloud_resources_on_destroy(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "delete_cloud_resources_on_destroy", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Input[_builtins.str]:
        """
        Hostname for the proxy
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        Region in which cloud resources are hosted
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> pulumi.Input[_builtins.str]:
        """
        Resource group in which cloud resources are hosted
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group", value)

    @_builtins.property
    @pulumi.getter
    def vpc(self) -> pulumi.Input[_builtins.str]:
        """
        VNet in which cloud resources are hosted. Required only for creating new AppGateway
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc", value)

    @_builtins.property
    @pulumi.getter(name="appGatewayId")
    def app_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of Azure AppGateway for importing. Required only for importing exiging AppGateway
        """
        return pulumi.get(self, "app_gateway_id")

    @app_gateway_id.setter
    def app_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of existing SSL certificate from AppGateway being imported. Required only for importing existing AppGateway. Required only for SSL based rules
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="frontendIp")
    def frontend_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of IP address to be used. Required only for creating new AppGateway. See https://learn.microsoft.com/en-us/azure/application-gateway/application-gateway-components#static-versus-dynamic-public-ip-address for more details
        """
        return pulumi.get(self, "frontend_ip")

    @frontend_ip.setter
    def frontend_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "frontend_ip", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the proxy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="skuSize")
    def sku_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Size of machine used for the gateway. Required only for creating new AppGateway
        """
        return pulumi.get(self, "sku_size")

    @sku_size.setter
    def sku_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_size", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subnet in which cloud resources are hosted. Required only for creating new AppGateway
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class _AzureGatewayState:
    def __init__(__self__, *,
                 app_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_func_region: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_connector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_cloud_resources_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 frontend_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_size: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AzureGateway resources.
        :param pulumi.Input[_builtins.str] app_gateway_id: ID of Azure AppGateway for importing. Required only for importing exiging AppGateway
        :param pulumi.Input[_builtins.str] azure_func_region: Region in which azure cloud function will be provisioned
        :param pulumi.Input[_builtins.str] certificate_id: ID of existing SSL certificate from AppGateway being imported. Required only for importing existing AppGateway. Required only for SSL based rules
        :param pulumi.Input[_builtins.str] cloud_connector_id: Id of the cloud connector
        :param pulumi.Input[_builtins.str] frontend_ip: ID of IP address to be used. Required only for creating new AppGateway. See https://learn.microsoft.com/en-us/azure/application-gateway/application-gateway-components#static-versus-dynamic-public-ip-address for more details
        :param pulumi.Input[_builtins.str] host_name: Hostname for the proxy
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource
        :param pulumi.Input[_builtins.str] name: Name of the proxy
        :param pulumi.Input[_builtins.str] region: Region in which cloud resources are hosted
        :param pulumi.Input[_builtins.str] resource_group: Resource group in which cloud resources are hosted
        :param pulumi.Input[_builtins.str] sku_size: Size of machine used for the gateway. Required only for creating new AppGateway
        :param pulumi.Input[_builtins.str] subnet_id: Subnet in which cloud resources are hosted. Required only for creating new AppGateway
        :param pulumi.Input[_builtins.str] vpc: VNet in which cloud resources are hosted. Required only for creating new AppGateway
        """
        if app_gateway_id is not None:
            pulumi.set(__self__, "app_gateway_id", app_gateway_id)
        if azure_func_region is not None:
            pulumi.set(__self__, "azure_func_region", azure_func_region)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if cloud_connector_id is not None:
            pulumi.set(__self__, "cloud_connector_id", cloud_connector_id)
        if delete_cloud_resources_on_destroy is not None:
            pulumi.set(__self__, "delete_cloud_resources_on_destroy", delete_cloud_resources_on_destroy)
        if frontend_ip is not None:
            pulumi.set(__self__, "frontend_ip", frontend_ip)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if sku_size is not None:
            pulumi.set(__self__, "sku_size", sku_size)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)

    @_builtins.property
    @pulumi.getter(name="appGatewayId")
    def app_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of Azure AppGateway for importing. Required only for importing exiging AppGateway
        """
        return pulumi.get(self, "app_gateway_id")

    @app_gateway_id.setter
    def app_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="azureFuncRegion")
    def azure_func_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region in which azure cloud function will be provisioned
        """
        return pulumi.get(self, "azure_func_region")

    @azure_func_region.setter
    def azure_func_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "azure_func_region", value)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of existing SSL certificate from AppGateway being imported. Required only for importing existing AppGateway. Required only for SSL based rules
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="cloudConnectorId")
    def cloud_connector_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the cloud connector
        """
        return pulumi.get(self, "cloud_connector_id")

    @cloud_connector_id.setter
    def cloud_connector_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_connector_id", value)

    @_builtins.property
    @pulumi.getter(name="deleteCloudResourcesOnDestroy")
    def delete_cloud_resources_on_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "delete_cloud_resources_on_destroy")

    @delete_cloud_resources_on_destroy.setter
    def delete_cloud_resources_on_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_cloud_resources_on_destroy", value)

    @_builtins.property
    @pulumi.getter(name="frontendIp")
    def frontend_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of IP address to be used. Required only for creating new AppGateway. See https://learn.microsoft.com/en-us/azure/application-gateway/application-gateway-components#static-versus-dynamic-public-ip-address for more details
        """
        return pulumi.get(self, "frontend_ip")

    @frontend_ip.setter
    def frontend_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "frontend_ip", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Hostname for the proxy
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the resource
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the proxy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region in which cloud resources are hosted
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource group in which cloud resources are hosted
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group", value)

    @_builtins.property
    @pulumi.getter(name="skuSize")
    def sku_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Size of machine used for the gateway. Required only for creating new AppGateway
        """
        return pulumi.get(self, "sku_size")

    @sku_size.setter
    def sku_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_size", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subnet in which cloud resources are hosted. Required only for creating new AppGateway
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def vpc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VNet in which cloud resources are hosted. Required only for creating new AppGateway
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc", value)


@pulumi.type_token("harness:autostopping/azureGateway:AzureGateway")
class AzureGateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_func_region: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_connector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_cloud_resources_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 frontend_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_size: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for creating an Azure Application Gateway

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        test = harness.autostopping.AzureGateway("test",
            name="name",
            cloud_connector_id="cloud_connector_id",
            host_name="host_name",
            region="eastus2",
            resource_group="resource_group",
            subnet_id="/subscriptions/subscription_id/resourceGroups/resource_group/providers/Microsoft.Network/virtualNetworks/virtual_network/subnets/subnet_id",
            vpc="/subscriptions/subscription_id/resourceGroups/resource_group/providers/Microsoft.Network/virtualNetworks/virtual_network",
            azure_func_region="westus2",
            frontend_ip="/subscriptions/subscription_id/resourceGroups/resource_group/providers/Microsoft.Network/publicIPAddresses/publicip",
            sku_size="sku2",
            delete_cloud_resources_on_destroy=True)
        import_test = harness.autostopping.AzureGateway("import_test",
            name="import_test",
            cloud_connector_id="cloud_connector_id",
            host_name="host_name",
            region="westus2",
            resource_group="test_resource_group",
            app_gateway_id="/subscriptions/subscription_id/resourceGroups/test_resource_group/providers/Microsoft.Network/applicationGateways/TestAppGateway",
            certificate_id="/subscriptions/subscription_id/resourceGroups/test_resource_group/providers/Microsoft.Network/applicationGateways/TestAppGateway/sslCertificates/certificate_name",
            azure_func_region="westus2",
            vpc="/subscriptions/subscription_id/resourceGroups/test_resource_group/providers/Microsoft.Network/virtualNetworks/test_resource_group_vnet",
            delete_cloud_resources_on_destroy=False)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_gateway_id: ID of Azure AppGateway for importing. Required only for importing exiging AppGateway
        :param pulumi.Input[_builtins.str] azure_func_region: Region in which azure cloud function will be provisioned
        :param pulumi.Input[_builtins.str] certificate_id: ID of existing SSL certificate from AppGateway being imported. Required only for importing existing AppGateway. Required only for SSL based rules
        :param pulumi.Input[_builtins.str] cloud_connector_id: Id of the cloud connector
        :param pulumi.Input[_builtins.str] frontend_ip: ID of IP address to be used. Required only for creating new AppGateway. See https://learn.microsoft.com/en-us/azure/application-gateway/application-gateway-components#static-versus-dynamic-public-ip-address for more details
        :param pulumi.Input[_builtins.str] host_name: Hostname for the proxy
        :param pulumi.Input[_builtins.str] name: Name of the proxy
        :param pulumi.Input[_builtins.str] region: Region in which cloud resources are hosted
        :param pulumi.Input[_builtins.str] resource_group: Resource group in which cloud resources are hosted
        :param pulumi.Input[_builtins.str] sku_size: Size of machine used for the gateway. Required only for creating new AppGateway
        :param pulumi.Input[_builtins.str] subnet_id: Subnet in which cloud resources are hosted. Required only for creating new AppGateway
        :param pulumi.Input[_builtins.str] vpc: VNet in which cloud resources are hosted. Required only for creating new AppGateway
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureGatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating an Azure Application Gateway

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        test = harness.autostopping.AzureGateway("test",
            name="name",
            cloud_connector_id="cloud_connector_id",
            host_name="host_name",
            region="eastus2",
            resource_group="resource_group",
            subnet_id="/subscriptions/subscription_id/resourceGroups/resource_group/providers/Microsoft.Network/virtualNetworks/virtual_network/subnets/subnet_id",
            vpc="/subscriptions/subscription_id/resourceGroups/resource_group/providers/Microsoft.Network/virtualNetworks/virtual_network",
            azure_func_region="westus2",
            frontend_ip="/subscriptions/subscription_id/resourceGroups/resource_group/providers/Microsoft.Network/publicIPAddresses/publicip",
            sku_size="sku2",
            delete_cloud_resources_on_destroy=True)
        import_test = harness.autostopping.AzureGateway("import_test",
            name="import_test",
            cloud_connector_id="cloud_connector_id",
            host_name="host_name",
            region="westus2",
            resource_group="test_resource_group",
            app_gateway_id="/subscriptions/subscription_id/resourceGroups/test_resource_group/providers/Microsoft.Network/applicationGateways/TestAppGateway",
            certificate_id="/subscriptions/subscription_id/resourceGroups/test_resource_group/providers/Microsoft.Network/applicationGateways/TestAppGateway/sslCertificates/certificate_name",
            azure_func_region="westus2",
            vpc="/subscriptions/subscription_id/resourceGroups/test_resource_group/providers/Microsoft.Network/virtualNetworks/test_resource_group_vnet",
            delete_cloud_resources_on_destroy=False)
        ```

        :param str resource_name: The name of the resource.
        :param AzureGatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureGatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_func_region: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_connector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_cloud_resources_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 frontend_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_size: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureGatewayArgs.__new__(AzureGatewayArgs)

            __props__.__dict__["app_gateway_id"] = app_gateway_id
            if azure_func_region is None and not opts.urn:
                raise TypeError("Missing required property 'azure_func_region'")
            __props__.__dict__["azure_func_region"] = azure_func_region
            __props__.__dict__["certificate_id"] = certificate_id
            if cloud_connector_id is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_connector_id'")
            __props__.__dict__["cloud_connector_id"] = cloud_connector_id
            if delete_cloud_resources_on_destroy is None and not opts.urn:
                raise TypeError("Missing required property 'delete_cloud_resources_on_destroy'")
            __props__.__dict__["delete_cloud_resources_on_destroy"] = delete_cloud_resources_on_destroy
            __props__.__dict__["frontend_ip"] = frontend_ip
            if host_name is None and not opts.urn:
                raise TypeError("Missing required property 'host_name'")
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["name"] = name
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            if resource_group is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group'")
            __props__.__dict__["resource_group"] = resource_group
            __props__.__dict__["sku_size"] = sku_size
            __props__.__dict__["subnet_id"] = subnet_id
            if vpc is None and not opts.urn:
                raise TypeError("Missing required property 'vpc'")
            __props__.__dict__["vpc"] = vpc
            __props__.__dict__["identifier"] = None
        super(AzureGateway, __self__).__init__(
            'harness:autostopping/azureGateway:AzureGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            azure_func_region: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_connector_id: Optional[pulumi.Input[_builtins.str]] = None,
            delete_cloud_resources_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            frontend_ip: Optional[pulumi.Input[_builtins.str]] = None,
            host_name: Optional[pulumi.Input[_builtins.str]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group: Optional[pulumi.Input[_builtins.str]] = None,
            sku_size: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpc: Optional[pulumi.Input[_builtins.str]] = None) -> 'AzureGateway':
        """
        Get an existing AzureGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_gateway_id: ID of Azure AppGateway for importing. Required only for importing exiging AppGateway
        :param pulumi.Input[_builtins.str] azure_func_region: Region in which azure cloud function will be provisioned
        :param pulumi.Input[_builtins.str] certificate_id: ID of existing SSL certificate from AppGateway being imported. Required only for importing existing AppGateway. Required only for SSL based rules
        :param pulumi.Input[_builtins.str] cloud_connector_id: Id of the cloud connector
        :param pulumi.Input[_builtins.str] frontend_ip: ID of IP address to be used. Required only for creating new AppGateway. See https://learn.microsoft.com/en-us/azure/application-gateway/application-gateway-components#static-versus-dynamic-public-ip-address for more details
        :param pulumi.Input[_builtins.str] host_name: Hostname for the proxy
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource
        :param pulumi.Input[_builtins.str] name: Name of the proxy
        :param pulumi.Input[_builtins.str] region: Region in which cloud resources are hosted
        :param pulumi.Input[_builtins.str] resource_group: Resource group in which cloud resources are hosted
        :param pulumi.Input[_builtins.str] sku_size: Size of machine used for the gateway. Required only for creating new AppGateway
        :param pulumi.Input[_builtins.str] subnet_id: Subnet in which cloud resources are hosted. Required only for creating new AppGateway
        :param pulumi.Input[_builtins.str] vpc: VNet in which cloud resources are hosted. Required only for creating new AppGateway
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureGatewayState.__new__(_AzureGatewayState)

        __props__.__dict__["app_gateway_id"] = app_gateway_id
        __props__.__dict__["azure_func_region"] = azure_func_region
        __props__.__dict__["certificate_id"] = certificate_id
        __props__.__dict__["cloud_connector_id"] = cloud_connector_id
        __props__.__dict__["delete_cloud_resources_on_destroy"] = delete_cloud_resources_on_destroy
        __props__.__dict__["frontend_ip"] = frontend_ip
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_group"] = resource_group
        __props__.__dict__["sku_size"] = sku_size
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["vpc"] = vpc
        return AzureGateway(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appGatewayId")
    def app_gateway_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of Azure AppGateway for importing. Required only for importing exiging AppGateway
        """
        return pulumi.get(self, "app_gateway_id")

    @_builtins.property
    @pulumi.getter(name="azureFuncRegion")
    def azure_func_region(self) -> pulumi.Output[_builtins.str]:
        """
        Region in which azure cloud function will be provisioned
        """
        return pulumi.get(self, "azure_func_region")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of existing SSL certificate from AppGateway being imported. Required only for importing existing AppGateway. Required only for SSL based rules
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter(name="cloudConnectorId")
    def cloud_connector_id(self) -> pulumi.Output[_builtins.str]:
        """
        Id of the cloud connector
        """
        return pulumi.get(self, "cloud_connector_id")

    @_builtins.property
    @pulumi.getter(name="deleteCloudResourcesOnDestroy")
    def delete_cloud_resources_on_destroy(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "delete_cloud_resources_on_destroy")

    @_builtins.property
    @pulumi.getter(name="frontendIp")
    def frontend_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of IP address to be used. Required only for creating new AppGateway. See https://learn.microsoft.com/en-us/azure/application-gateway/application-gateway-components#static-versus-dynamic-public-ip-address for more details
        """
        return pulumi.get(self, "frontend_ip")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[_builtins.str]:
        """
        Hostname for the proxy
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the resource
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the proxy
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region in which cloud resources are hosted
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> pulumi.Output[_builtins.str]:
        """
        Resource group in which cloud resources are hosted
        """
        return pulumi.get(self, "resource_group")

    @_builtins.property
    @pulumi.getter(name="skuSize")
    def sku_size(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Size of machine used for the gateway. Required only for creating new AppGateway
        """
        return pulumi.get(self, "sku_size")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Subnet in which cloud resources are hosted. Required only for creating new AppGateway
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def vpc(self) -> pulumi.Output[_builtins.str]:
        """
        VNet in which cloud resources are hosted. Required only for creating new AppGateway
        """
        return pulumi.get(self, "vpc")

