# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetImageRegistryResult',
    'AwaitableGetImageRegistryResult',
    'get_image_registry',
    'get_image_registry_output',
]

@pulumi.output_type
class GetImageRegistryResult:
    """
    A collection of values returned by getImageRegistry.
    """
    def __init__(__self__, check_override=None, created_at=None, custom_images=None, id=None, infra_id=None, is_default=None, is_override_allowed=None, is_private=None, org_id=None, override_blocked_by_scope=None, project_id=None, registry_account=None, registry_server=None, secret_name=None, updated_at=None, use_custom_images=None):
        if check_override and not isinstance(check_override, bool):
            raise TypeError("Expected argument 'check_override' to be a bool")
        pulumi.set(__self__, "check_override", check_override)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if custom_images and not isinstance(custom_images, list):
            raise TypeError("Expected argument 'custom_images' to be a list")
        pulumi.set(__self__, "custom_images", custom_images)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if infra_id and not isinstance(infra_id, str):
            raise TypeError("Expected argument 'infra_id' to be a str")
        pulumi.set(__self__, "infra_id", infra_id)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if is_override_allowed and not isinstance(is_override_allowed, bool):
            raise TypeError("Expected argument 'is_override_allowed' to be a bool")
        pulumi.set(__self__, "is_override_allowed", is_override_allowed)
        if is_private and not isinstance(is_private, bool):
            raise TypeError("Expected argument 'is_private' to be a bool")
        pulumi.set(__self__, "is_private", is_private)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if override_blocked_by_scope and not isinstance(override_blocked_by_scope, str):
            raise TypeError("Expected argument 'override_blocked_by_scope' to be a str")
        pulumi.set(__self__, "override_blocked_by_scope", override_blocked_by_scope)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if registry_account and not isinstance(registry_account, str):
            raise TypeError("Expected argument 'registry_account' to be a str")
        pulumi.set(__self__, "registry_account", registry_account)
        if registry_server and not isinstance(registry_server, str):
            raise TypeError("Expected argument 'registry_server' to be a str")
        pulumi.set(__self__, "registry_server", registry_server)
        if secret_name and not isinstance(secret_name, str):
            raise TypeError("Expected argument 'secret_name' to be a str")
        pulumi.set(__self__, "secret_name", secret_name)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if use_custom_images and not isinstance(use_custom_images, bool):
            raise TypeError("Expected argument 'use_custom_images' to be a bool")
        pulumi.set(__self__, "use_custom_images", use_custom_images)

    @_builtins.property
    @pulumi.getter(name="checkOverride")
    def check_override(self) -> Optional[_builtins.bool]:
        """
        Whether to check if override is allowed
        """
        return pulumi.get(self, "check_override")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Creation timestamp
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="customImages")
    def custom_images(self) -> Sequence['outputs.GetImageRegistryCustomImageResult']:
        """
        Custom images configuration
        """
        return pulumi.get(self, "custom_images")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="infraId")
    def infra_id(self) -> Optional[_builtins.str]:
        """
        The infrastructure ID to set up the image registry
        """
        return pulumi.get(self, "infra_id")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        """
        Whether this is the default registry
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter(name="isOverrideAllowed")
    def is_override_allowed(self) -> _builtins.bool:
        """
        Whether override is allowed for this registry
        """
        return pulumi.get(self, "is_override_allowed")

    @_builtins.property
    @pulumi.getter(name="isPrivate")
    def is_private(self) -> _builtins.bool:
        """
        Whether the registry is private
        """
        return pulumi.get(self, "is_private")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[_builtins.str]:
        """
        The organization ID of the image registry
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="overrideBlockedByScope")
    def override_blocked_by_scope(self) -> _builtins.str:
        """
        Indicates if override is blocked by scope (only populated if check_override is true)
        """
        return pulumi.get(self, "override_blocked_by_scope")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        The project ID of the image registry
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="registryAccount")
    def registry_account(self) -> _builtins.str:
        """
        The registry account name
        """
        return pulumi.get(self, "registry_account")

    @_builtins.property
    @pulumi.getter(name="registryServer")
    def registry_server(self) -> _builtins.str:
        """
        The registry server URL
        """
        return pulumi.get(self, "registry_server")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> _builtins.str:
        """
        The name of the secret for authentication
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Last update timestamp
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="useCustomImages")
    def use_custom_images(self) -> _builtins.bool:
        """
        Whether custom images are used
        """
        return pulumi.get(self, "use_custom_images")


class AwaitableGetImageRegistryResult(GetImageRegistryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImageRegistryResult(
            check_override=self.check_override,
            created_at=self.created_at,
            custom_images=self.custom_images,
            id=self.id,
            infra_id=self.infra_id,
            is_default=self.is_default,
            is_override_allowed=self.is_override_allowed,
            is_private=self.is_private,
            org_id=self.org_id,
            override_blocked_by_scope=self.override_blocked_by_scope,
            project_id=self.project_id,
            registry_account=self.registry_account,
            registry_server=self.registry_server,
            secret_name=self.secret_name,
            updated_at=self.updated_at,
            use_custom_images=self.use_custom_images)


def get_image_registry(check_override: Optional[_builtins.bool] = None,
                       infra_id: Optional[_builtins.str] = None,
                       org_id: Optional[_builtins.str] = None,
                       project_id: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImageRegistryResult:
    """
    Data source for retrieving a Harness Chaos Image Registry and checking override status

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    # Data source to verify the registry
    example = harness.chaos.get_image_registry(org_id="<org_id>",
        project_id="<project_id>")
    # Example of checking override status
    override_check = harness.chaos.get_image_registry(org_id="<org_id>",
        project_id="<project_id>",
        check_override=True)
    ```


    :param _builtins.bool check_override: Whether to check if override is allowed
    :param _builtins.str infra_id: The infrastructure ID to set up the image registry
    :param _builtins.str org_id: The organization ID of the image registry
    :param _builtins.str project_id: The project ID of the image registry
    """
    __args__ = dict()
    __args__['checkOverride'] = check_override
    __args__['infraId'] = infra_id
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:chaos/getImageRegistry:getImageRegistry', __args__, opts=opts, typ=GetImageRegistryResult).value

    return AwaitableGetImageRegistryResult(
        check_override=pulumi.get(__ret__, 'check_override'),
        created_at=pulumi.get(__ret__, 'created_at'),
        custom_images=pulumi.get(__ret__, 'custom_images'),
        id=pulumi.get(__ret__, 'id'),
        infra_id=pulumi.get(__ret__, 'infra_id'),
        is_default=pulumi.get(__ret__, 'is_default'),
        is_override_allowed=pulumi.get(__ret__, 'is_override_allowed'),
        is_private=pulumi.get(__ret__, 'is_private'),
        org_id=pulumi.get(__ret__, 'org_id'),
        override_blocked_by_scope=pulumi.get(__ret__, 'override_blocked_by_scope'),
        project_id=pulumi.get(__ret__, 'project_id'),
        registry_account=pulumi.get(__ret__, 'registry_account'),
        registry_server=pulumi.get(__ret__, 'registry_server'),
        secret_name=pulumi.get(__ret__, 'secret_name'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        use_custom_images=pulumi.get(__ret__, 'use_custom_images'))
def get_image_registry_output(check_override: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                              infra_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              org_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetImageRegistryResult]:
    """
    Data source for retrieving a Harness Chaos Image Registry and checking override status

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    # Data source to verify the registry
    example = harness.chaos.get_image_registry(org_id="<org_id>",
        project_id="<project_id>")
    # Example of checking override status
    override_check = harness.chaos.get_image_registry(org_id="<org_id>",
        project_id="<project_id>",
        check_override=True)
    ```


    :param _builtins.bool check_override: Whether to check if override is allowed
    :param _builtins.str infra_id: The infrastructure ID to set up the image registry
    :param _builtins.str org_id: The organization ID of the image registry
    :param _builtins.str project_id: The project ID of the image registry
    """
    __args__ = dict()
    __args__['checkOverride'] = check_override
    __args__['infraId'] = infra_id
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:chaos/getImageRegistry:getImageRegistry', __args__, opts=opts, typ=GetImageRegistryResult)
    return __ret__.apply(lambda __response__: GetImageRegistryResult(
        check_override=pulumi.get(__response__, 'check_override'),
        created_at=pulumi.get(__response__, 'created_at'),
        custom_images=pulumi.get(__response__, 'custom_images'),
        id=pulumi.get(__response__, 'id'),
        infra_id=pulumi.get(__response__, 'infra_id'),
        is_default=pulumi.get(__response__, 'is_default'),
        is_override_allowed=pulumi.get(__response__, 'is_override_allowed'),
        is_private=pulumi.get(__response__, 'is_private'),
        org_id=pulumi.get(__response__, 'org_id'),
        override_blocked_by_scope=pulumi.get(__response__, 'override_blocked_by_scope'),
        project_id=pulumi.get(__response__, 'project_id'),
        registry_account=pulumi.get(__response__, 'registry_account'),
        registry_server=pulumi.get(__response__, 'registry_server'),
        secret_name=pulumi.get(__response__, 'secret_name'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        use_custom_images=pulumi.get(__response__, 'use_custom_images')))
