# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInfrastructureV2Result',
    'AwaitableGetInfrastructureV2Result',
    'get_infrastructure_v2',
    'get_infrastructure_v2_output',
]

@pulumi.output_type
class GetInfrastructureV2Result:
    """
    A collection of values returned by getInfrastructureV2.
    """
    def __init__(__self__, annotation=None, containers=None, created_at=None, created_by=None, description=None, environment_id=None, id=None, identifier=None, identity=None, image_registries=None, infra_id=None, infra_scope=None, infra_type=None, insecure_skip_verify=None, is_ai_enabled=None, is_chaos_enabled=None, label=None, last_heartbeat=None, last_workflow_timestamp=None, mtls=None, name=None, namespace=None, no_of_schedules=None, no_of_workflows=None, node_selector=None, org_id=None, project_id=None, proxy=None, run_as_group=None, run_as_user=None, service_account=None, status=None, tags=None, tolerations=None, update_status=None, updated_at=None, updated_by=None, volume_mounts=None, volumes=None):
        if annotation and not isinstance(annotation, dict):
            raise TypeError("Expected argument 'annotation' to be a dict")
        pulumi.set(__self__, "annotation", annotation)
        if containers and not isinstance(containers, str):
            raise TypeError("Expected argument 'containers' to be a str")
        pulumi.set(__self__, "containers", containers)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if environment_id and not isinstance(environment_id, str):
            raise TypeError("Expected argument 'environment_id' to be a str")
        pulumi.set(__self__, "environment_id", environment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if identity and not isinstance(identity, str):
            raise TypeError("Expected argument 'identity' to be a str")
        pulumi.set(__self__, "identity", identity)
        if image_registries and not isinstance(image_registries, list):
            raise TypeError("Expected argument 'image_registries' to be a list")
        pulumi.set(__self__, "image_registries", image_registries)
        if infra_id and not isinstance(infra_id, str):
            raise TypeError("Expected argument 'infra_id' to be a str")
        pulumi.set(__self__, "infra_id", infra_id)
        if infra_scope and not isinstance(infra_scope, str):
            raise TypeError("Expected argument 'infra_scope' to be a str")
        pulumi.set(__self__, "infra_scope", infra_scope)
        if infra_type and not isinstance(infra_type, str):
            raise TypeError("Expected argument 'infra_type' to be a str")
        pulumi.set(__self__, "infra_type", infra_type)
        if insecure_skip_verify and not isinstance(insecure_skip_verify, bool):
            raise TypeError("Expected argument 'insecure_skip_verify' to be a bool")
        pulumi.set(__self__, "insecure_skip_verify", insecure_skip_verify)
        if is_ai_enabled and not isinstance(is_ai_enabled, bool):
            raise TypeError("Expected argument 'is_ai_enabled' to be a bool")
        pulumi.set(__self__, "is_ai_enabled", is_ai_enabled)
        if is_chaos_enabled and not isinstance(is_chaos_enabled, bool):
            raise TypeError("Expected argument 'is_chaos_enabled' to be a bool")
        pulumi.set(__self__, "is_chaos_enabled", is_chaos_enabled)
        if label and not isinstance(label, dict):
            raise TypeError("Expected argument 'label' to be a dict")
        pulumi.set(__self__, "label", label)
        if last_heartbeat and not isinstance(last_heartbeat, int):
            raise TypeError("Expected argument 'last_heartbeat' to be a int")
        pulumi.set(__self__, "last_heartbeat", last_heartbeat)
        if last_workflow_timestamp and not isinstance(last_workflow_timestamp, str):
            raise TypeError("Expected argument 'last_workflow_timestamp' to be a str")
        pulumi.set(__self__, "last_workflow_timestamp", last_workflow_timestamp)
        if mtls and not isinstance(mtls, dict):
            raise TypeError("Expected argument 'mtls' to be a dict")
        pulumi.set(__self__, "mtls", mtls)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if no_of_schedules and not isinstance(no_of_schedules, int):
            raise TypeError("Expected argument 'no_of_schedules' to be a int")
        pulumi.set(__self__, "no_of_schedules", no_of_schedules)
        if no_of_workflows and not isinstance(no_of_workflows, int):
            raise TypeError("Expected argument 'no_of_workflows' to be a int")
        pulumi.set(__self__, "no_of_workflows", no_of_workflows)
        if node_selector and not isinstance(node_selector, dict):
            raise TypeError("Expected argument 'node_selector' to be a dict")
        pulumi.set(__self__, "node_selector", node_selector)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if proxy and not isinstance(proxy, dict):
            raise TypeError("Expected argument 'proxy' to be a dict")
        pulumi.set(__self__, "proxy", proxy)
        if run_as_group and not isinstance(run_as_group, int):
            raise TypeError("Expected argument 'run_as_group' to be a int")
        pulumi.set(__self__, "run_as_group", run_as_group)
        if run_as_user and not isinstance(run_as_user, int):
            raise TypeError("Expected argument 'run_as_user' to be a int")
        pulumi.set(__self__, "run_as_user", run_as_user)
        if service_account and not isinstance(service_account, str):
            raise TypeError("Expected argument 'service_account' to be a str")
        pulumi.set(__self__, "service_account", service_account)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tolerations and not isinstance(tolerations, list):
            raise TypeError("Expected argument 'tolerations' to be a list")
        pulumi.set(__self__, "tolerations", tolerations)
        if update_status and not isinstance(update_status, str):
            raise TypeError("Expected argument 'update_status' to be a str")
        pulumi.set(__self__, "update_status", update_status)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if updated_by and not isinstance(updated_by, str):
            raise TypeError("Expected argument 'updated_by' to be a str")
        pulumi.set(__self__, "updated_by", updated_by)
        if volume_mounts and not isinstance(volume_mounts, list):
            raise TypeError("Expected argument 'volume_mounts' to be a list")
        pulumi.set(__self__, "volume_mounts", volume_mounts)
        if volumes and not isinstance(volumes, list):
            raise TypeError("Expected argument 'volumes' to be a list")
        pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter
    def annotation(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "annotation")

    @_builtins.property
    @pulumi.getter
    def containers(self) -> _builtins.str:
        """
        List of containers in the infrastructure.
        """
        return pulumi.get(self, "containers")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Created at of the infrastructure.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        Created by of the infrastructure.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the infrastructure.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> _builtins.str:
        """
        The ID of the environment.
        """
        return pulumi.get(self, "environment_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> _builtins.str:
        """
        Identifier of the infrastructure.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> _builtins.str:
        """
        Identity of the infrastructure.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="imageRegistries")
    def image_registries(self) -> Sequence['outputs.GetInfrastructureV2ImageRegistryResult']:
        """
        Configuration for the container image registry.
        """
        return pulumi.get(self, "image_registries")

    @_builtins.property
    @pulumi.getter(name="infraId")
    def infra_id(self) -> _builtins.str:
        """
        The ID of the infrastructure.
        """
        return pulumi.get(self, "infra_id")

    @_builtins.property
    @pulumi.getter(name="infraScope")
    def infra_scope(self) -> _builtins.str:
        """
        Scope of the infrastructure.
        """
        return pulumi.get(self, "infra_scope")

    @_builtins.property
    @pulumi.getter(name="infraType")
    def infra_type(self) -> _builtins.str:
        """
        Type of the infrastructure.
        """
        return pulumi.get(self, "infra_type")

    @_builtins.property
    @pulumi.getter(name="insecureSkipVerify")
    def insecure_skip_verify(self) -> _builtins.bool:
        return pulumi.get(self, "insecure_skip_verify")

    @_builtins.property
    @pulumi.getter(name="isAiEnabled")
    def is_ai_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "is_ai_enabled")

    @_builtins.property
    @pulumi.getter(name="isChaosEnabled")
    def is_chaos_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "is_chaos_enabled")

    @_builtins.property
    @pulumi.getter
    def label(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="lastHeartbeat")
    def last_heartbeat(self) -> _builtins.int:
        """
        Last heartbeat of the infrastructure.
        """
        return pulumi.get(self, "last_heartbeat")

    @_builtins.property
    @pulumi.getter(name="lastWorkflowTimestamp")
    def last_workflow_timestamp(self) -> _builtins.str:
        """
        Last workflow timestamp of the infrastructure.
        """
        return pulumi.get(self, "last_workflow_timestamp")

    @_builtins.property
    @pulumi.getter
    def mtls(self) -> Optional['outputs.GetInfrastructureV2MtlsResult']:
        """
        mTLS configuration for the infrastructure.
        """
        return pulumi.get(self, "mtls")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the infrastructure.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        Kubernetes namespace for the infrastructure.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="noOfSchedules")
    def no_of_schedules(self) -> _builtins.int:
        """
        Number of schedules for the infrastructure.
        """
        return pulumi.get(self, "no_of_schedules")

    @_builtins.property
    @pulumi.getter(name="noOfWorkflows")
    def no_of_workflows(self) -> _builtins.int:
        """
        Number of workflows for the infrastructure.
        """
        return pulumi.get(self, "no_of_workflows")

    @_builtins.property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "node_selector")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> _builtins.str:
        """
        The ID of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def proxy(self) -> Optional['outputs.GetInfrastructureV2ProxyResult']:
        """
        Proxy configuration for the infrastructure.
        """
        return pulumi.get(self, "proxy")

    @_builtins.property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> _builtins.int:
        return pulumi.get(self, "run_as_group")

    @_builtins.property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> _builtins.int:
        return pulumi.get(self, "run_as_user")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> _builtins.str:
        """
        Service account used by the infrastructure.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the infrastructure.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Tags of the infrastructure.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def tolerations(self) -> Optional[Sequence['outputs.GetInfrastructureV2TolerationResult']]:
        """
        If specified, the pod's tolerations.
        """
        return pulumi.get(self, "tolerations")

    @_builtins.property
    @pulumi.getter(name="updateStatus")
    def update_status(self) -> _builtins.str:
        """
        Update status of the infrastructure.
        """
        return pulumi.get(self, "update_status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Updated at of the infrastructure.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> _builtins.str:
        """
        Updated by of the infrastructure.
        """
        return pulumi.get(self, "updated_by")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.GetInfrastructureV2VolumeMountResult']]:
        """
        Volume mounts for the container.
        """
        return pulumi.get(self, "volume_mounts")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.GetInfrastructureV2VolumeResult']]:
        """
        Volumes to be created in the infrastructure.
        """
        return pulumi.get(self, "volumes")


class AwaitableGetInfrastructureV2Result(GetInfrastructureV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInfrastructureV2Result(
            annotation=self.annotation,
            containers=self.containers,
            created_at=self.created_at,
            created_by=self.created_by,
            description=self.description,
            environment_id=self.environment_id,
            id=self.id,
            identifier=self.identifier,
            identity=self.identity,
            image_registries=self.image_registries,
            infra_id=self.infra_id,
            infra_scope=self.infra_scope,
            infra_type=self.infra_type,
            insecure_skip_verify=self.insecure_skip_verify,
            is_ai_enabled=self.is_ai_enabled,
            is_chaos_enabled=self.is_chaos_enabled,
            label=self.label,
            last_heartbeat=self.last_heartbeat,
            last_workflow_timestamp=self.last_workflow_timestamp,
            mtls=self.mtls,
            name=self.name,
            namespace=self.namespace,
            no_of_schedules=self.no_of_schedules,
            no_of_workflows=self.no_of_workflows,
            node_selector=self.node_selector,
            org_id=self.org_id,
            project_id=self.project_id,
            proxy=self.proxy,
            run_as_group=self.run_as_group,
            run_as_user=self.run_as_user,
            service_account=self.service_account,
            status=self.status,
            tags=self.tags,
            tolerations=self.tolerations,
            update_status=self.update_status,
            updated_at=self.updated_at,
            updated_by=self.updated_by,
            volume_mounts=self.volume_mounts,
            volumes=self.volumes)


def get_infrastructure_v2(environment_id: Optional[_builtins.str] = None,
                          image_registries: Optional[Sequence[Union['GetInfrastructureV2ImageRegistryArgs', 'GetInfrastructureV2ImageRegistryArgsDict']]] = None,
                          infra_id: Optional[_builtins.str] = None,
                          mtls: Optional[Union['GetInfrastructureV2MtlsArgs', 'GetInfrastructureV2MtlsArgsDict']] = None,
                          org_id: Optional[_builtins.str] = None,
                          project_id: Optional[_builtins.str] = None,
                          proxy: Optional[Union['GetInfrastructureV2ProxyArgs', 'GetInfrastructureV2ProxyArgsDict']] = None,
                          tolerations: Optional[Sequence[Union['GetInfrastructureV2TolerationArgs', 'GetInfrastructureV2TolerationArgsDict']]] = None,
                          volume_mounts: Optional[Sequence[Union['GetInfrastructureV2VolumeMountArgs', 'GetInfrastructureV2VolumeMountArgsDict']]] = None,
                          volumes: Optional[Sequence[Union['GetInfrastructureV2VolumeArgs', 'GetInfrastructureV2VolumeArgsDict']]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInfrastructureV2Result:
    """
    Data source for retrieving a Harness Chaos Infrastructure V2.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    # Data source to fetch a specific agent by name
    by_name = harness.service.get_discovery_agent(name="example-agent",
        org_identifier=org_identifier,
        project_identifier=project_identifier,
        environment_identifier=environment_identifier)
    pulumi.export("agentDetailsByName", by_name)
    # Data source to fetch a specific agent by identity
    by_identity = harness.service.get_discovery_agent(identity="example-infra",
        org_identifier=org_identifier,
        project_identifier=project_identifier,
        environment_identifier=environment_identifier)
    pulumi.export("agentDetailsByIdentity", by_identity)
    ```


    :param _builtins.str environment_id: The ID of the environment.
    :param Sequence[Union['GetInfrastructureV2ImageRegistryArgs', 'GetInfrastructureV2ImageRegistryArgsDict']] image_registries: Configuration for the container image registry.
    :param _builtins.str infra_id: The ID of the infrastructure.
    :param Union['GetInfrastructureV2MtlsArgs', 'GetInfrastructureV2MtlsArgsDict'] mtls: mTLS configuration for the infrastructure.
    :param _builtins.str org_id: The ID of the organization.
    :param _builtins.str project_id: The ID of the project.
    :param Union['GetInfrastructureV2ProxyArgs', 'GetInfrastructureV2ProxyArgsDict'] proxy: Proxy configuration for the infrastructure.
    :param Sequence[Union['GetInfrastructureV2TolerationArgs', 'GetInfrastructureV2TolerationArgsDict']] tolerations: If specified, the pod's tolerations.
    :param Sequence[Union['GetInfrastructureV2VolumeMountArgs', 'GetInfrastructureV2VolumeMountArgsDict']] volume_mounts: Volume mounts for the container.
    :param Sequence[Union['GetInfrastructureV2VolumeArgs', 'GetInfrastructureV2VolumeArgsDict']] volumes: Volumes to be created in the infrastructure.
    """
    __args__ = dict()
    __args__['environmentId'] = environment_id
    __args__['imageRegistries'] = image_registries
    __args__['infraId'] = infra_id
    __args__['mtls'] = mtls
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    __args__['proxy'] = proxy
    __args__['tolerations'] = tolerations
    __args__['volumeMounts'] = volume_mounts
    __args__['volumes'] = volumes
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:chaos/getInfrastructureV2:getInfrastructureV2', __args__, opts=opts, typ=GetInfrastructureV2Result).value

    return AwaitableGetInfrastructureV2Result(
        annotation=pulumi.get(__ret__, 'annotation'),
        containers=pulumi.get(__ret__, 'containers'),
        created_at=pulumi.get(__ret__, 'created_at'),
        created_by=pulumi.get(__ret__, 'created_by'),
        description=pulumi.get(__ret__, 'description'),
        environment_id=pulumi.get(__ret__, 'environment_id'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        identity=pulumi.get(__ret__, 'identity'),
        image_registries=pulumi.get(__ret__, 'image_registries'),
        infra_id=pulumi.get(__ret__, 'infra_id'),
        infra_scope=pulumi.get(__ret__, 'infra_scope'),
        infra_type=pulumi.get(__ret__, 'infra_type'),
        insecure_skip_verify=pulumi.get(__ret__, 'insecure_skip_verify'),
        is_ai_enabled=pulumi.get(__ret__, 'is_ai_enabled'),
        is_chaos_enabled=pulumi.get(__ret__, 'is_chaos_enabled'),
        label=pulumi.get(__ret__, 'label'),
        last_heartbeat=pulumi.get(__ret__, 'last_heartbeat'),
        last_workflow_timestamp=pulumi.get(__ret__, 'last_workflow_timestamp'),
        mtls=pulumi.get(__ret__, 'mtls'),
        name=pulumi.get(__ret__, 'name'),
        namespace=pulumi.get(__ret__, 'namespace'),
        no_of_schedules=pulumi.get(__ret__, 'no_of_schedules'),
        no_of_workflows=pulumi.get(__ret__, 'no_of_workflows'),
        node_selector=pulumi.get(__ret__, 'node_selector'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        proxy=pulumi.get(__ret__, 'proxy'),
        run_as_group=pulumi.get(__ret__, 'run_as_group'),
        run_as_user=pulumi.get(__ret__, 'run_as_user'),
        service_account=pulumi.get(__ret__, 'service_account'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        tolerations=pulumi.get(__ret__, 'tolerations'),
        update_status=pulumi.get(__ret__, 'update_status'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        updated_by=pulumi.get(__ret__, 'updated_by'),
        volume_mounts=pulumi.get(__ret__, 'volume_mounts'),
        volumes=pulumi.get(__ret__, 'volumes'))
def get_infrastructure_v2_output(environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 image_registries: Optional[pulumi.Input[Optional[Sequence[Union['GetInfrastructureV2ImageRegistryArgs', 'GetInfrastructureV2ImageRegistryArgsDict']]]]] = None,
                                 infra_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 mtls: Optional[pulumi.Input[Optional[Union['GetInfrastructureV2MtlsArgs', 'GetInfrastructureV2MtlsArgsDict']]]] = None,
                                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 proxy: Optional[pulumi.Input[Optional[Union['GetInfrastructureV2ProxyArgs', 'GetInfrastructureV2ProxyArgsDict']]]] = None,
                                 tolerations: Optional[pulumi.Input[Optional[Sequence[Union['GetInfrastructureV2TolerationArgs', 'GetInfrastructureV2TolerationArgsDict']]]]] = None,
                                 volume_mounts: Optional[pulumi.Input[Optional[Sequence[Union['GetInfrastructureV2VolumeMountArgs', 'GetInfrastructureV2VolumeMountArgsDict']]]]] = None,
                                 volumes: Optional[pulumi.Input[Optional[Sequence[Union['GetInfrastructureV2VolumeArgs', 'GetInfrastructureV2VolumeArgsDict']]]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInfrastructureV2Result]:
    """
    Data source for retrieving a Harness Chaos Infrastructure V2.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    # Data source to fetch a specific agent by name
    by_name = harness.service.get_discovery_agent(name="example-agent",
        org_identifier=org_identifier,
        project_identifier=project_identifier,
        environment_identifier=environment_identifier)
    pulumi.export("agentDetailsByName", by_name)
    # Data source to fetch a specific agent by identity
    by_identity = harness.service.get_discovery_agent(identity="example-infra",
        org_identifier=org_identifier,
        project_identifier=project_identifier,
        environment_identifier=environment_identifier)
    pulumi.export("agentDetailsByIdentity", by_identity)
    ```


    :param _builtins.str environment_id: The ID of the environment.
    :param Sequence[Union['GetInfrastructureV2ImageRegistryArgs', 'GetInfrastructureV2ImageRegistryArgsDict']] image_registries: Configuration for the container image registry.
    :param _builtins.str infra_id: The ID of the infrastructure.
    :param Union['GetInfrastructureV2MtlsArgs', 'GetInfrastructureV2MtlsArgsDict'] mtls: mTLS configuration for the infrastructure.
    :param _builtins.str org_id: The ID of the organization.
    :param _builtins.str project_id: The ID of the project.
    :param Union['GetInfrastructureV2ProxyArgs', 'GetInfrastructureV2ProxyArgsDict'] proxy: Proxy configuration for the infrastructure.
    :param Sequence[Union['GetInfrastructureV2TolerationArgs', 'GetInfrastructureV2TolerationArgsDict']] tolerations: If specified, the pod's tolerations.
    :param Sequence[Union['GetInfrastructureV2VolumeMountArgs', 'GetInfrastructureV2VolumeMountArgsDict']] volume_mounts: Volume mounts for the container.
    :param Sequence[Union['GetInfrastructureV2VolumeArgs', 'GetInfrastructureV2VolumeArgsDict']] volumes: Volumes to be created in the infrastructure.
    """
    __args__ = dict()
    __args__['environmentId'] = environment_id
    __args__['imageRegistries'] = image_registries
    __args__['infraId'] = infra_id
    __args__['mtls'] = mtls
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    __args__['proxy'] = proxy
    __args__['tolerations'] = tolerations
    __args__['volumeMounts'] = volume_mounts
    __args__['volumes'] = volumes
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:chaos/getInfrastructureV2:getInfrastructureV2', __args__, opts=opts, typ=GetInfrastructureV2Result)
    return __ret__.apply(lambda __response__: GetInfrastructureV2Result(
        annotation=pulumi.get(__response__, 'annotation'),
        containers=pulumi.get(__response__, 'containers'),
        created_at=pulumi.get(__response__, 'created_at'),
        created_by=pulumi.get(__response__, 'created_by'),
        description=pulumi.get(__response__, 'description'),
        environment_id=pulumi.get(__response__, 'environment_id'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        identity=pulumi.get(__response__, 'identity'),
        image_registries=pulumi.get(__response__, 'image_registries'),
        infra_id=pulumi.get(__response__, 'infra_id'),
        infra_scope=pulumi.get(__response__, 'infra_scope'),
        infra_type=pulumi.get(__response__, 'infra_type'),
        insecure_skip_verify=pulumi.get(__response__, 'insecure_skip_verify'),
        is_ai_enabled=pulumi.get(__response__, 'is_ai_enabled'),
        is_chaos_enabled=pulumi.get(__response__, 'is_chaos_enabled'),
        label=pulumi.get(__response__, 'label'),
        last_heartbeat=pulumi.get(__response__, 'last_heartbeat'),
        last_workflow_timestamp=pulumi.get(__response__, 'last_workflow_timestamp'),
        mtls=pulumi.get(__response__, 'mtls'),
        name=pulumi.get(__response__, 'name'),
        namespace=pulumi.get(__response__, 'namespace'),
        no_of_schedules=pulumi.get(__response__, 'no_of_schedules'),
        no_of_workflows=pulumi.get(__response__, 'no_of_workflows'),
        node_selector=pulumi.get(__response__, 'node_selector'),
        org_id=pulumi.get(__response__, 'org_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        proxy=pulumi.get(__response__, 'proxy'),
        run_as_group=pulumi.get(__response__, 'run_as_group'),
        run_as_user=pulumi.get(__response__, 'run_as_user'),
        service_account=pulumi.get(__response__, 'service_account'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        tolerations=pulumi.get(__response__, 'tolerations'),
        update_status=pulumi.get(__response__, 'update_status'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        updated_by=pulumi.get(__response__, 'updated_by'),
        volume_mounts=pulumi.get(__response__, 'volume_mounts'),
        volumes=pulumi.get(__response__, 'volumes')))
