# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['HubArgs', 'Hub']

@pulumi.input_type
class HubArgs:
    def __init__(__self__, *,
                 connector_id: pulumi.Input[_builtins.str],
                 repo_branch: pulumi.Input[_builtins.str],
                 connector_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Hub resource.
        :param pulumi.Input[_builtins.str] connector_id: ID of the Git connector
        :param pulumi.Input[_builtins.str] repo_branch: Git repository branch
        :param pulumi.Input[_builtins.str] connector_scope: Scope of the Git connector (PROJECT, ORGANISATION, or ACCOUNT)
        :param pulumi.Input[_builtins.str] description: Description of the chaos hub
        :param pulumi.Input[_builtins.bool] is_default: Whether this is the default chaos hub
        :param pulumi.Input[_builtins.str] name: Name of the chaos hub
        :param pulumi.Input[_builtins.str] org_id: The organization ID of the chaos hub
        :param pulumi.Input[_builtins.str] project_id: The project ID of the chaos hub
        :param pulumi.Input[_builtins.str] repo_name: Name of the Git repository (required for account-level connectors)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the chaos hub
        """
        pulumi.set(__self__, "connector_id", connector_id)
        pulumi.set(__self__, "repo_branch", repo_branch)
        if connector_scope is not None:
            pulumi.set(__self__, "connector_scope", connector_scope)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if repo_name is not None:
            pulumi.set(__self__, "repo_name", repo_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the Git connector
        """
        return pulumi.get(self, "connector_id")

    @connector_id.setter
    def connector_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connector_id", value)

    @_builtins.property
    @pulumi.getter(name="repoBranch")
    def repo_branch(self) -> pulumi.Input[_builtins.str]:
        """
        Git repository branch
        """
        return pulumi.get(self, "repo_branch")

    @repo_branch.setter
    def repo_branch(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "repo_branch", value)

    @_builtins.property
    @pulumi.getter(name="connectorScope")
    def connector_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scope of the Git connector (PROJECT, ORGANISATION, or ACCOUNT)
        """
        return pulumi.get(self, "connector_scope")

    @connector_scope.setter
    def connector_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connector_scope", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the chaos hub
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this is the default chaos hub
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the chaos hub
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organization ID of the chaos hub
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project ID of the chaos hub
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Git repository (required for account-level connectors)
        """
        return pulumi.get(self, "repo_name")

    @repo_name.setter
    def repo_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repo_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the chaos hub
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _HubState:
    def __init__(__self__, *,
                 connector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_available: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_synced_at: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 total_experiments: Optional[pulumi.Input[_builtins.int]] = None,
                 total_faults: Optional[pulumi.Input[_builtins.int]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Hub resources.
        :param pulumi.Input[_builtins.str] connector_id: ID of the Git connector
        :param pulumi.Input[_builtins.str] connector_scope: Scope of the Git connector (PROJECT, ORGANISATION, or ACCOUNT)
        :param pulumi.Input[_builtins.str] created_at: Creation timestamp
        :param pulumi.Input[_builtins.str] description: Description of the chaos hub
        :param pulumi.Input[_builtins.bool] is_available: Whether the chaos hub is available
        :param pulumi.Input[_builtins.bool] is_default: Whether this is the default chaos hub
        :param pulumi.Input[_builtins.str] last_synced_at: Timestamp of the last sync
        :param pulumi.Input[_builtins.str] name: Name of the chaos hub
        :param pulumi.Input[_builtins.str] org_id: The organization ID of the chaos hub
        :param pulumi.Input[_builtins.str] project_id: The project ID of the chaos hub
        :param pulumi.Input[_builtins.str] repo_branch: Git repository branch
        :param pulumi.Input[_builtins.str] repo_name: Name of the Git repository (required for account-level connectors)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the chaos hub
        :param pulumi.Input[_builtins.int] total_experiments: Total number of experiments in the hub
        :param pulumi.Input[_builtins.int] total_faults: Total number of faults in the hub
        :param pulumi.Input[_builtins.str] updated_at: Last update timestamp
        """
        if connector_id is not None:
            pulumi.set(__self__, "connector_id", connector_id)
        if connector_scope is not None:
            pulumi.set(__self__, "connector_scope", connector_scope)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_available is not None:
            pulumi.set(__self__, "is_available", is_available)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if last_synced_at is not None:
            pulumi.set(__self__, "last_synced_at", last_synced_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if repo_branch is not None:
            pulumi.set(__self__, "repo_branch", repo_branch)
        if repo_name is not None:
            pulumi.set(__self__, "repo_name", repo_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if total_experiments is not None:
            pulumi.set(__self__, "total_experiments", total_experiments)
        if total_faults is not None:
            pulumi.set(__self__, "total_faults", total_faults)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Git connector
        """
        return pulumi.get(self, "connector_id")

    @connector_id.setter
    def connector_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connector_id", value)

    @_builtins.property
    @pulumi.getter(name="connectorScope")
    def connector_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scope of the Git connector (PROJECT, ORGANISATION, or ACCOUNT)
        """
        return pulumi.get(self, "connector_scope")

    @connector_scope.setter
    def connector_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connector_scope", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation timestamp
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the chaos hub
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="isAvailable")
    def is_available(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the chaos hub is available
        """
        return pulumi.get(self, "is_available")

    @is_available.setter
    def is_available(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_available", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this is the default chaos hub
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter(name="lastSyncedAt")
    def last_synced_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp of the last sync
        """
        return pulumi.get(self, "last_synced_at")

    @last_synced_at.setter
    def last_synced_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_synced_at", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the chaos hub
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organization ID of the chaos hub
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project ID of the chaos hub
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="repoBranch")
    def repo_branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Git repository branch
        """
        return pulumi.get(self, "repo_branch")

    @repo_branch.setter
    def repo_branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repo_branch", value)

    @_builtins.property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Git repository (required for account-level connectors)
        """
        return pulumi.get(self, "repo_name")

    @repo_name.setter
    def repo_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repo_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the chaos hub
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="totalExperiments")
    def total_experiments(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Total number of experiments in the hub
        """
        return pulumi.get(self, "total_experiments")

    @total_experiments.setter
    def total_experiments(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_experiments", value)

    @_builtins.property
    @pulumi.getter(name="totalFaults")
    def total_faults(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Total number of faults in the hub
        """
        return pulumi.get(self, "total_faults")

    @total_faults.setter
    def total_faults(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_faults", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last update timestamp
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("harness:chaos/hub:Hub")
class Hub(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for managing a Harness Chaos Hub

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.chaos.Hub("example",
            org_id="<org_id>",
            project_id="<project_id>",
            name="<name>",
            description="<description>",
            connector_id="<connector_id>",
            repo_branch="<repo_branch>",
            repo_name="<repo_name>",
            is_default=False,
            tags=[
                "<tag1>",
                "<tag2>",
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Import Project level Chaos Hub

        ```sh
        $ pulumi import harness:chaos/hub:Hub example <org_id>/<project_id>/<hub_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connector_id: ID of the Git connector
        :param pulumi.Input[_builtins.str] connector_scope: Scope of the Git connector (PROJECT, ORGANISATION, or ACCOUNT)
        :param pulumi.Input[_builtins.str] description: Description of the chaos hub
        :param pulumi.Input[_builtins.bool] is_default: Whether this is the default chaos hub
        :param pulumi.Input[_builtins.str] name: Name of the chaos hub
        :param pulumi.Input[_builtins.str] org_id: The organization ID of the chaos hub
        :param pulumi.Input[_builtins.str] project_id: The project ID of the chaos hub
        :param pulumi.Input[_builtins.str] repo_branch: Git repository branch
        :param pulumi.Input[_builtins.str] repo_name: Name of the Git repository (required for account-level connectors)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the chaos hub
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HubArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing a Harness Chaos Hub

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.chaos.Hub("example",
            org_id="<org_id>",
            project_id="<project_id>",
            name="<name>",
            description="<description>",
            connector_id="<connector_id>",
            repo_branch="<repo_branch>",
            repo_name="<repo_name>",
            is_default=False,
            tags=[
                "<tag1>",
                "<tag2>",
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Import Project level Chaos Hub

        ```sh
        $ pulumi import harness:chaos/hub:Hub example <org_id>/<project_id>/<hub_id>
        ```

        :param str resource_name: The name of the resource.
        :param HubArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HubArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HubArgs.__new__(HubArgs)

            if connector_id is None and not opts.urn:
                raise TypeError("Missing required property 'connector_id'")
            __props__.__dict__["connector_id"] = connector_id
            __props__.__dict__["connector_scope"] = connector_scope
            __props__.__dict__["description"] = description
            __props__.__dict__["is_default"] = is_default
            __props__.__dict__["name"] = name
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            if repo_branch is None and not opts.urn:
                raise TypeError("Missing required property 'repo_branch'")
            __props__.__dict__["repo_branch"] = repo_branch
            __props__.__dict__["repo_name"] = repo_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["created_at"] = None
            __props__.__dict__["is_available"] = None
            __props__.__dict__["last_synced_at"] = None
            __props__.__dict__["total_experiments"] = None
            __props__.__dict__["total_faults"] = None
            __props__.__dict__["updated_at"] = None
        super(Hub, __self__).__init__(
            'harness:chaos/hub:Hub',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connector_id: Optional[pulumi.Input[_builtins.str]] = None,
            connector_scope: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            is_available: Optional[pulumi.Input[_builtins.bool]] = None,
            is_default: Optional[pulumi.Input[_builtins.bool]] = None,
            last_synced_at: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            repo_branch: Optional[pulumi.Input[_builtins.str]] = None,
            repo_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            total_experiments: Optional[pulumi.Input[_builtins.int]] = None,
            total_faults: Optional[pulumi.Input[_builtins.int]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'Hub':
        """
        Get an existing Hub resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connector_id: ID of the Git connector
        :param pulumi.Input[_builtins.str] connector_scope: Scope of the Git connector (PROJECT, ORGANISATION, or ACCOUNT)
        :param pulumi.Input[_builtins.str] created_at: Creation timestamp
        :param pulumi.Input[_builtins.str] description: Description of the chaos hub
        :param pulumi.Input[_builtins.bool] is_available: Whether the chaos hub is available
        :param pulumi.Input[_builtins.bool] is_default: Whether this is the default chaos hub
        :param pulumi.Input[_builtins.str] last_synced_at: Timestamp of the last sync
        :param pulumi.Input[_builtins.str] name: Name of the chaos hub
        :param pulumi.Input[_builtins.str] org_id: The organization ID of the chaos hub
        :param pulumi.Input[_builtins.str] project_id: The project ID of the chaos hub
        :param pulumi.Input[_builtins.str] repo_branch: Git repository branch
        :param pulumi.Input[_builtins.str] repo_name: Name of the Git repository (required for account-level connectors)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the chaos hub
        :param pulumi.Input[_builtins.int] total_experiments: Total number of experiments in the hub
        :param pulumi.Input[_builtins.int] total_faults: Total number of faults in the hub
        :param pulumi.Input[_builtins.str] updated_at: Last update timestamp
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HubState.__new__(_HubState)

        __props__.__dict__["connector_id"] = connector_id
        __props__.__dict__["connector_scope"] = connector_scope
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["is_available"] = is_available
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["last_synced_at"] = last_synced_at
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["repo_branch"] = repo_branch
        __props__.__dict__["repo_name"] = repo_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["total_experiments"] = total_experiments
        __props__.__dict__["total_faults"] = total_faults
        __props__.__dict__["updated_at"] = updated_at
        return Hub(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the Git connector
        """
        return pulumi.get(self, "connector_id")

    @_builtins.property
    @pulumi.getter(name="connectorScope")
    def connector_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Scope of the Git connector (PROJECT, ORGANISATION, or ACCOUNT)
        """
        return pulumi.get(self, "connector_scope")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Creation timestamp
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the chaos hub
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="isAvailable")
    def is_available(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the chaos hub is available
        """
        return pulumi.get(self, "is_available")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether this is the default chaos hub
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter(name="lastSyncedAt")
    def last_synced_at(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp of the last sync
        """
        return pulumi.get(self, "last_synced_at")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the chaos hub
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The organization ID of the chaos hub
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The project ID of the chaos hub
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="repoBranch")
    def repo_branch(self) -> pulumi.Output[_builtins.str]:
        """
        Git repository branch
        """
        return pulumi.get(self, "repo_branch")

    @_builtins.property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the Git repository (required for account-level connectors)
        """
        return pulumi.get(self, "repo_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags to associate with the chaos hub
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="totalExperiments")
    def total_experiments(self) -> pulumi.Output[_builtins.int]:
        """
        Total number of experiments in the hub
        """
        return pulumi.get(self, "total_experiments")

    @_builtins.property
    @pulumi.getter(name="totalFaults")
    def total_faults(self) -> pulumi.Output[_builtins.int]:
        """
        Total number of faults in the hub
        """
        return pulumi.get(self, "total_faults")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Last update timestamp
        """
        return pulumi.get(self, "updated_at")

