# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['HubSyncArgs', 'HubSync']

@pulumi.input_type
class HubSyncArgs:
    def __init__(__self__, *,
                 hub_id: pulumi.Input[_builtins.str],
                 org_id: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a HubSync resource.
        :param pulumi.Input[_builtins.str] hub_id: The ID of the Chaos Hub to sync
        """
        pulumi.set(__self__, "hub_id", hub_id)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter(name="hubId")
    def hub_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Chaos Hub to sync
        """
        return pulumi.get(self, "hub_id")

    @hub_id.setter
    def hub_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "hub_id", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class _HubSyncState:
    def __init__(__self__, *,
                 hub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 last_synced_at: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering HubSync resources.
        :param pulumi.Input[_builtins.str] hub_id: The ID of the Chaos Hub to sync
        :param pulumi.Input[_builtins.str] last_synced_at: Timestamp of the last sync
        """
        if hub_id is not None:
            pulumi.set(__self__, "hub_id", hub_id)
        if last_synced_at is not None:
            pulumi.set(__self__, "last_synced_at", last_synced_at)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter(name="hubId")
    def hub_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Chaos Hub to sync
        """
        return pulumi.get(self, "hub_id")

    @hub_id.setter
    def hub_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hub_id", value)

    @_builtins.property
    @pulumi.getter(name="lastSyncedAt")
    def last_synced_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp of the last sync
        """
        return pulumi.get(self, "last_synced_at")

    @last_synced_at.setter
    def last_synced_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_synced_at", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)


@pulumi.type_token("harness:chaos/hubSync:HubSync")
class HubSync(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 hub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for syncing a Harness Chaos Hub

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.chaos.HubSync("example",
            org_id="<org_id>",
            project_id="<project_id>",
            hub_id="<hub_id>")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] hub_id: The ID of the Chaos Hub to sync
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HubSyncArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for syncing a Harness Chaos Hub

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.chaos.HubSync("example",
            org_id="<org_id>",
            project_id="<project_id>",
            hub_id="<hub_id>")
        ```

        :param str resource_name: The name of the resource.
        :param HubSyncArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HubSyncArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 hub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HubSyncArgs.__new__(HubSyncArgs)

            if hub_id is None and not opts.urn:
                raise TypeError("Missing required property 'hub_id'")
            __props__.__dict__["hub_id"] = hub_id
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["last_synced_at"] = None
        super(HubSync, __self__).__init__(
            'harness:chaos/hubSync:HubSync',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            hub_id: Optional[pulumi.Input[_builtins.str]] = None,
            last_synced_at: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'HubSync':
        """
        Get an existing HubSync resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] hub_id: The ID of the Chaos Hub to sync
        :param pulumi.Input[_builtins.str] last_synced_at: Timestamp of the last sync
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HubSyncState.__new__(_HubSyncState)

        __props__.__dict__["hub_id"] = hub_id
        __props__.__dict__["last_synced_at"] = last_synced_at
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        return HubSync(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="hubId")
    def hub_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Chaos Hub to sync
        """
        return pulumi.get(self, "hub_id")

    @_builtins.property
    @pulumi.getter(name="lastSyncedAt")
    def last_synced_at(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp of the last sync
        """
        return pulumi.get(self, "last_synced_at")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "project_id")

