# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ImageRegistryArgs', 'ImageRegistry']

@pulumi.input_type
class ImageRegistryArgs:
    def __init__(__self__, *,
                 is_private: pulumi.Input[_builtins.bool],
                 registry_account: pulumi.Input[_builtins.str],
                 registry_server: pulumi.Input[_builtins.str],
                 custom_images: Optional[pulumi.Input[Sequence[pulumi.Input['ImageRegistryCustomImageArgs']]]] = None,
                 infra_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_override_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 use_custom_images: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ImageRegistry resource.
        :param pulumi.Input[_builtins.bool] is_private: Whether the registry is private
        :param pulumi.Input[_builtins.str] registry_account: The registry account name
        :param pulumi.Input[_builtins.str] registry_server: The registry server URL
        :param pulumi.Input[Sequence[pulumi.Input['ImageRegistryCustomImageArgs']]] custom_images: Custom images configuration
        :param pulumi.Input[_builtins.str] infra_id: The infrastructure ID to set up the image registry
        :param pulumi.Input[_builtins.bool] is_default: Whether this is the default registry
        :param pulumi.Input[_builtins.bool] is_override_allowed: Whether override is allowed for this registry
        :param pulumi.Input[_builtins.str] org_id: The organization ID of the image registry
        :param pulumi.Input[_builtins.str] project_id: The project ID of the image registry
        :param pulumi.Input[_builtins.str] secret_name: The name of the secret for authentication
        :param pulumi.Input[_builtins.bool] use_custom_images: Whether to use custom images
        """
        pulumi.set(__self__, "is_private", is_private)
        pulumi.set(__self__, "registry_account", registry_account)
        pulumi.set(__self__, "registry_server", registry_server)
        if custom_images is not None:
            pulumi.set(__self__, "custom_images", custom_images)
        if infra_id is not None:
            pulumi.set(__self__, "infra_id", infra_id)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if is_override_allowed is not None:
            pulumi.set(__self__, "is_override_allowed", is_override_allowed)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if use_custom_images is not None:
            pulumi.set(__self__, "use_custom_images", use_custom_images)

    @_builtins.property
    @pulumi.getter(name="isPrivate")
    def is_private(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether the registry is private
        """
        return pulumi.get(self, "is_private")

    @is_private.setter
    def is_private(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "is_private", value)

    @_builtins.property
    @pulumi.getter(name="registryAccount")
    def registry_account(self) -> pulumi.Input[_builtins.str]:
        """
        The registry account name
        """
        return pulumi.get(self, "registry_account")

    @registry_account.setter
    def registry_account(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "registry_account", value)

    @_builtins.property
    @pulumi.getter(name="registryServer")
    def registry_server(self) -> pulumi.Input[_builtins.str]:
        """
        The registry server URL
        """
        return pulumi.get(self, "registry_server")

    @registry_server.setter
    def registry_server(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "registry_server", value)

    @_builtins.property
    @pulumi.getter(name="customImages")
    def custom_images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageRegistryCustomImageArgs']]]]:
        """
        Custom images configuration
        """
        return pulumi.get(self, "custom_images")

    @custom_images.setter
    def custom_images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageRegistryCustomImageArgs']]]]):
        pulumi.set(self, "custom_images", value)

    @_builtins.property
    @pulumi.getter(name="infraId")
    def infra_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The infrastructure ID to set up the image registry
        """
        return pulumi.get(self, "infra_id")

    @infra_id.setter
    def infra_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "infra_id", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this is the default registry
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter(name="isOverrideAllowed")
    def is_override_allowed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether override is allowed for this registry
        """
        return pulumi.get(self, "is_override_allowed")

    @is_override_allowed.setter
    def is_override_allowed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_override_allowed", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organization ID of the image registry
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project ID of the image registry
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the secret for authentication
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_name", value)

    @_builtins.property
    @pulumi.getter(name="useCustomImages")
    def use_custom_images(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to use custom images
        """
        return pulumi.get(self, "use_custom_images")

    @use_custom_images.setter
    def use_custom_images(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_custom_images", value)


@pulumi.input_type
class _ImageRegistryState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_images: Optional[pulumi.Input[Sequence[pulumi.Input['ImageRegistryCustomImageArgs']]]] = None,
                 infra_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_override_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_private: Optional[pulumi.Input[_builtins.bool]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 registry_account: Optional[pulumi.Input[_builtins.str]] = None,
                 registry_server: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 use_custom_images: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ImageRegistry resources.
        :param pulumi.Input[_builtins.str] created_at: Creation timestamp
        :param pulumi.Input[Sequence[pulumi.Input['ImageRegistryCustomImageArgs']]] custom_images: Custom images configuration
        :param pulumi.Input[_builtins.str] infra_id: The infrastructure ID to set up the image registry
        :param pulumi.Input[_builtins.bool] is_default: Whether this is the default registry
        :param pulumi.Input[_builtins.bool] is_override_allowed: Whether override is allowed for this registry
        :param pulumi.Input[_builtins.bool] is_private: Whether the registry is private
        :param pulumi.Input[_builtins.str] org_id: The organization ID of the image registry
        :param pulumi.Input[_builtins.str] project_id: The project ID of the image registry
        :param pulumi.Input[_builtins.str] registry_account: The registry account name
        :param pulumi.Input[_builtins.str] registry_server: The registry server URL
        :param pulumi.Input[_builtins.str] secret_name: The name of the secret for authentication
        :param pulumi.Input[_builtins.str] updated_at: Last update timestamp
        :param pulumi.Input[_builtins.bool] use_custom_images: Whether to use custom images
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if custom_images is not None:
            pulumi.set(__self__, "custom_images", custom_images)
        if infra_id is not None:
            pulumi.set(__self__, "infra_id", infra_id)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if is_override_allowed is not None:
            pulumi.set(__self__, "is_override_allowed", is_override_allowed)
        if is_private is not None:
            pulumi.set(__self__, "is_private", is_private)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if registry_account is not None:
            pulumi.set(__self__, "registry_account", registry_account)
        if registry_server is not None:
            pulumi.set(__self__, "registry_server", registry_server)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if use_custom_images is not None:
            pulumi.set(__self__, "use_custom_images", use_custom_images)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation timestamp
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="customImages")
    def custom_images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageRegistryCustomImageArgs']]]]:
        """
        Custom images configuration
        """
        return pulumi.get(self, "custom_images")

    @custom_images.setter
    def custom_images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageRegistryCustomImageArgs']]]]):
        pulumi.set(self, "custom_images", value)

    @_builtins.property
    @pulumi.getter(name="infraId")
    def infra_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The infrastructure ID to set up the image registry
        """
        return pulumi.get(self, "infra_id")

    @infra_id.setter
    def infra_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "infra_id", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this is the default registry
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter(name="isOverrideAllowed")
    def is_override_allowed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether override is allowed for this registry
        """
        return pulumi.get(self, "is_override_allowed")

    @is_override_allowed.setter
    def is_override_allowed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_override_allowed", value)

    @_builtins.property
    @pulumi.getter(name="isPrivate")
    def is_private(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the registry is private
        """
        return pulumi.get(self, "is_private")

    @is_private.setter
    def is_private(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_private", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organization ID of the image registry
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project ID of the image registry
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="registryAccount")
    def registry_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The registry account name
        """
        return pulumi.get(self, "registry_account")

    @registry_account.setter
    def registry_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "registry_account", value)

    @_builtins.property
    @pulumi.getter(name="registryServer")
    def registry_server(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The registry server URL
        """
        return pulumi.get(self, "registry_server")

    @registry_server.setter
    def registry_server(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "registry_server", value)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the secret for authentication
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_name", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last update timestamp
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="useCustomImages")
    def use_custom_images(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to use custom images
        """
        return pulumi.get(self, "use_custom_images")

    @use_custom_images.setter
    def use_custom_images(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_custom_images", value)


@pulumi.type_token("harness:chaos/imageRegistry:ImageRegistry")
class ImageRegistry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_images: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageRegistryCustomImageArgs', 'ImageRegistryCustomImageArgsDict']]]]] = None,
                 infra_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_override_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_private: Optional[pulumi.Input[_builtins.bool]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 registry_account: Optional[pulumi.Input[_builtins.str]] = None,
                 registry_server: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 use_custom_images: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Resource for managing a Harness Chaos Image Registry

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.chaos.ImageRegistry("example",
            org_id="<org_id>",
            project_id="<project_id>",
            registry_server="<registry_server>",
            registry_account="<registry_account>",
            is_private=True,
            secret_name="<secret_name>",
            is_default=False,
            is_override_allowed=True,
            use_custom_images=True,
            custom_images=[{
                "log_watcher": "<log_watcher_image>",
                "ddcr": "<ddcr_image>",
                "ddcr_lib": "<ddcr_lib_image>",
                "ddcr_fault": "<ddcr_fault_image>",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImageRegistryCustomImageArgs', 'ImageRegistryCustomImageArgsDict']]]] custom_images: Custom images configuration
        :param pulumi.Input[_builtins.str] infra_id: The infrastructure ID to set up the image registry
        :param pulumi.Input[_builtins.bool] is_default: Whether this is the default registry
        :param pulumi.Input[_builtins.bool] is_override_allowed: Whether override is allowed for this registry
        :param pulumi.Input[_builtins.bool] is_private: Whether the registry is private
        :param pulumi.Input[_builtins.str] org_id: The organization ID of the image registry
        :param pulumi.Input[_builtins.str] project_id: The project ID of the image registry
        :param pulumi.Input[_builtins.str] registry_account: The registry account name
        :param pulumi.Input[_builtins.str] registry_server: The registry server URL
        :param pulumi.Input[_builtins.str] secret_name: The name of the secret for authentication
        :param pulumi.Input[_builtins.bool] use_custom_images: Whether to use custom images
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImageRegistryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing a Harness Chaos Image Registry

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.chaos.ImageRegistry("example",
            org_id="<org_id>",
            project_id="<project_id>",
            registry_server="<registry_server>",
            registry_account="<registry_account>",
            is_private=True,
            secret_name="<secret_name>",
            is_default=False,
            is_override_allowed=True,
            use_custom_images=True,
            custom_images=[{
                "log_watcher": "<log_watcher_image>",
                "ddcr": "<ddcr_image>",
                "ddcr_lib": "<ddcr_lib_image>",
                "ddcr_fault": "<ddcr_fault_image>",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param ImageRegistryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImageRegistryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_images: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageRegistryCustomImageArgs', 'ImageRegistryCustomImageArgsDict']]]]] = None,
                 infra_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_override_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_private: Optional[pulumi.Input[_builtins.bool]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 registry_account: Optional[pulumi.Input[_builtins.str]] = None,
                 registry_server: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 use_custom_images: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImageRegistryArgs.__new__(ImageRegistryArgs)

            __props__.__dict__["custom_images"] = custom_images
            __props__.__dict__["infra_id"] = infra_id
            __props__.__dict__["is_default"] = is_default
            __props__.__dict__["is_override_allowed"] = is_override_allowed
            if is_private is None and not opts.urn:
                raise TypeError("Missing required property 'is_private'")
            __props__.__dict__["is_private"] = is_private
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            if registry_account is None and not opts.urn:
                raise TypeError("Missing required property 'registry_account'")
            __props__.__dict__["registry_account"] = registry_account
            if registry_server is None and not opts.urn:
                raise TypeError("Missing required property 'registry_server'")
            __props__.__dict__["registry_server"] = registry_server
            __props__.__dict__["secret_name"] = secret_name
            __props__.__dict__["use_custom_images"] = use_custom_images
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        super(ImageRegistry, __self__).__init__(
            'harness:chaos/imageRegistry:ImageRegistry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            custom_images: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageRegistryCustomImageArgs', 'ImageRegistryCustomImageArgsDict']]]]] = None,
            infra_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_default: Optional[pulumi.Input[_builtins.bool]] = None,
            is_override_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
            is_private: Optional[pulumi.Input[_builtins.bool]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            registry_account: Optional[pulumi.Input[_builtins.str]] = None,
            registry_server: Optional[pulumi.Input[_builtins.str]] = None,
            secret_name: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            use_custom_images: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ImageRegistry':
        """
        Get an existing ImageRegistry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: Creation timestamp
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImageRegistryCustomImageArgs', 'ImageRegistryCustomImageArgsDict']]]] custom_images: Custom images configuration
        :param pulumi.Input[_builtins.str] infra_id: The infrastructure ID to set up the image registry
        :param pulumi.Input[_builtins.bool] is_default: Whether this is the default registry
        :param pulumi.Input[_builtins.bool] is_override_allowed: Whether override is allowed for this registry
        :param pulumi.Input[_builtins.bool] is_private: Whether the registry is private
        :param pulumi.Input[_builtins.str] org_id: The organization ID of the image registry
        :param pulumi.Input[_builtins.str] project_id: The project ID of the image registry
        :param pulumi.Input[_builtins.str] registry_account: The registry account name
        :param pulumi.Input[_builtins.str] registry_server: The registry server URL
        :param pulumi.Input[_builtins.str] secret_name: The name of the secret for authentication
        :param pulumi.Input[_builtins.str] updated_at: Last update timestamp
        :param pulumi.Input[_builtins.bool] use_custom_images: Whether to use custom images
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImageRegistryState.__new__(_ImageRegistryState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["custom_images"] = custom_images
        __props__.__dict__["infra_id"] = infra_id
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["is_override_allowed"] = is_override_allowed
        __props__.__dict__["is_private"] = is_private
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["registry_account"] = registry_account
        __props__.__dict__["registry_server"] = registry_server
        __props__.__dict__["secret_name"] = secret_name
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["use_custom_images"] = use_custom_images
        return ImageRegistry(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Creation timestamp
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="customImages")
    def custom_images(self) -> pulumi.Output[Sequence['outputs.ImageRegistryCustomImage']]:
        """
        Custom images configuration
        """
        return pulumi.get(self, "custom_images")

    @_builtins.property
    @pulumi.getter(name="infraId")
    def infra_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The infrastructure ID to set up the image registry
        """
        return pulumi.get(self, "infra_id")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether this is the default registry
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter(name="isOverrideAllowed")
    def is_override_allowed(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether override is allowed for this registry
        """
        return pulumi.get(self, "is_override_allowed")

    @_builtins.property
    @pulumi.getter(name="isPrivate")
    def is_private(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the registry is private
        """
        return pulumi.get(self, "is_private")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The organization ID of the image registry
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The project ID of the image registry
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="registryAccount")
    def registry_account(self) -> pulumi.Output[_builtins.str]:
        """
        The registry account name
        """
        return pulumi.get(self, "registry_account")

    @_builtins.property
    @pulumi.getter(name="registryServer")
    def registry_server(self) -> pulumi.Output[_builtins.str]:
        """
        The registry server URL
        """
        return pulumi.get(self, "registry_server")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the secret for authentication
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Last update timestamp
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="useCustomImages")
    def use_custom_images(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to use custom images
        """
        return pulumi.get(self, "use_custom_images")

