# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InfrastructureV2Args', 'InfrastructureV2']

@pulumi.input_type
class InfrastructureV2Args:
    def __init__(__self__, *,
                 environment_id: pulumi.Input[_builtins.str],
                 infra_id: pulumi.Input[_builtins.str],
                 org_id: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 ai_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 annotation: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 containers: Optional[pulumi.Input[_builtins.str]] = None,
                 correlation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 discovery_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2EnvArgs']]]] = None,
                 image_registries: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2ImageRegistryArgs']]]] = None,
                 infra_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 infra_type: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure_skip_verify: Optional[pulumi.Input[_builtins.bool]] = None,
                 label: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mtls: Optional[pulumi.Input['InfrastructureV2MtlsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 node_selector: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 proxy: Optional[pulumi.Input['InfrastructureV2ProxyArgs']] = None,
                 run_as_group: Optional[pulumi.Input[_builtins.int]] = None,
                 run_as_user: Optional[pulumi.Input[_builtins.int]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tolerations: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2TolerationArgs']]]] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2VolumeMountArgs']]]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2VolumeArgs']]]] = None):
        """
        The set of arguments for constructing a InfrastructureV2 resource.
        :param pulumi.Input[_builtins.str] environment_id: The ID of the environment.
        :param pulumi.Input[_builtins.str] infra_id: ID of the infrastructure.
        :param pulumi.Input[_builtins.str] org_id: The ID of the organization.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input[_builtins.bool] ai_enabled: Enable AI features for the infrastructure.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotation: Annotations to apply to the infrastructure pods.
        :param pulumi.Input[_builtins.str] containers: Container configurations.
        :param pulumi.Input[_builtins.str] correlation_id: Correlation ID for the request.
        :param pulumi.Input[_builtins.str] description: Description of the infrastructure.
        :param pulumi.Input[_builtins.str] discovery_agent_id: ID of the discovery agent to use.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructureV2EnvArgs']]] envs: List of environment variables to set in the container.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructureV2ImageRegistryArgs']]] image_registries: Configuration for the container image registry.
        :param pulumi.Input[_builtins.str] infra_scope: Scope of the infrastructure. Valid values: NAMESPACE, CLUSTER
        :param pulumi.Input[_builtins.str] infra_type: Type of the infrastructure. Valid values: KUBERNETES, KUBERNETESV2
        :param pulumi.Input[_builtins.bool] insecure_skip_verify: Skip TLS verification for the infrastructure.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] label: Labels to apply to the infrastructure pods.
        :param pulumi.Input['InfrastructureV2MtlsArgs'] mtls: mTLS configuration for the infrastructure.
        :param pulumi.Input[_builtins.str] name: Name of the infrastructure.
        :param pulumi.Input[_builtins.str] namespace: Kubernetes namespace where the infrastructure will be installed. Maps to the infrastructure namespace.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] node_selector: Node selector for the infrastructure pods.
        :param pulumi.Input['InfrastructureV2ProxyArgs'] proxy: Proxy configuration for the infrastructure.
        :param pulumi.Input[_builtins.int] run_as_group: Group ID to run the infrastructure as.
        :param pulumi.Input[_builtins.int] run_as_user: User ID to run the infrastructure as.
        :param pulumi.Input[_builtins.str] service_account: Service account used by the infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for the infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructureV2TolerationArgs']]] tolerations: If specified, the pod's tolerations.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructureV2VolumeMountArgs']]] volume_mounts: Volume mounts for the container.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructureV2VolumeArgs']]] volumes: Volumes to be created in the infrastructure.
        """
        pulumi.set(__self__, "environment_id", environment_id)
        pulumi.set(__self__, "infra_id", infra_id)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "project_id", project_id)
        if ai_enabled is not None:
            pulumi.set(__self__, "ai_enabled", ai_enabled)
        if annotation is not None:
            pulumi.set(__self__, "annotation", annotation)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if correlation_id is not None:
            pulumi.set(__self__, "correlation_id", correlation_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if discovery_agent_id is not None:
            pulumi.set(__self__, "discovery_agent_id", discovery_agent_id)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if image_registries is not None:
            pulumi.set(__self__, "image_registries", image_registries)
        if infra_scope is not None:
            pulumi.set(__self__, "infra_scope", infra_scope)
        if infra_type is not None:
            pulumi.set(__self__, "infra_type", infra_type)
        if insecure_skip_verify is not None:
            pulumi.set(__self__, "insecure_skip_verify", insecure_skip_verify)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if mtls is not None:
            pulumi.set(__self__, "mtls", mtls)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if proxy is not None:
            pulumi.set(__self__, "proxy", proxy)
        if run_as_group is not None:
            pulumi.set(__self__, "run_as_group", run_as_group)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tolerations is not None:
            pulumi.set(__self__, "tolerations", tolerations)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the environment.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "environment_id", value)

    @_builtins.property
    @pulumi.getter(name="infraId")
    def infra_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the infrastructure.
        """
        return pulumi.get(self, "infra_id")

    @infra_id.setter
    def infra_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "infra_id", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="aiEnabled")
    def ai_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable AI features for the infrastructure.
        """
        return pulumi.get(self, "ai_enabled")

    @ai_enabled.setter
    def ai_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ai_enabled", value)

    @_builtins.property
    @pulumi.getter
    def annotation(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations to apply to the infrastructure pods.
        """
        return pulumi.get(self, "annotation")

    @annotation.setter
    def annotation(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotation", value)

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Container configurations.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "containers", value)

    @_builtins.property
    @pulumi.getter(name="correlationId")
    def correlation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Correlation ID for the request.
        """
        return pulumi.get(self, "correlation_id")

    @correlation_id.setter
    def correlation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "correlation_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the infrastructure.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="discoveryAgentId")
    def discovery_agent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the discovery agent to use.
        """
        return pulumi.get(self, "discovery_agent_id")

    @discovery_agent_id.setter
    def discovery_agent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "discovery_agent_id", value)

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2EnvArgs']]]]:
        """
        List of environment variables to set in the container.
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2EnvArgs']]]]):
        pulumi.set(self, "envs", value)

    @_builtins.property
    @pulumi.getter(name="imageRegistries")
    def image_registries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2ImageRegistryArgs']]]]:
        """
        Configuration for the container image registry.
        """
        return pulumi.get(self, "image_registries")

    @image_registries.setter
    def image_registries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2ImageRegistryArgs']]]]):
        pulumi.set(self, "image_registries", value)

    @_builtins.property
    @pulumi.getter(name="infraScope")
    def infra_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scope of the infrastructure. Valid values: NAMESPACE, CLUSTER
        """
        return pulumi.get(self, "infra_scope")

    @infra_scope.setter
    def infra_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "infra_scope", value)

    @_builtins.property
    @pulumi.getter(name="infraType")
    def infra_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the infrastructure. Valid values: KUBERNETES, KUBERNETESV2
        """
        return pulumi.get(self, "infra_type")

    @infra_type.setter
    def infra_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "infra_type", value)

    @_builtins.property
    @pulumi.getter(name="insecureSkipVerify")
    def insecure_skip_verify(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Skip TLS verification for the infrastructure.
        """
        return pulumi.get(self, "insecure_skip_verify")

    @insecure_skip_verify.setter
    def insecure_skip_verify(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "insecure_skip_verify", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels to apply to the infrastructure pods.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def mtls(self) -> Optional[pulumi.Input['InfrastructureV2MtlsArgs']]:
        """
        mTLS configuration for the infrastructure.
        """
        return pulumi.get(self, "mtls")

    @mtls.setter
    def mtls(self, value: Optional[pulumi.Input['InfrastructureV2MtlsArgs']]):
        pulumi.set(self, "mtls", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the infrastructure.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Kubernetes namespace where the infrastructure will be installed. Maps to the infrastructure namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Node selector for the infrastructure pods.
        """
        return pulumi.get(self, "node_selector")

    @node_selector.setter
    def node_selector(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_selector", value)

    @_builtins.property
    @pulumi.getter
    def proxy(self) -> Optional[pulumi.Input['InfrastructureV2ProxyArgs']]:
        """
        Proxy configuration for the infrastructure.
        """
        return pulumi.get(self, "proxy")

    @proxy.setter
    def proxy(self, value: Optional[pulumi.Input['InfrastructureV2ProxyArgs']]):
        pulumi.set(self, "proxy", value)

    @_builtins.property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Group ID to run the infrastructure as.
        """
        return pulumi.get(self, "run_as_group")

    @run_as_group.setter
    def run_as_group(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "run_as_group", value)

    @_builtins.property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        User ID to run the infrastructure as.
        """
        return pulumi.get(self, "run_as_user")

    @run_as_user.setter
    def run_as_user(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "run_as_user", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service account used by the infrastructure.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags for the infrastructure.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def tolerations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2TolerationArgs']]]]:
        """
        If specified, the pod's tolerations.
        """
        return pulumi.get(self, "tolerations")

    @tolerations.setter
    def tolerations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2TolerationArgs']]]]):
        pulumi.set(self, "tolerations", value)

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2VolumeMountArgs']]]]:
        """
        Volume mounts for the container.
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2VolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2VolumeArgs']]]]:
        """
        Volumes to be created in the infrastructure.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2VolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


@pulumi.input_type
class _InfrastructureV2State:
    def __init__(__self__, *,
                 ai_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 annotation: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 containers: Optional[pulumi.Input[_builtins.str]] = None,
                 correlation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 discovery_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2EnvArgs']]]] = None,
                 identifiers: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2IdentifierArgs']]]] = None,
                 identity: Optional[pulumi.Input[_builtins.str]] = None,
                 image_registries: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2ImageRegistryArgs']]]] = None,
                 infra_id: Optional[pulumi.Input[_builtins.str]] = None,
                 infra_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 infra_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 infra_type: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure_skip_verify: Optional[pulumi.Input[_builtins.bool]] = None,
                 install_command: Optional[pulumi.Input[_builtins.str]] = None,
                 k8s_connector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mtls: Optional[pulumi.Input['InfrastructureV2MtlsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 node_selector: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy: Optional[pulumi.Input['InfrastructureV2ProxyArgs']] = None,
                 run_as_group: Optional[pulumi.Input[_builtins.int]] = None,
                 run_as_user: Optional[pulumi.Input[_builtins.int]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tolerations: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2TolerationArgs']]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2VolumeMountArgs']]]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2VolumeArgs']]]] = None):
        """
        Input properties used for looking up and filtering InfrastructureV2 resources.
        :param pulumi.Input[_builtins.bool] ai_enabled: Enable AI features for the infrastructure.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotation: Annotations to apply to the infrastructure pods.
        :param pulumi.Input[_builtins.str] containers: Container configurations.
        :param pulumi.Input[_builtins.str] correlation_id: Correlation ID for the request.
        :param pulumi.Input[_builtins.str] created_at: Creation timestamp.
        :param pulumi.Input[_builtins.str] description: Description of the infrastructure.
        :param pulumi.Input[_builtins.str] discovery_agent_id: ID of the discovery agent to use.
        :param pulumi.Input[_builtins.str] environment_id: The ID of the environment.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructureV2EnvArgs']]] envs: List of environment variables to set in the container.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructureV2IdentifierArgs']]] identifiers: Identifier for the infrastructure.
        :param pulumi.Input[_builtins.str] identity: Identity for the infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructureV2ImageRegistryArgs']]] image_registries: Configuration for the container image registry.
        :param pulumi.Input[_builtins.str] infra_id: ID of the infrastructure.
        :param pulumi.Input[_builtins.str] infra_namespace: Namespace where the infrastructure is installed.
        :param pulumi.Input[_builtins.str] infra_scope: Scope of the infrastructure. Valid values: NAMESPACE, CLUSTER
        :param pulumi.Input[_builtins.str] infra_type: Type of the infrastructure. Valid values: KUBERNETES, KUBERNETESV2
        :param pulumi.Input[_builtins.bool] insecure_skip_verify: Skip TLS verification for the infrastructure.
        :param pulumi.Input[_builtins.str] install_command: Installation command for the infrastructure.
        :param pulumi.Input[_builtins.str] k8s_connector_id: Kubernetes connector identifier.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] label: Labels to apply to the infrastructure pods.
        :param pulumi.Input['InfrastructureV2MtlsArgs'] mtls: mTLS configuration for the infrastructure.
        :param pulumi.Input[_builtins.str] name: Name of the infrastructure.
        :param pulumi.Input[_builtins.str] namespace: Kubernetes namespace where the infrastructure will be installed. Maps to the infrastructure namespace.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] node_selector: Node selector for the infrastructure pods.
        :param pulumi.Input[_builtins.str] org_id: The ID of the organization.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input['InfrastructureV2ProxyArgs'] proxy: Proxy configuration for the infrastructure.
        :param pulumi.Input[_builtins.int] run_as_group: Group ID to run the infrastructure as.
        :param pulumi.Input[_builtins.int] run_as_user: User ID to run the infrastructure as.
        :param pulumi.Input[_builtins.str] service_account: Service account used by the infrastructure.
        :param pulumi.Input[_builtins.str] status: Status of the infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for the infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructureV2TolerationArgs']]] tolerations: If specified, the pod's tolerations.
        :param pulumi.Input[_builtins.str] updated_at: Last update timestamp.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructureV2VolumeMountArgs']]] volume_mounts: Volume mounts for the container.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructureV2VolumeArgs']]] volumes: Volumes to be created in the infrastructure.
        """
        if ai_enabled is not None:
            pulumi.set(__self__, "ai_enabled", ai_enabled)
        if annotation is not None:
            pulumi.set(__self__, "annotation", annotation)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if correlation_id is not None:
            pulumi.set(__self__, "correlation_id", correlation_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if discovery_agent_id is not None:
            pulumi.set(__self__, "discovery_agent_id", discovery_agent_id)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if identifiers is not None:
            pulumi.set(__self__, "identifiers", identifiers)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if image_registries is not None:
            pulumi.set(__self__, "image_registries", image_registries)
        if infra_id is not None:
            pulumi.set(__self__, "infra_id", infra_id)
        if infra_namespace is not None:
            pulumi.set(__self__, "infra_namespace", infra_namespace)
        if infra_scope is not None:
            pulumi.set(__self__, "infra_scope", infra_scope)
        if infra_type is not None:
            pulumi.set(__self__, "infra_type", infra_type)
        if insecure_skip_verify is not None:
            pulumi.set(__self__, "insecure_skip_verify", insecure_skip_verify)
        if install_command is not None:
            pulumi.set(__self__, "install_command", install_command)
        if k8s_connector_id is not None:
            pulumi.set(__self__, "k8s_connector_id", k8s_connector_id)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if mtls is not None:
            pulumi.set(__self__, "mtls", mtls)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if proxy is not None:
            pulumi.set(__self__, "proxy", proxy)
        if run_as_group is not None:
            pulumi.set(__self__, "run_as_group", run_as_group)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tolerations is not None:
            pulumi.set(__self__, "tolerations", tolerations)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter(name="aiEnabled")
    def ai_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable AI features for the infrastructure.
        """
        return pulumi.get(self, "ai_enabled")

    @ai_enabled.setter
    def ai_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ai_enabled", value)

    @_builtins.property
    @pulumi.getter
    def annotation(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations to apply to the infrastructure pods.
        """
        return pulumi.get(self, "annotation")

    @annotation.setter
    def annotation(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotation", value)

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Container configurations.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "containers", value)

    @_builtins.property
    @pulumi.getter(name="correlationId")
    def correlation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Correlation ID for the request.
        """
        return pulumi.get(self, "correlation_id")

    @correlation_id.setter
    def correlation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "correlation_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation timestamp.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the infrastructure.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="discoveryAgentId")
    def discovery_agent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the discovery agent to use.
        """
        return pulumi.get(self, "discovery_agent_id")

    @discovery_agent_id.setter
    def discovery_agent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "discovery_agent_id", value)

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the environment.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment_id", value)

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2EnvArgs']]]]:
        """
        List of environment variables to set in the container.
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2EnvArgs']]]]):
        pulumi.set(self, "envs", value)

    @_builtins.property
    @pulumi.getter
    def identifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2IdentifierArgs']]]]:
        """
        Identifier for the infrastructure.
        """
        return pulumi.get(self, "identifiers")

    @identifiers.setter
    def identifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2IdentifierArgs']]]]):
        pulumi.set(self, "identifiers", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identity for the infrastructure.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="imageRegistries")
    def image_registries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2ImageRegistryArgs']]]]:
        """
        Configuration for the container image registry.
        """
        return pulumi.get(self, "image_registries")

    @image_registries.setter
    def image_registries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2ImageRegistryArgs']]]]):
        pulumi.set(self, "image_registries", value)

    @_builtins.property
    @pulumi.getter(name="infraId")
    def infra_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the infrastructure.
        """
        return pulumi.get(self, "infra_id")

    @infra_id.setter
    def infra_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "infra_id", value)

    @_builtins.property
    @pulumi.getter(name="infraNamespace")
    def infra_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Namespace where the infrastructure is installed.
        """
        return pulumi.get(self, "infra_namespace")

    @infra_namespace.setter
    def infra_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "infra_namespace", value)

    @_builtins.property
    @pulumi.getter(name="infraScope")
    def infra_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scope of the infrastructure. Valid values: NAMESPACE, CLUSTER
        """
        return pulumi.get(self, "infra_scope")

    @infra_scope.setter
    def infra_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "infra_scope", value)

    @_builtins.property
    @pulumi.getter(name="infraType")
    def infra_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the infrastructure. Valid values: KUBERNETES, KUBERNETESV2
        """
        return pulumi.get(self, "infra_type")

    @infra_type.setter
    def infra_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "infra_type", value)

    @_builtins.property
    @pulumi.getter(name="insecureSkipVerify")
    def insecure_skip_verify(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Skip TLS verification for the infrastructure.
        """
        return pulumi.get(self, "insecure_skip_verify")

    @insecure_skip_verify.setter
    def insecure_skip_verify(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "insecure_skip_verify", value)

    @_builtins.property
    @pulumi.getter(name="installCommand")
    def install_command(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Installation command for the infrastructure.
        """
        return pulumi.get(self, "install_command")

    @install_command.setter
    def install_command(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "install_command", value)

    @_builtins.property
    @pulumi.getter(name="k8sConnectorId")
    def k8s_connector_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Kubernetes connector identifier.
        """
        return pulumi.get(self, "k8s_connector_id")

    @k8s_connector_id.setter
    def k8s_connector_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "k8s_connector_id", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels to apply to the infrastructure pods.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def mtls(self) -> Optional[pulumi.Input['InfrastructureV2MtlsArgs']]:
        """
        mTLS configuration for the infrastructure.
        """
        return pulumi.get(self, "mtls")

    @mtls.setter
    def mtls(self, value: Optional[pulumi.Input['InfrastructureV2MtlsArgs']]):
        pulumi.set(self, "mtls", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the infrastructure.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Kubernetes namespace where the infrastructure will be installed. Maps to the infrastructure namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Node selector for the infrastructure pods.
        """
        return pulumi.get(self, "node_selector")

    @node_selector.setter
    def node_selector(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_selector", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def proxy(self) -> Optional[pulumi.Input['InfrastructureV2ProxyArgs']]:
        """
        Proxy configuration for the infrastructure.
        """
        return pulumi.get(self, "proxy")

    @proxy.setter
    def proxy(self, value: Optional[pulumi.Input['InfrastructureV2ProxyArgs']]):
        pulumi.set(self, "proxy", value)

    @_builtins.property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Group ID to run the infrastructure as.
        """
        return pulumi.get(self, "run_as_group")

    @run_as_group.setter
    def run_as_group(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "run_as_group", value)

    @_builtins.property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        User ID to run the infrastructure as.
        """
        return pulumi.get(self, "run_as_user")

    @run_as_user.setter
    def run_as_user(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "run_as_user", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service account used by the infrastructure.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the infrastructure.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags for the infrastructure.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def tolerations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2TolerationArgs']]]]:
        """
        If specified, the pod's tolerations.
        """
        return pulumi.get(self, "tolerations")

    @tolerations.setter
    def tolerations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2TolerationArgs']]]]):
        pulumi.set(self, "tolerations", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last update timestamp.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2VolumeMountArgs']]]]:
        """
        Volume mounts for the container.
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2VolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2VolumeArgs']]]]:
        """
        Volumes to be created in the infrastructure.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureV2VolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


@pulumi.type_token("harness:chaos/infrastructureV2:InfrastructureV2")
class InfrastructureV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ai_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 annotation: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 containers: Optional[pulumi.Input[_builtins.str]] = None,
                 correlation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 discovery_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2EnvArgs', 'InfrastructureV2EnvArgsDict']]]]] = None,
                 image_registries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2ImageRegistryArgs', 'InfrastructureV2ImageRegistryArgsDict']]]]] = None,
                 infra_id: Optional[pulumi.Input[_builtins.str]] = None,
                 infra_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 infra_type: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure_skip_verify: Optional[pulumi.Input[_builtins.bool]] = None,
                 label: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mtls: Optional[pulumi.Input[Union['InfrastructureV2MtlsArgs', 'InfrastructureV2MtlsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 node_selector: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy: Optional[pulumi.Input[Union['InfrastructureV2ProxyArgs', 'InfrastructureV2ProxyArgsDict']]] = None,
                 run_as_group: Optional[pulumi.Input[_builtins.int]] = None,
                 run_as_user: Optional[pulumi.Input[_builtins.int]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tolerations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2TolerationArgs', 'InfrastructureV2TolerationArgsDict']]]]] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2VolumeMountArgs', 'InfrastructureV2VolumeMountArgsDict']]]]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2VolumeArgs', 'InfrastructureV2VolumeArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource for managing Harness Chaos Infrastructure V2.

        ## Import

        The `pulumi import` command can be used, for example:

        Import Project level Chaos Infrastructure v2

        ```sh
        $ pulumi import harness:chaos/infrastructureV2:InfrastructureV2 example <org_id>/<project_id>/<environment_id>/<infra_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] ai_enabled: Enable AI features for the infrastructure.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotation: Annotations to apply to the infrastructure pods.
        :param pulumi.Input[_builtins.str] containers: Container configurations.
        :param pulumi.Input[_builtins.str] correlation_id: Correlation ID for the request.
        :param pulumi.Input[_builtins.str] description: Description of the infrastructure.
        :param pulumi.Input[_builtins.str] discovery_agent_id: ID of the discovery agent to use.
        :param pulumi.Input[_builtins.str] environment_id: The ID of the environment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2EnvArgs', 'InfrastructureV2EnvArgsDict']]]] envs: List of environment variables to set in the container.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2ImageRegistryArgs', 'InfrastructureV2ImageRegistryArgsDict']]]] image_registries: Configuration for the container image registry.
        :param pulumi.Input[_builtins.str] infra_id: ID of the infrastructure.
        :param pulumi.Input[_builtins.str] infra_scope: Scope of the infrastructure. Valid values: NAMESPACE, CLUSTER
        :param pulumi.Input[_builtins.str] infra_type: Type of the infrastructure. Valid values: KUBERNETES, KUBERNETESV2
        :param pulumi.Input[_builtins.bool] insecure_skip_verify: Skip TLS verification for the infrastructure.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] label: Labels to apply to the infrastructure pods.
        :param pulumi.Input[Union['InfrastructureV2MtlsArgs', 'InfrastructureV2MtlsArgsDict']] mtls: mTLS configuration for the infrastructure.
        :param pulumi.Input[_builtins.str] name: Name of the infrastructure.
        :param pulumi.Input[_builtins.str] namespace: Kubernetes namespace where the infrastructure will be installed. Maps to the infrastructure namespace.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] node_selector: Node selector for the infrastructure pods.
        :param pulumi.Input[_builtins.str] org_id: The ID of the organization.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input[Union['InfrastructureV2ProxyArgs', 'InfrastructureV2ProxyArgsDict']] proxy: Proxy configuration for the infrastructure.
        :param pulumi.Input[_builtins.int] run_as_group: Group ID to run the infrastructure as.
        :param pulumi.Input[_builtins.int] run_as_user: User ID to run the infrastructure as.
        :param pulumi.Input[_builtins.str] service_account: Service account used by the infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for the infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2TolerationArgs', 'InfrastructureV2TolerationArgsDict']]]] tolerations: If specified, the pod's tolerations.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2VolumeMountArgs', 'InfrastructureV2VolumeMountArgsDict']]]] volume_mounts: Volume mounts for the container.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2VolumeArgs', 'InfrastructureV2VolumeArgsDict']]]] volumes: Volumes to be created in the infrastructure.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InfrastructureV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing Harness Chaos Infrastructure V2.

        ## Import

        The `pulumi import` command can be used, for example:

        Import Project level Chaos Infrastructure v2

        ```sh
        $ pulumi import harness:chaos/infrastructureV2:InfrastructureV2 example <org_id>/<project_id>/<environment_id>/<infra_id>
        ```

        :param str resource_name: The name of the resource.
        :param InfrastructureV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InfrastructureV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ai_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 annotation: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 containers: Optional[pulumi.Input[_builtins.str]] = None,
                 correlation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 discovery_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2EnvArgs', 'InfrastructureV2EnvArgsDict']]]]] = None,
                 image_registries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2ImageRegistryArgs', 'InfrastructureV2ImageRegistryArgsDict']]]]] = None,
                 infra_id: Optional[pulumi.Input[_builtins.str]] = None,
                 infra_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 infra_type: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure_skip_verify: Optional[pulumi.Input[_builtins.bool]] = None,
                 label: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mtls: Optional[pulumi.Input[Union['InfrastructureV2MtlsArgs', 'InfrastructureV2MtlsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 node_selector: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy: Optional[pulumi.Input[Union['InfrastructureV2ProxyArgs', 'InfrastructureV2ProxyArgsDict']]] = None,
                 run_as_group: Optional[pulumi.Input[_builtins.int]] = None,
                 run_as_user: Optional[pulumi.Input[_builtins.int]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tolerations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2TolerationArgs', 'InfrastructureV2TolerationArgsDict']]]]] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2VolumeMountArgs', 'InfrastructureV2VolumeMountArgsDict']]]]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2VolumeArgs', 'InfrastructureV2VolumeArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InfrastructureV2Args.__new__(InfrastructureV2Args)

            __props__.__dict__["ai_enabled"] = ai_enabled
            __props__.__dict__["annotation"] = annotation
            __props__.__dict__["containers"] = containers
            __props__.__dict__["correlation_id"] = correlation_id
            __props__.__dict__["description"] = description
            __props__.__dict__["discovery_agent_id"] = discovery_agent_id
            if environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'environment_id'")
            __props__.__dict__["environment_id"] = environment_id
            __props__.__dict__["envs"] = envs
            __props__.__dict__["image_registries"] = image_registries
            if infra_id is None and not opts.urn:
                raise TypeError("Missing required property 'infra_id'")
            __props__.__dict__["infra_id"] = infra_id
            __props__.__dict__["infra_scope"] = infra_scope
            __props__.__dict__["infra_type"] = infra_type
            __props__.__dict__["insecure_skip_verify"] = insecure_skip_verify
            __props__.__dict__["label"] = label
            __props__.__dict__["mtls"] = mtls
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["node_selector"] = node_selector
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["proxy"] = proxy
            __props__.__dict__["run_as_group"] = run_as_group
            __props__.__dict__["run_as_user"] = run_as_user
            __props__.__dict__["service_account"] = service_account
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tolerations"] = tolerations
            __props__.__dict__["volume_mounts"] = volume_mounts
            __props__.__dict__["volumes"] = volumes
            __props__.__dict__["created_at"] = None
            __props__.__dict__["identifiers"] = None
            __props__.__dict__["identity"] = None
            __props__.__dict__["infra_namespace"] = None
            __props__.__dict__["install_command"] = None
            __props__.__dict__["k8s_connector_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        super(InfrastructureV2, __self__).__init__(
            'harness:chaos/infrastructureV2:InfrastructureV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ai_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            annotation: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            containers: Optional[pulumi.Input[_builtins.str]] = None,
            correlation_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            discovery_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
            environment_id: Optional[pulumi.Input[_builtins.str]] = None,
            envs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2EnvArgs', 'InfrastructureV2EnvArgsDict']]]]] = None,
            identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2IdentifierArgs', 'InfrastructureV2IdentifierArgsDict']]]]] = None,
            identity: Optional[pulumi.Input[_builtins.str]] = None,
            image_registries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2ImageRegistryArgs', 'InfrastructureV2ImageRegistryArgsDict']]]]] = None,
            infra_id: Optional[pulumi.Input[_builtins.str]] = None,
            infra_namespace: Optional[pulumi.Input[_builtins.str]] = None,
            infra_scope: Optional[pulumi.Input[_builtins.str]] = None,
            infra_type: Optional[pulumi.Input[_builtins.str]] = None,
            insecure_skip_verify: Optional[pulumi.Input[_builtins.bool]] = None,
            install_command: Optional[pulumi.Input[_builtins.str]] = None,
            k8s_connector_id: Optional[pulumi.Input[_builtins.str]] = None,
            label: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            mtls: Optional[pulumi.Input[Union['InfrastructureV2MtlsArgs', 'InfrastructureV2MtlsArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            node_selector: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            proxy: Optional[pulumi.Input[Union['InfrastructureV2ProxyArgs', 'InfrastructureV2ProxyArgsDict']]] = None,
            run_as_group: Optional[pulumi.Input[_builtins.int]] = None,
            run_as_user: Optional[pulumi.Input[_builtins.int]] = None,
            service_account: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tolerations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2TolerationArgs', 'InfrastructureV2TolerationArgsDict']]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2VolumeMountArgs', 'InfrastructureV2VolumeMountArgsDict']]]]] = None,
            volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2VolumeArgs', 'InfrastructureV2VolumeArgsDict']]]]] = None) -> 'InfrastructureV2':
        """
        Get an existing InfrastructureV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] ai_enabled: Enable AI features for the infrastructure.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotation: Annotations to apply to the infrastructure pods.
        :param pulumi.Input[_builtins.str] containers: Container configurations.
        :param pulumi.Input[_builtins.str] correlation_id: Correlation ID for the request.
        :param pulumi.Input[_builtins.str] created_at: Creation timestamp.
        :param pulumi.Input[_builtins.str] description: Description of the infrastructure.
        :param pulumi.Input[_builtins.str] discovery_agent_id: ID of the discovery agent to use.
        :param pulumi.Input[_builtins.str] environment_id: The ID of the environment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2EnvArgs', 'InfrastructureV2EnvArgsDict']]]] envs: List of environment variables to set in the container.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2IdentifierArgs', 'InfrastructureV2IdentifierArgsDict']]]] identifiers: Identifier for the infrastructure.
        :param pulumi.Input[_builtins.str] identity: Identity for the infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2ImageRegistryArgs', 'InfrastructureV2ImageRegistryArgsDict']]]] image_registries: Configuration for the container image registry.
        :param pulumi.Input[_builtins.str] infra_id: ID of the infrastructure.
        :param pulumi.Input[_builtins.str] infra_namespace: Namespace where the infrastructure is installed.
        :param pulumi.Input[_builtins.str] infra_scope: Scope of the infrastructure. Valid values: NAMESPACE, CLUSTER
        :param pulumi.Input[_builtins.str] infra_type: Type of the infrastructure. Valid values: KUBERNETES, KUBERNETESV2
        :param pulumi.Input[_builtins.bool] insecure_skip_verify: Skip TLS verification for the infrastructure.
        :param pulumi.Input[_builtins.str] install_command: Installation command for the infrastructure.
        :param pulumi.Input[_builtins.str] k8s_connector_id: Kubernetes connector identifier.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] label: Labels to apply to the infrastructure pods.
        :param pulumi.Input[Union['InfrastructureV2MtlsArgs', 'InfrastructureV2MtlsArgsDict']] mtls: mTLS configuration for the infrastructure.
        :param pulumi.Input[_builtins.str] name: Name of the infrastructure.
        :param pulumi.Input[_builtins.str] namespace: Kubernetes namespace where the infrastructure will be installed. Maps to the infrastructure namespace.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] node_selector: Node selector for the infrastructure pods.
        :param pulumi.Input[_builtins.str] org_id: The ID of the organization.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input[Union['InfrastructureV2ProxyArgs', 'InfrastructureV2ProxyArgsDict']] proxy: Proxy configuration for the infrastructure.
        :param pulumi.Input[_builtins.int] run_as_group: Group ID to run the infrastructure as.
        :param pulumi.Input[_builtins.int] run_as_user: User ID to run the infrastructure as.
        :param pulumi.Input[_builtins.str] service_account: Service account used by the infrastructure.
        :param pulumi.Input[_builtins.str] status: Status of the infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for the infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2TolerationArgs', 'InfrastructureV2TolerationArgsDict']]]] tolerations: If specified, the pod's tolerations.
        :param pulumi.Input[_builtins.str] updated_at: Last update timestamp.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2VolumeMountArgs', 'InfrastructureV2VolumeMountArgsDict']]]] volume_mounts: Volume mounts for the container.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureV2VolumeArgs', 'InfrastructureV2VolumeArgsDict']]]] volumes: Volumes to be created in the infrastructure.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InfrastructureV2State.__new__(_InfrastructureV2State)

        __props__.__dict__["ai_enabled"] = ai_enabled
        __props__.__dict__["annotation"] = annotation
        __props__.__dict__["containers"] = containers
        __props__.__dict__["correlation_id"] = correlation_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["discovery_agent_id"] = discovery_agent_id
        __props__.__dict__["environment_id"] = environment_id
        __props__.__dict__["envs"] = envs
        __props__.__dict__["identifiers"] = identifiers
        __props__.__dict__["identity"] = identity
        __props__.__dict__["image_registries"] = image_registries
        __props__.__dict__["infra_id"] = infra_id
        __props__.__dict__["infra_namespace"] = infra_namespace
        __props__.__dict__["infra_scope"] = infra_scope
        __props__.__dict__["infra_type"] = infra_type
        __props__.__dict__["insecure_skip_verify"] = insecure_skip_verify
        __props__.__dict__["install_command"] = install_command
        __props__.__dict__["k8s_connector_id"] = k8s_connector_id
        __props__.__dict__["label"] = label
        __props__.__dict__["mtls"] = mtls
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["node_selector"] = node_selector
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["proxy"] = proxy
        __props__.__dict__["run_as_group"] = run_as_group
        __props__.__dict__["run_as_user"] = run_as_user
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tolerations"] = tolerations
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["volume_mounts"] = volume_mounts
        __props__.__dict__["volumes"] = volumes
        return InfrastructureV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aiEnabled")
    def ai_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable AI features for the infrastructure.
        """
        return pulumi.get(self, "ai_enabled")

    @_builtins.property
    @pulumi.getter
    def annotation(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Annotations to apply to the infrastructure pods.
        """
        return pulumi.get(self, "annotation")

    @_builtins.property
    @pulumi.getter
    def containers(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Container configurations.
        """
        return pulumi.get(self, "containers")

    @_builtins.property
    @pulumi.getter(name="correlationId")
    def correlation_id(self) -> pulumi.Output[_builtins.str]:
        """
        Correlation ID for the request.
        """
        return pulumi.get(self, "correlation_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Creation timestamp.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the infrastructure.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="discoveryAgentId")
    def discovery_agent_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the discovery agent to use.
        """
        return pulumi.get(self, "discovery_agent_id")

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the environment.
        """
        return pulumi.get(self, "environment_id")

    @_builtins.property
    @pulumi.getter
    def envs(self) -> pulumi.Output[Optional[Sequence['outputs.InfrastructureV2Env']]]:
        """
        List of environment variables to set in the container.
        """
        return pulumi.get(self, "envs")

    @_builtins.property
    @pulumi.getter
    def identifiers(self) -> pulumi.Output[Sequence['outputs.InfrastructureV2Identifier']]:
        """
        Identifier for the infrastructure.
        """
        return pulumi.get(self, "identifiers")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[_builtins.str]:
        """
        Identity for the infrastructure.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="imageRegistries")
    def image_registries(self) -> pulumi.Output[Sequence['outputs.InfrastructureV2ImageRegistry']]:
        """
        Configuration for the container image registry.
        """
        return pulumi.get(self, "image_registries")

    @_builtins.property
    @pulumi.getter(name="infraId")
    def infra_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the infrastructure.
        """
        return pulumi.get(self, "infra_id")

    @_builtins.property
    @pulumi.getter(name="infraNamespace")
    def infra_namespace(self) -> pulumi.Output[_builtins.str]:
        """
        Namespace where the infrastructure is installed.
        """
        return pulumi.get(self, "infra_namespace")

    @_builtins.property
    @pulumi.getter(name="infraScope")
    def infra_scope(self) -> pulumi.Output[_builtins.str]:
        """
        Scope of the infrastructure. Valid values: NAMESPACE, CLUSTER
        """
        return pulumi.get(self, "infra_scope")

    @_builtins.property
    @pulumi.getter(name="infraType")
    def infra_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Type of the infrastructure. Valid values: KUBERNETES, KUBERNETESV2
        """
        return pulumi.get(self, "infra_type")

    @_builtins.property
    @pulumi.getter(name="insecureSkipVerify")
    def insecure_skip_verify(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Skip TLS verification for the infrastructure.
        """
        return pulumi.get(self, "insecure_skip_verify")

    @_builtins.property
    @pulumi.getter(name="installCommand")
    def install_command(self) -> pulumi.Output[_builtins.str]:
        """
        Installation command for the infrastructure.
        """
        return pulumi.get(self, "install_command")

    @_builtins.property
    @pulumi.getter(name="k8sConnectorId")
    def k8s_connector_id(self) -> pulumi.Output[_builtins.str]:
        """
        Kubernetes connector identifier.
        """
        return pulumi.get(self, "k8s_connector_id")

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels to apply to the infrastructure pods.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def mtls(self) -> pulumi.Output[Optional['outputs.InfrastructureV2Mtls']]:
        """
        mTLS configuration for the infrastructure.
        """
        return pulumi.get(self, "mtls")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the infrastructure.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Kubernetes namespace where the infrastructure will be installed. Maps to the infrastructure namespace.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Node selector for the infrastructure pods.
        """
        return pulumi.get(self, "node_selector")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def proxy(self) -> pulumi.Output[Optional['outputs.InfrastructureV2Proxy']]:
        """
        Proxy configuration for the infrastructure.
        """
        return pulumi.get(self, "proxy")

    @_builtins.property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Group ID to run the infrastructure as.
        """
        return pulumi.get(self, "run_as_group")

    @_builtins.property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        User ID to run the infrastructure as.
        """
        return pulumi.get(self, "run_as_user")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Service account used by the infrastructure.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the infrastructure.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags for the infrastructure.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def tolerations(self) -> pulumi.Output[Optional[Sequence['outputs.InfrastructureV2Toleration']]]:
        """
        If specified, the pod's tolerations.
        """
        return pulumi.get(self, "tolerations")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Last update timestamp.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> pulumi.Output[Optional[Sequence['outputs.InfrastructureV2VolumeMount']]]:
        """
        Volume mounts for the container.
        """
        return pulumi.get(self, "volume_mounts")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> pulumi.Output[Optional[Sequence['outputs.InfrastructureV2Volume']]]:
        """
        Volumes to be created in the infrastructure.
        """
        return pulumi.get(self, "volumes")

