# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityGovernanceRuleArgs', 'SecurityGovernanceRule']

@pulumi.input_type
class SecurityGovernanceRuleArgs:
    def __init__(__self__, *,
                 condition_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 org_id: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 time_windows: pulumi.Input[Sequence[pulumi.Input['SecurityGovernanceRuleTimeWindowArgs']]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SecurityGovernanceRule resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] condition_ids: List of condition IDs associated with this rule
        :param pulumi.Input[_builtins.str] org_id: The organization ID of the security governance rule
        :param pulumi.Input[_builtins.str] project_id: The project ID of the security governance rule
        :param pulumi.Input[_builtins.str] description: Description of the security governance rule
        :param pulumi.Input[_builtins.bool] is_enabled: Whether the rule is enabled
        :param pulumi.Input[_builtins.str] name: Name of the security governance rule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for the security governance rule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_group_ids: List of user group IDs associated with this rule
        """
        pulumi.set(__self__, "condition_ids", condition_ids)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "time_windows", time_windows)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_group_ids is not None:
            pulumi.set(__self__, "user_group_ids", user_group_ids)

    @_builtins.property
    @pulumi.getter(name="conditionIds")
    def condition_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of condition IDs associated with this rule
        """
        return pulumi.get(self, "condition_ids")

    @condition_ids.setter
    def condition_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "condition_ids", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[_builtins.str]:
        """
        The organization ID of the security governance rule
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The project ID of the security governance rule
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="timeWindows")
    def time_windows(self) -> pulumi.Input[Sequence[pulumi.Input['SecurityGovernanceRuleTimeWindowArgs']]]:
        return pulumi.get(self, "time_windows")

    @time_windows.setter
    def time_windows(self, value: pulumi.Input[Sequence[pulumi.Input['SecurityGovernanceRuleTimeWindowArgs']]]):
        pulumi.set(self, "time_windows", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the security governance rule
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the rule is enabled
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the security governance rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags for the security governance rule
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userGroupIds")
    def user_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of user group IDs associated with this rule
        """
        return pulumi.get(self, "user_group_ids")

    @user_group_ids.setter
    def user_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "user_group_ids", value)


@pulumi.input_type
class _SecurityGovernanceRuleState:
    def __init__(__self__, *,
                 condition_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_windows: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityGovernanceRuleTimeWindowArgs']]]] = None,
                 user_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering SecurityGovernanceRule resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] condition_ids: List of condition IDs associated with this rule
        :param pulumi.Input[_builtins.str] description: Description of the security governance rule
        :param pulumi.Input[_builtins.bool] is_enabled: Whether the rule is enabled
        :param pulumi.Input[_builtins.str] name: Name of the security governance rule
        :param pulumi.Input[_builtins.str] org_id: The organization ID of the security governance rule
        :param pulumi.Input[_builtins.str] project_id: The project ID of the security governance rule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for the security governance rule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_group_ids: List of user group IDs associated with this rule
        """
        if condition_ids is not None:
            pulumi.set(__self__, "condition_ids", condition_ids)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_windows is not None:
            pulumi.set(__self__, "time_windows", time_windows)
        if user_group_ids is not None:
            pulumi.set(__self__, "user_group_ids", user_group_ids)

    @_builtins.property
    @pulumi.getter(name="conditionIds")
    def condition_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of condition IDs associated with this rule
        """
        return pulumi.get(self, "condition_ids")

    @condition_ids.setter
    def condition_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "condition_ids", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the security governance rule
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the rule is enabled
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the security governance rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organization ID of the security governance rule
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project ID of the security governance rule
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags for the security governance rule
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeWindows")
    def time_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityGovernanceRuleTimeWindowArgs']]]]:
        return pulumi.get(self, "time_windows")

    @time_windows.setter
    def time_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityGovernanceRuleTimeWindowArgs']]]]):
        pulumi.set(self, "time_windows", value)

    @_builtins.property
    @pulumi.getter(name="userGroupIds")
    def user_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of user group IDs associated with this rule
        """
        return pulumi.get(self, "user_group_ids")

    @user_group_ids.setter
    def user_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "user_group_ids", value)


@pulumi.type_token("harness:chaos/securityGovernanceRule:SecurityGovernanceRule")
class SecurityGovernanceRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_windows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityGovernanceRuleTimeWindowArgs', 'SecurityGovernanceRuleTimeWindowArgsDict']]]]] = None,
                 user_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for managing a Harness Chaos Security Governance Rule

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        # K8s Rule
        example = harness.chaos.SecurityGovernanceRule("example",
            org_id="<org_id>",
            project_id="<project_id>",
            name="<name>",
            description="<description>",
            is_enabled=True,
            condition_ids=["<condition_id>"],
            user_group_ids=["_project_all_users"],
            tags=[
                "<tag1>",
                "<tag2>",
            ],
            time_windows=[{
                "time_zone": "UTC",
                "start_time": 1711238400000,
                "duration": "24h",
                "recurrence": {
                    "type": "Daily",
                    "until": -1,
                },
            }])
        # Linux Rule
        linux_rule = harness.chaos.SecurityGovernanceRule("linux_rule",
            org_id="<org_id>",
            project_id="<project_id>",
            name="<name>",
            description="<description>",
            is_enabled=True,
            condition_ids=["<condition_id>"],
            user_group_ids=["_project_all_users"],
            tags=[
                "<tag1>",
                "<tag2>",
            ],
            time_windows=[{
                "time_zone": "UTC",
                "start_time": 1711238400000,
                "duration": "24h",
                "recurrence": {
                    "type": "Daily",
                    "until": -1,
                },
            }])
        # Windows Rule
        windows_rule = harness.chaos.SecurityGovernanceRule("windows_rule",
            org_id="<org_id>",
            project_id="<project_id>",
            name="<name>",
            description="<description>",
            is_enabled=True,
            condition_ids=["<condition_id>"],
            user_group_ids=["_project_all_users"],
            tags=[
                "<tag1>",
                "<tag2>",
            ],
            time_windows=[{
                "time_zone": "UTC",
                "start_time": 1711238400000,
                "duration": "24h",
                "recurrence": {
                    "type": "Daily",
                    "until": -1,
                },
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Import Project level Chaos Security Governance Rule

        ```sh
        $ pulumi import harness:chaos/securityGovernanceRule:SecurityGovernanceRule example org_id/project_id/rule_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] condition_ids: List of condition IDs associated with this rule
        :param pulumi.Input[_builtins.str] description: Description of the security governance rule
        :param pulumi.Input[_builtins.bool] is_enabled: Whether the rule is enabled
        :param pulumi.Input[_builtins.str] name: Name of the security governance rule
        :param pulumi.Input[_builtins.str] org_id: The organization ID of the security governance rule
        :param pulumi.Input[_builtins.str] project_id: The project ID of the security governance rule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for the security governance rule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_group_ids: List of user group IDs associated with this rule
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityGovernanceRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing a Harness Chaos Security Governance Rule

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        # K8s Rule
        example = harness.chaos.SecurityGovernanceRule("example",
            org_id="<org_id>",
            project_id="<project_id>",
            name="<name>",
            description="<description>",
            is_enabled=True,
            condition_ids=["<condition_id>"],
            user_group_ids=["_project_all_users"],
            tags=[
                "<tag1>",
                "<tag2>",
            ],
            time_windows=[{
                "time_zone": "UTC",
                "start_time": 1711238400000,
                "duration": "24h",
                "recurrence": {
                    "type": "Daily",
                    "until": -1,
                },
            }])
        # Linux Rule
        linux_rule = harness.chaos.SecurityGovernanceRule("linux_rule",
            org_id="<org_id>",
            project_id="<project_id>",
            name="<name>",
            description="<description>",
            is_enabled=True,
            condition_ids=["<condition_id>"],
            user_group_ids=["_project_all_users"],
            tags=[
                "<tag1>",
                "<tag2>",
            ],
            time_windows=[{
                "time_zone": "UTC",
                "start_time": 1711238400000,
                "duration": "24h",
                "recurrence": {
                    "type": "Daily",
                    "until": -1,
                },
            }])
        # Windows Rule
        windows_rule = harness.chaos.SecurityGovernanceRule("windows_rule",
            org_id="<org_id>",
            project_id="<project_id>",
            name="<name>",
            description="<description>",
            is_enabled=True,
            condition_ids=["<condition_id>"],
            user_group_ids=["_project_all_users"],
            tags=[
                "<tag1>",
                "<tag2>",
            ],
            time_windows=[{
                "time_zone": "UTC",
                "start_time": 1711238400000,
                "duration": "24h",
                "recurrence": {
                    "type": "Daily",
                    "until": -1,
                },
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Import Project level Chaos Security Governance Rule

        ```sh
        $ pulumi import harness:chaos/securityGovernanceRule:SecurityGovernanceRule example org_id/project_id/rule_id
        ```

        :param str resource_name: The name of the resource.
        :param SecurityGovernanceRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityGovernanceRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_windows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityGovernanceRuleTimeWindowArgs', 'SecurityGovernanceRuleTimeWindowArgsDict']]]]] = None,
                 user_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityGovernanceRuleArgs.__new__(SecurityGovernanceRuleArgs)

            if condition_ids is None and not opts.urn:
                raise TypeError("Missing required property 'condition_ids'")
            __props__.__dict__["condition_ids"] = condition_ids
            __props__.__dict__["description"] = description
            __props__.__dict__["is_enabled"] = is_enabled
            __props__.__dict__["name"] = name
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["tags"] = tags
            if time_windows is None and not opts.urn:
                raise TypeError("Missing required property 'time_windows'")
            __props__.__dict__["time_windows"] = time_windows
            __props__.__dict__["user_group_ids"] = user_group_ids
        super(SecurityGovernanceRule, __self__).__init__(
            'harness:chaos/securityGovernanceRule:SecurityGovernanceRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            condition_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            time_windows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityGovernanceRuleTimeWindowArgs', 'SecurityGovernanceRuleTimeWindowArgsDict']]]]] = None,
            user_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'SecurityGovernanceRule':
        """
        Get an existing SecurityGovernanceRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] condition_ids: List of condition IDs associated with this rule
        :param pulumi.Input[_builtins.str] description: Description of the security governance rule
        :param pulumi.Input[_builtins.bool] is_enabled: Whether the rule is enabled
        :param pulumi.Input[_builtins.str] name: Name of the security governance rule
        :param pulumi.Input[_builtins.str] org_id: The organization ID of the security governance rule
        :param pulumi.Input[_builtins.str] project_id: The project ID of the security governance rule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for the security governance rule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_group_ids: List of user group IDs associated with this rule
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityGovernanceRuleState.__new__(_SecurityGovernanceRuleState)

        __props__.__dict__["condition_ids"] = condition_ids
        __props__.__dict__["description"] = description
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["time_windows"] = time_windows
        __props__.__dict__["user_group_ids"] = user_group_ids
        return SecurityGovernanceRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="conditionIds")
    def condition_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of condition IDs associated with this rule
        """
        return pulumi.get(self, "condition_ids")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the security governance rule
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the rule is enabled
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the security governance rule
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[_builtins.str]:
        """
        The organization ID of the security governance rule
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The project ID of the security governance rule
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags for the security governance rule
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="timeWindows")
    def time_windows(self) -> pulumi.Output[Sequence['outputs.SecurityGovernanceRuleTimeWindow']]:
        return pulumi.get(self, "time_windows")

    @_builtins.property
    @pulumi.getter(name="userGroupIds")
    def user_group_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of user group IDs associated with this rule
        """
        return pulumi.get(self, "user_group_ids")

