# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetDelegateResult',
    'AwaitableGetDelegateResult',
    'get_delegate',
    'get_delegate_output',
]

@pulumi.output_type
class GetDelegateResult:
    """
    A collection of values returned by getDelegate.
    """
    def __init__(__self__, account_id=None, description=None, hostname=None, id=None, ip=None, last_heartbeat=None, name=None, polling_mode_enabled=None, profile_id=None, status=None, type=None, version=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip and not isinstance(ip, str):
            raise TypeError("Expected argument 'ip' to be a str")
        pulumi.set(__self__, "ip", ip)
        if last_heartbeat and not isinstance(last_heartbeat, str):
            raise TypeError("Expected argument 'last_heartbeat' to be a str")
        pulumi.set(__self__, "last_heartbeat", last_heartbeat)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if polling_mode_enabled and not isinstance(polling_mode_enabled, bool):
            raise TypeError("Expected argument 'polling_mode_enabled' to be a bool")
        pulumi.set(__self__, "polling_mode_enabled", polling_mode_enabled)
        if profile_id and not isinstance(profile_id, str):
            raise TypeError("Expected argument 'profile_id' to be a str")
        pulumi.set(__self__, "profile_id", profile_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        The account id the delegate belongs to.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the delegate.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        The hostname of the delegate.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Unique identifier of the delegate
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The ip address of the delegate.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="lastHeartbeat")
    def last_heartbeat(self) -> _builtins.str:
        """
        The last time the delegate was heard from.
        """
        return pulumi.get(self, "last_heartbeat")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the delegate to query for.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pollingModeEnabled")
    def polling_mode_enabled(self) -> _builtins.bool:
        """
        Whether the delegate is in polling mode.
        """
        return pulumi.get(self, "polling_mode_enabled")

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> _builtins.str:
        """
        The id of the profile assigned to the delegate.
        """
        return pulumi.get(self, "profile_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the delegate to query for. Valid values are DELETED, ENABLED, WAITING*FOR*APPROVAL
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of the delegate to query for. Valid values are DOCKER, ECS, HELM*DELEGATE, KUBERNETES, SHELL*SCRIPT
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the delegate.
        """
        return pulumi.get(self, "version")


class AwaitableGetDelegateResult(GetDelegateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDelegateResult(
            account_id=self.account_id,
            description=self.description,
            hostname=self.hostname,
            id=self.id,
            ip=self.ip,
            last_heartbeat=self.last_heartbeat,
            name=self.name,
            polling_mode_enabled=self.polling_mode_enabled,
            profile_id=self.profile_id,
            status=self.status,
            type=self.type,
            version=self.version)


def get_delegate(hostname: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDelegateResult:
    """
    Data source for retrieving a Harness delegate. If more than one delegate matches the query the first one will be returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.get_delegate(name="harness-delegate",
        type="KUBERNETES",
        status="ENABLED")
    ```


    :param _builtins.str hostname: The hostname of the delegate.
    :param _builtins.str id: Unique identifier of the delegate
    :param _builtins.str name: The name of the delegate to query for.
    :param _builtins.str status: The status of the delegate to query for. Valid values are DELETED, ENABLED, WAITING*FOR*APPROVAL
    :param _builtins.str type: The type of the delegate to query for. Valid values are DOCKER, ECS, HELM*DELEGATE, KUBERNETES, SHELL*SCRIPT
    """
    __args__ = dict()
    __args__['hostname'] = hostname
    __args__['id'] = id
    __args__['name'] = name
    __args__['status'] = status
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:index/getDelegate:getDelegate', __args__, opts=opts, typ=GetDelegateResult).value

    return AwaitableGetDelegateResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        description=pulumi.get(__ret__, 'description'),
        hostname=pulumi.get(__ret__, 'hostname'),
        id=pulumi.get(__ret__, 'id'),
        ip=pulumi.get(__ret__, 'ip'),
        last_heartbeat=pulumi.get(__ret__, 'last_heartbeat'),
        name=pulumi.get(__ret__, 'name'),
        polling_mode_enabled=pulumi.get(__ret__, 'polling_mode_enabled'),
        profile_id=pulumi.get(__ret__, 'profile_id'),
        status=pulumi.get(__ret__, 'status'),
        type=pulumi.get(__ret__, 'type'),
        version=pulumi.get(__ret__, 'version'))
def get_delegate_output(hostname: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDelegateResult]:
    """
    Data source for retrieving a Harness delegate. If more than one delegate matches the query the first one will be returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.get_delegate(name="harness-delegate",
        type="KUBERNETES",
        status="ENABLED")
    ```


    :param _builtins.str hostname: The hostname of the delegate.
    :param _builtins.str id: Unique identifier of the delegate
    :param _builtins.str name: The name of the delegate to query for.
    :param _builtins.str status: The status of the delegate to query for. Valid values are DELETED, ENABLED, WAITING*FOR*APPROVAL
    :param _builtins.str type: The type of the delegate to query for. Valid values are DOCKER, ECS, HELM*DELEGATE, KUBERNETES, SHELL*SCRIPT
    """
    __args__ = dict()
    __args__['hostname'] = hostname
    __args__['id'] = id
    __args__['name'] = name
    __args__['status'] = status
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:index/getDelegate:getDelegate', __args__, opts=opts, typ=GetDelegateResult)
    return __ret__.apply(lambda __response__: GetDelegateResult(
        account_id=pulumi.get(__response__, 'account_id'),
        description=pulumi.get(__response__, 'description'),
        hostname=pulumi.get(__response__, 'hostname'),
        id=pulumi.get(__response__, 'id'),
        ip=pulumi.get(__response__, 'ip'),
        last_heartbeat=pulumi.get(__response__, 'last_heartbeat'),
        name=pulumi.get(__response__, 'name'),
        polling_mode_enabled=pulumi.get(__response__, 'polling_mode_enabled'),
        profile_id=pulumi.get(__response__, 'profile_id'),
        status=pulumi.get(__response__, 'status'),
        type=pulumi.get(__response__, 'type'),
        version=pulumi.get(__response__, 'version')))
