# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RuleSetArgs', 'RuleSet']

@pulumi.input_type
class RuleSetArgs:
    def __init__(__self__, *,
                 cloud_provider: pulumi.Input[_builtins.str],
                 rule_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RuleSet resource.
        :param pulumi.Input[_builtins.str] cloud_provider: The cloud provider for the rule set. It should be either AWS, AZURE or GCP.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rule_ids: List of rule IDs
        :param pulumi.Input[_builtins.str] description: Description for rule set.
        :param pulumi.Input[_builtins.str] name: Name of the rule set.
        """
        pulumi.set(__self__, "cloud_provider", cloud_provider)
        pulumi.set(__self__, "rule_ids", rule_ids)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> pulumi.Input[_builtins.str]:
        """
        The cloud provider for the rule set. It should be either AWS, AZURE or GCP.
        """
        return pulumi.get(self, "cloud_provider")

    @cloud_provider.setter
    def cloud_provider(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cloud_provider", value)

    @_builtins.property
    @pulumi.getter(name="ruleIds")
    def rule_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of rule IDs
        """
        return pulumi.get(self, "rule_ids")

    @rule_ids.setter
    def rule_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "rule_ids", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for rule set.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the rule set.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _RuleSetState:
    def __init__(__self__, *,
                 cloud_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rule_set_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RuleSet resources.
        :param pulumi.Input[_builtins.str] cloud_provider: The cloud provider for the rule set. It should be either AWS, AZURE or GCP.
        :param pulumi.Input[_builtins.str] description: Description for rule set.
        :param pulumi.Input[_builtins.str] name: Name of the rule set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rule_ids: List of rule IDs
        :param pulumi.Input[_builtins.str] rule_set_id: Id of the rule.
        """
        if cloud_provider is not None:
            pulumi.set(__self__, "cloud_provider", cloud_provider)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rule_ids is not None:
            pulumi.set(__self__, "rule_ids", rule_ids)
        if rule_set_id is not None:
            pulumi.set(__self__, "rule_set_id", rule_set_id)

    @_builtins.property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cloud provider for the rule set. It should be either AWS, AZURE or GCP.
        """
        return pulumi.get(self, "cloud_provider")

    @cloud_provider.setter
    def cloud_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_provider", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for rule set.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the rule set.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ruleIds")
    def rule_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of rule IDs
        """
        return pulumi.get(self, "rule_ids")

    @rule_ids.setter
    def rule_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rule_ids", value)

    @_builtins.property
    @pulumi.getter(name="ruleSetId")
    def rule_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the rule.
        """
        return pulumi.get(self, "rule_set_id")

    @rule_set_id.setter
    def rule_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_set_id", value)


@pulumi.type_token("harness:governance/ruleSet:RuleSet")
class RuleSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for creating, updating, and managing rule.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud_provider: The cloud provider for the rule set. It should be either AWS, AZURE or GCP.
        :param pulumi.Input[_builtins.str] description: Description for rule set.
        :param pulumi.Input[_builtins.str] name: Name of the rule set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rule_ids: List of rule IDs
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleSetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating, updating, and managing rule.

        :param str resource_name: The name of the resource.
        :param RuleSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleSetArgs.__new__(RuleSetArgs)

            if cloud_provider is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_provider'")
            __props__.__dict__["cloud_provider"] = cloud_provider
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if rule_ids is None and not opts.urn:
                raise TypeError("Missing required property 'rule_ids'")
            __props__.__dict__["rule_ids"] = rule_ids
            __props__.__dict__["rule_set_id"] = None
        super(RuleSet, __self__).__init__(
            'harness:governance/ruleSet:RuleSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_provider: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            rule_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            rule_set_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RuleSet':
        """
        Get an existing RuleSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud_provider: The cloud provider for the rule set. It should be either AWS, AZURE or GCP.
        :param pulumi.Input[_builtins.str] description: Description for rule set.
        :param pulumi.Input[_builtins.str] name: Name of the rule set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rule_ids: List of rule IDs
        :param pulumi.Input[_builtins.str] rule_set_id: Id of the rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleSetState.__new__(_RuleSetState)

        __props__.__dict__["cloud_provider"] = cloud_provider
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["rule_ids"] = rule_ids
        __props__.__dict__["rule_set_id"] = rule_set_id
        return RuleSet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> pulumi.Output[_builtins.str]:
        """
        The cloud provider for the rule set. It should be either AWS, AZURE or GCP.
        """
        return pulumi.get(self, "cloud_provider")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description for rule set.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the rule set.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ruleIds")
    def rule_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of rule IDs
        """
        return pulumi.get(self, "rule_ids")

    @_builtins.property
    @pulumi.getter(name="ruleSetId")
    def rule_set_id(self) -> pulumi.Output[_builtins.str]:
        """
        Id of the rule.
        """
        return pulumi.get(self, "rule_set_id")

