# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsKmsConnectorArgs', 'AwsKmsConnector']

@pulumi.input_type
class AwsKmsConnectorArgs:
    def __init__(__self__, *,
                 credentials: pulumi.Input['AwsKmsConnectorCredentialsArgs'],
                 identifier: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 arn_plaintext: Optional[pulumi.Input[_builtins.str]] = None,
                 arn_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AwsKmsConnector resource.
        :param pulumi.Input['AwsKmsConnectorCredentialsArgs'] credentials: Credentials to connect to AWS.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] region: The AWS region where the AWS Secret Manager is.
        :param pulumi.Input[_builtins.str] arn_plaintext: A reference to the Harness secret containing the ARN of the AWS KMS.
        :param pulumi.Input[_builtins.str] arn_ref: A reference to the Harness secret containing the ARN of the AWS KMS. To reference a secret at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference a secret at the account scope, prefix 'account` to the expression: account.{identifier}.
        :param pulumi.Input[_builtins.bool] default: Set this connector as the default for all the services.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.bool] execute_on_delegate: Execute the command on the delegate.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "region", region)
        if arn_plaintext is not None:
            pulumi.set(__self__, "arn_plaintext", arn_plaintext)
        if arn_ref is not None:
            pulumi.set(__self__, "arn_ref", arn_ref)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if delegate_selectors is not None:
            pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execute_on_delegate is not None:
            pulumi.set(__self__, "execute_on_delegate", execute_on_delegate)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> pulumi.Input['AwsKmsConnectorCredentialsArgs']:
        """
        Credentials to connect to AWS.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: pulumi.Input['AwsKmsConnectorCredentialsArgs']):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The AWS region where the AWS Secret Manager is.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="arnPlaintext")
    def arn_plaintext(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A reference to the Harness secret containing the ARN of the AWS KMS.
        """
        return pulumi.get(self, "arn_plaintext")

    @arn_plaintext.setter
    def arn_plaintext(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn_plaintext", value)

    @_builtins.property
    @pulumi.getter(name="arnRef")
    def arn_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A reference to the Harness secret containing the ARN of the AWS KMS. To reference a secret at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference a secret at the account scope, prefix 'account` to the expression: account.{identifier}.
        """
        return pulumi.get(self, "arn_ref")

    @arn_ref.setter
    def arn_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn_ref", value)

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set this connector as the default for all the services.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default", value)

    @_builtins.property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to filter delegates for connection.
        """
        return pulumi.get(self, "delegate_selectors")

    @delegate_selectors.setter
    def delegate_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "delegate_selectors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="executeOnDelegate")
    def execute_on_delegate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Execute the command on the delegate.
        """
        return pulumi.get(self, "execute_on_delegate")

    @execute_on_delegate.setter
    def execute_on_delegate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "execute_on_delegate", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AwsKmsConnectorState:
    def __init__(__self__, *,
                 arn_plaintext: Optional[pulumi.Input[_builtins.str]] = None,
                 arn_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input['AwsKmsConnectorCredentialsArgs']] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering AwsKmsConnector resources.
        :param pulumi.Input[_builtins.str] arn_plaintext: A reference to the Harness secret containing the ARN of the AWS KMS.
        :param pulumi.Input[_builtins.str] arn_ref: A reference to the Harness secret containing the ARN of the AWS KMS. To reference a secret at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference a secret at the account scope, prefix 'account` to the expression: account.{identifier}.
        :param pulumi.Input['AwsKmsConnectorCredentialsArgs'] credentials: Credentials to connect to AWS.
        :param pulumi.Input[_builtins.bool] default: Set this connector as the default for all the services.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.bool] execute_on_delegate: Execute the command on the delegate.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.str] region: The AWS region where the AWS Secret Manager is.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        if arn_plaintext is not None:
            pulumi.set(__self__, "arn_plaintext", arn_plaintext)
        if arn_ref is not None:
            pulumi.set(__self__, "arn_ref", arn_ref)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if delegate_selectors is not None:
            pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execute_on_delegate is not None:
            pulumi.set(__self__, "execute_on_delegate", execute_on_delegate)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="arnPlaintext")
    def arn_plaintext(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A reference to the Harness secret containing the ARN of the AWS KMS.
        """
        return pulumi.get(self, "arn_plaintext")

    @arn_plaintext.setter
    def arn_plaintext(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn_plaintext", value)

    @_builtins.property
    @pulumi.getter(name="arnRef")
    def arn_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A reference to the Harness secret containing the ARN of the AWS KMS. To reference a secret at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference a secret at the account scope, prefix 'account` to the expression: account.{identifier}.
        """
        return pulumi.get(self, "arn_ref")

    @arn_ref.setter
    def arn_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn_ref", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['AwsKmsConnectorCredentialsArgs']]:
        """
        Credentials to connect to AWS.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['AwsKmsConnectorCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set this connector as the default for all the services.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default", value)

    @_builtins.property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to filter delegates for connection.
        """
        return pulumi.get(self, "delegate_selectors")

    @delegate_selectors.setter
    def delegate_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "delegate_selectors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="executeOnDelegate")
    def execute_on_delegate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Execute the command on the delegate.
        """
        return pulumi.get(self, "execute_on_delegate")

    @execute_on_delegate.setter
    def execute_on_delegate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "execute_on_delegate", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS region where the AWS Secret Manager is.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("harness:platform/awsKmsConnector:AwsKmsConnector")
class AwsKmsConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arn_plaintext: Optional[pulumi.Input[_builtins.str]] = None,
                 arn_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[Union['AwsKmsConnectorCredentialsArgs', 'AwsKmsConnectorCredentialsArgsDict']]] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for creating an AWS KMS connector.

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level awskms connector

        ```sh
        $ pulumi import harness:platform/awsKmsConnector:AwsKmsConnector example <connector_id>
        ```

        Import org level awskms connector

        ```sh
        $ pulumi import harness:platform/awsKmsConnector:AwsKmsConnector example <ord_id>/<connector_id>
        ```

        Import project level awskms connector

        ```sh
        $ pulumi import harness:platform/awsKmsConnector:AwsKmsConnector example <org_id>/<project_id>/<connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn_plaintext: A reference to the Harness secret containing the ARN of the AWS KMS.
        :param pulumi.Input[_builtins.str] arn_ref: A reference to the Harness secret containing the ARN of the AWS KMS. To reference a secret at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference a secret at the account scope, prefix 'account` to the expression: account.{identifier}.
        :param pulumi.Input[Union['AwsKmsConnectorCredentialsArgs', 'AwsKmsConnectorCredentialsArgsDict']] credentials: Credentials to connect to AWS.
        :param pulumi.Input[_builtins.bool] default: Set this connector as the default for all the services.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.bool] execute_on_delegate: Execute the command on the delegate.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.str] region: The AWS region where the AWS Secret Manager is.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsKmsConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating an AWS KMS connector.

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level awskms connector

        ```sh
        $ pulumi import harness:platform/awsKmsConnector:AwsKmsConnector example <connector_id>
        ```

        Import org level awskms connector

        ```sh
        $ pulumi import harness:platform/awsKmsConnector:AwsKmsConnector example <ord_id>/<connector_id>
        ```

        Import project level awskms connector

        ```sh
        $ pulumi import harness:platform/awsKmsConnector:AwsKmsConnector example <org_id>/<project_id>/<connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param AwsKmsConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsKmsConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arn_plaintext: Optional[pulumi.Input[_builtins.str]] = None,
                 arn_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[Union['AwsKmsConnectorCredentialsArgs', 'AwsKmsConnectorCredentialsArgsDict']]] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsKmsConnectorArgs.__new__(AwsKmsConnectorArgs)

            __props__.__dict__["arn_plaintext"] = arn_plaintext
            __props__.__dict__["arn_ref"] = arn_ref
            if credentials is None and not opts.urn:
                raise TypeError("Missing required property 'credentials'")
            __props__.__dict__["credentials"] = credentials
            __props__.__dict__["default"] = default
            __props__.__dict__["delegate_selectors"] = delegate_selectors
            __props__.__dict__["description"] = description
            __props__.__dict__["execute_on_delegate"] = execute_on_delegate
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["name"] = name
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
        super(AwsKmsConnector, __self__).__init__(
            'harness:platform/awsKmsConnector:AwsKmsConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn_plaintext: Optional[pulumi.Input[_builtins.str]] = None,
            arn_ref: Optional[pulumi.Input[_builtins.str]] = None,
            credentials: Optional[pulumi.Input[Union['AwsKmsConnectorCredentialsArgs', 'AwsKmsConnectorCredentialsArgsDict']]] = None,
            default: Optional[pulumi.Input[_builtins.bool]] = None,
            delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'AwsKmsConnector':
        """
        Get an existing AwsKmsConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn_plaintext: A reference to the Harness secret containing the ARN of the AWS KMS.
        :param pulumi.Input[_builtins.str] arn_ref: A reference to the Harness secret containing the ARN of the AWS KMS. To reference a secret at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference a secret at the account scope, prefix 'account` to the expression: account.{identifier}.
        :param pulumi.Input[Union['AwsKmsConnectorCredentialsArgs', 'AwsKmsConnectorCredentialsArgsDict']] credentials: Credentials to connect to AWS.
        :param pulumi.Input[_builtins.bool] default: Set this connector as the default for all the services.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.bool] execute_on_delegate: Execute the command on the delegate.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.str] region: The AWS region where the AWS Secret Manager is.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsKmsConnectorState.__new__(_AwsKmsConnectorState)

        __props__.__dict__["arn_plaintext"] = arn_plaintext
        __props__.__dict__["arn_ref"] = arn_ref
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["default"] = default
        __props__.__dict__["delegate_selectors"] = delegate_selectors
        __props__.__dict__["description"] = description
        __props__.__dict__["execute_on_delegate"] = execute_on_delegate
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        return AwsKmsConnector(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="arnPlaintext")
    def arn_plaintext(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A reference to the Harness secret containing the ARN of the AWS KMS.
        """
        return pulumi.get(self, "arn_plaintext")

    @_builtins.property
    @pulumi.getter(name="arnRef")
    def arn_ref(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A reference to the Harness secret containing the ARN of the AWS KMS. To reference a secret at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference a secret at the account scope, prefix 'account` to the expression: account.{identifier}.
        """
        return pulumi.get(self, "arn_ref")

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> pulumi.Output['outputs.AwsKmsConnectorCredentials']:
        """
        Credentials to connect to AWS.
        """
        return pulumi.get(self, "credentials")

    @_builtins.property
    @pulumi.getter
    def default(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set this connector as the default for all the services.
        """
        return pulumi.get(self, "default")

    @_builtins.property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags to filter delegates for connection.
        """
        return pulumi.get(self, "delegate_selectors")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="executeOnDelegate")
    def execute_on_delegate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Execute the command on the delegate.
        """
        return pulumi.get(self, "execute_on_delegate")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The AWS region where the AWS Secret Manager is.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

