# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DelegatetokenArgs', 'Delegatetoken']

@pulumi.input_type
class DelegatetokenArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 created_at: Optional[pulumi.Input[_builtins.int]] = None,
                 created_by: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 revoke_after: Optional[pulumi.Input[_builtins.int]] = None,
                 token_status: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Delegatetoken resource.
        :param pulumi.Input[_builtins.str] account_id: Account Identifier for the Entity
        :param pulumi.Input[_builtins.int] created_at: Time when the delegate token is created. This is an epoch timestamp.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] created_by: created by details
        :param pulumi.Input[_builtins.str] name: Name of the delegate token
        :param pulumi.Input[_builtins.str] org_id: Org Identifier for the Entity
        :param pulumi.Input[_builtins.str] project_id: Project Identifier for the Entity
        :param pulumi.Input[_builtins.int] revoke_after: Epoch time in milliseconds after which the token will be marked as revoked. There can be a delay of up to one hour from the epoch value provided and actual revoking of the token.
        :param pulumi.Input[_builtins.str] token_status: Status of Delegate Token (ACTIVE or REVOKED). If left empty both active and revoked tokens will be assumed
        :param pulumi.Input[_builtins.str] value: Value of the delegate token. Encoded in base64.
        """
        pulumi.set(__self__, "account_id", account_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if revoke_after is not None:
            pulumi.set(__self__, "revoke_after", revoke_after)
        if token_status is not None:
            pulumi.set(__self__, "token_status", token_status)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Account Identifier for the Entity
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time when the delegate token is created. This is an epoch timestamp.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        created by details
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the delegate token
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Org Identifier for the Entity
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project Identifier for the Entity
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="revokeAfter")
    def revoke_after(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Epoch time in milliseconds after which the token will be marked as revoked. There can be a delay of up to one hour from the epoch value provided and actual revoking of the token.
        """
        return pulumi.get(self, "revoke_after")

    @revoke_after.setter
    def revoke_after(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "revoke_after", value)

    @_builtins.property
    @pulumi.getter(name="tokenStatus")
    def token_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of Delegate Token (ACTIVE or REVOKED). If left empty both active and revoked tokens will be assumed
        """
        return pulumi.get(self, "token_status")

    @token_status.setter
    def token_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_status", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Value of the delegate token. Encoded in base64.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class _DelegatetokenState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.int]] = None,
                 created_by: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 revoke_after: Optional[pulumi.Input[_builtins.int]] = None,
                 token_status: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Delegatetoken resources.
        :param pulumi.Input[_builtins.str] account_id: Account Identifier for the Entity
        :param pulumi.Input[_builtins.int] created_at: Time when the delegate token is created. This is an epoch timestamp.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] created_by: created by details
        :param pulumi.Input[_builtins.str] name: Name of the delegate token
        :param pulumi.Input[_builtins.str] org_id: Org Identifier for the Entity
        :param pulumi.Input[_builtins.str] project_id: Project Identifier for the Entity
        :param pulumi.Input[_builtins.int] revoke_after: Epoch time in milliseconds after which the token will be marked as revoked. There can be a delay of up to one hour from the epoch value provided and actual revoking of the token.
        :param pulumi.Input[_builtins.str] token_status: Status of Delegate Token (ACTIVE or REVOKED). If left empty both active and revoked tokens will be assumed
        :param pulumi.Input[_builtins.str] value: Value of the delegate token. Encoded in base64.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if revoke_after is not None:
            pulumi.set(__self__, "revoke_after", revoke_after)
        if token_status is not None:
            pulumi.set(__self__, "token_status", token_status)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account Identifier for the Entity
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time when the delegate token is created. This is an epoch timestamp.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        created by details
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the delegate token
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Org Identifier for the Entity
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project Identifier for the Entity
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="revokeAfter")
    def revoke_after(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Epoch time in milliseconds after which the token will be marked as revoked. There can be a delay of up to one hour from the epoch value provided and actual revoking of the token.
        """
        return pulumi.get(self, "revoke_after")

    @revoke_after.setter
    def revoke_after(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "revoke_after", value)

    @_builtins.property
    @pulumi.getter(name="tokenStatus")
    def token_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of Delegate Token (ACTIVE or REVOKED). If left empty both active and revoked tokens will be assumed
        """
        return pulumi.get(self, "token_status")

    @token_status.setter
    def token_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_status", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Value of the delegate token. Encoded in base64.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


@pulumi.type_token("harness:platform/delegatetoken:Delegatetoken")
class Delegatetoken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.int]] = None,
                 created_by: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 revoke_after: Optional[pulumi.Input[_builtins.int]] = None,
                 token_status: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        # Create delegate token at account level
        account_level = harness.platform.Delegatetoken("account_level",
            name="account-delegate-token",
            account_id="account_id")
        # Create delegate token at organization level
        org_level = harness.platform.Delegatetoken("org_level",
            name="org-delegate-token",
            account_id="account_id",
            org_id="org_id")
        # Create delegate token at project level
        project_level = harness.platform.Delegatetoken("project_level",
            name="project-delegate-token",
            account_id="account_id",
            org_id="org_id",
            project_id="project_id")
        # Create delegate token with auto-expiry
        expiry_token = harness.platform.Delegatetoken("expiry_token",
            name="expiry-delegate-token",
            account_id="account_id",
            revoke_after=1769689600000)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account Identifier for the Entity
        :param pulumi.Input[_builtins.int] created_at: Time when the delegate token is created. This is an epoch timestamp.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] created_by: created by details
        :param pulumi.Input[_builtins.str] name: Name of the delegate token
        :param pulumi.Input[_builtins.str] org_id: Org Identifier for the Entity
        :param pulumi.Input[_builtins.str] project_id: Project Identifier for the Entity
        :param pulumi.Input[_builtins.int] revoke_after: Epoch time in milliseconds after which the token will be marked as revoked. There can be a delay of up to one hour from the epoch value provided and actual revoking of the token.
        :param pulumi.Input[_builtins.str] token_status: Status of Delegate Token (ACTIVE or REVOKED). If left empty both active and revoked tokens will be assumed
        :param pulumi.Input[_builtins.str] value: Value of the delegate token. Encoded in base64.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DelegatetokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        # Create delegate token at account level
        account_level = harness.platform.Delegatetoken("account_level",
            name="account-delegate-token",
            account_id="account_id")
        # Create delegate token at organization level
        org_level = harness.platform.Delegatetoken("org_level",
            name="org-delegate-token",
            account_id="account_id",
            org_id="org_id")
        # Create delegate token at project level
        project_level = harness.platform.Delegatetoken("project_level",
            name="project-delegate-token",
            account_id="account_id",
            org_id="org_id",
            project_id="project_id")
        # Create delegate token with auto-expiry
        expiry_token = harness.platform.Delegatetoken("expiry_token",
            name="expiry-delegate-token",
            account_id="account_id",
            revoke_after=1769689600000)
        ```

        :param str resource_name: The name of the resource.
        :param DelegatetokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DelegatetokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.int]] = None,
                 created_by: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 revoke_after: Optional[pulumi.Input[_builtins.int]] = None,
                 token_status: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DelegatetokenArgs.__new__(DelegatetokenArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["created_at"] = created_at
            __props__.__dict__["created_by"] = created_by
            __props__.__dict__["name"] = name
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["revoke_after"] = revoke_after
            __props__.__dict__["token_status"] = token_status
            __props__.__dict__["value"] = value
        super(Delegatetoken, __self__).__init__(
            'harness:platform/delegatetoken:Delegatetoken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.int]] = None,
            created_by: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            revoke_after: Optional[pulumi.Input[_builtins.int]] = None,
            token_status: Optional[pulumi.Input[_builtins.str]] = None,
            value: Optional[pulumi.Input[_builtins.str]] = None) -> 'Delegatetoken':
        """
        Get an existing Delegatetoken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account Identifier for the Entity
        :param pulumi.Input[_builtins.int] created_at: Time when the delegate token is created. This is an epoch timestamp.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] created_by: created by details
        :param pulumi.Input[_builtins.str] name: Name of the delegate token
        :param pulumi.Input[_builtins.str] org_id: Org Identifier for the Entity
        :param pulumi.Input[_builtins.str] project_id: Project Identifier for the Entity
        :param pulumi.Input[_builtins.int] revoke_after: Epoch time in milliseconds after which the token will be marked as revoked. There can be a delay of up to one hour from the epoch value provided and actual revoking of the token.
        :param pulumi.Input[_builtins.str] token_status: Status of Delegate Token (ACTIVE or REVOKED). If left empty both active and revoked tokens will be assumed
        :param pulumi.Input[_builtins.str] value: Value of the delegate token. Encoded in base64.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DelegatetokenState.__new__(_DelegatetokenState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["revoke_after"] = revoke_after
        __props__.__dict__["token_status"] = token_status
        __props__.__dict__["value"] = value
        return Delegatetoken(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Account Identifier for the Entity
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.int]:
        """
        Time when the delegate token is created. This is an epoch timestamp.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        created by details
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the delegate token
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Org Identifier for the Entity
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Project Identifier for the Entity
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="revokeAfter")
    def revoke_after(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Epoch time in milliseconds after which the token will be marked as revoked. There can be a delay of up to one hour from the epoch value provided and actual revoking of the token.
        """
        return pulumi.get(self, "revoke_after")

    @_builtins.property
    @pulumi.getter(name="tokenStatus")
    def token_status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of Delegate Token (ACTIVE or REVOKED). If left empty both active and revoked tokens will be assumed
        """
        return pulumi.get(self, "token_status")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[_builtins.str]:
        """
        Value of the delegate token. Encoded in base64.
        """
        return pulumi.get(self, "value")

