# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FeatureFlagTargetGroupArgs', 'FeatureFlagTargetGroup']

@pulumi.input_type
class FeatureFlagTargetGroupArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 environment: pulumi.Input[_builtins.str],
                 identifier: pulumi.Input[_builtins.str],
                 org_id: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagTargetGroupRuleArgs']]]] = None):
        """
        The set of arguments for constructing a FeatureFlagTargetGroup resource.
        :param pulumi.Input[_builtins.str] account_id: Account Identifier
        :param pulumi.Input[_builtins.str] environment: Environment Identifier
        :param pulumi.Input[_builtins.str] identifier: The unique identifier of the feature flag target group.
        :param pulumi.Input[_builtins.str] org_id: Organization Identifier
        :param pulumi.Input[_builtins.str] project_id: Project Identifier
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excludeds: A list of targets to exclude from the target group
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] includeds: A list of targets to include in the target group
        :param pulumi.Input[_builtins.str] name: The name of the feature flag target group.
        :param pulumi.Input[Sequence[pulumi.Input['FeatureFlagTargetGroupRuleArgs']]] rules: The list of rules used to include targets in the target group.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "project_id", project_id)
        if excludeds is not None:
            pulumi.set(__self__, "excludeds", excludeds)
        if includeds is not None:
            pulumi.set(__self__, "includeds", includeds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Account Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Input[_builtins.str]:
        """
        Environment Identifier
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[_builtins.str]:
        """
        The unique identifier of the feature flag target group.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[_builtins.str]:
        """
        Organization Identifier
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        Project Identifier
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def excludeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of targets to exclude from the target group
        """
        return pulumi.get(self, "excludeds")

    @excludeds.setter
    def excludeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excludeds", value)

    @_builtins.property
    @pulumi.getter
    def includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of targets to include in the target group
        """
        return pulumi.get(self, "includeds")

    @includeds.setter
    def includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "includeds", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the feature flag target group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagTargetGroupRuleArgs']]]]:
        """
        The list of rules used to include targets in the target group.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagTargetGroupRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _FeatureFlagTargetGroupState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagTargetGroupRuleArgs']]]] = None):
        """
        Input properties used for looking up and filtering FeatureFlagTargetGroup resources.
        :param pulumi.Input[_builtins.str] account_id: Account Identifier
        :param pulumi.Input[_builtins.str] environment: Environment Identifier
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excludeds: A list of targets to exclude from the target group
        :param pulumi.Input[_builtins.str] identifier: The unique identifier of the feature flag target group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] includeds: A list of targets to include in the target group
        :param pulumi.Input[_builtins.str] name: The name of the feature flag target group.
        :param pulumi.Input[_builtins.str] org_id: Organization Identifier
        :param pulumi.Input[_builtins.str] project_id: Project Identifier
        :param pulumi.Input[Sequence[pulumi.Input['FeatureFlagTargetGroupRuleArgs']]] rules: The list of rules used to include targets in the target group.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if excludeds is not None:
            pulumi.set(__self__, "excludeds", excludeds)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if includeds is not None:
            pulumi.set(__self__, "includeds", includeds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Environment Identifier
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def excludeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of targets to exclude from the target group
        """
        return pulumi.get(self, "excludeds")

    @excludeds.setter
    def excludeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excludeds", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the feature flag target group.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of targets to include in the target group
        """
        return pulumi.get(self, "includeds")

    @includeds.setter
    def includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "includeds", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the feature flag target group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Organization Identifier
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project Identifier
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagTargetGroupRuleArgs']]]]:
        """
        The list of rules used to include targets in the target group.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagTargetGroupRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.type_token("harness:platform/featureFlagTargetGroup:FeatureFlagTargetGroup")
class FeatureFlagTargetGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FeatureFlagTargetGroupRuleArgs', 'FeatureFlagTargetGroupRuleArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource for creating a Harness Feature Flag Target Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        target = harness.platform.FeatureFlagTargetGroup("target",
            org_id="test",
            project_id="test",
            identifier="MY_FEATURE",
            environment="MY_ENVIRONMENT",
            name="MY_FEATURE",
            account_id="MY_ACCOUNT_ID",
            includeds=["target_id_1"],
            excludeds=["target_id_2"],
            rules={
                "attribute": "MY_ATTRIBUTE",
                "operator": "equal",
                "value": "MY_VALUE",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account Identifier
        :param pulumi.Input[_builtins.str] environment: Environment Identifier
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excludeds: A list of targets to exclude from the target group
        :param pulumi.Input[_builtins.str] identifier: The unique identifier of the feature flag target group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] includeds: A list of targets to include in the target group
        :param pulumi.Input[_builtins.str] name: The name of the feature flag target group.
        :param pulumi.Input[_builtins.str] org_id: Organization Identifier
        :param pulumi.Input[_builtins.str] project_id: Project Identifier
        :param pulumi.Input[Sequence[pulumi.Input[Union['FeatureFlagTargetGroupRuleArgs', 'FeatureFlagTargetGroupRuleArgsDict']]]] rules: The list of rules used to include targets in the target group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FeatureFlagTargetGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating a Harness Feature Flag Target Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        target = harness.platform.FeatureFlagTargetGroup("target",
            org_id="test",
            project_id="test",
            identifier="MY_FEATURE",
            environment="MY_ENVIRONMENT",
            name="MY_FEATURE",
            account_id="MY_ACCOUNT_ID",
            includeds=["target_id_1"],
            excludeds=["target_id_2"],
            rules={
                "attribute": "MY_ATTRIBUTE",
                "operator": "equal",
                "value": "MY_VALUE",
            })
        ```

        :param str resource_name: The name of the resource.
        :param FeatureFlagTargetGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FeatureFlagTargetGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FeatureFlagTargetGroupRuleArgs', 'FeatureFlagTargetGroupRuleArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FeatureFlagTargetGroupArgs.__new__(FeatureFlagTargetGroupArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            __props__.__dict__["excludeds"] = excludeds
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["includeds"] = includeds
            __props__.__dict__["name"] = name
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["rules"] = rules
        super(FeatureFlagTargetGroup, __self__).__init__(
            'harness:platform/featureFlagTargetGroup:FeatureFlagTargetGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            environment: Optional[pulumi.Input[_builtins.str]] = None,
            excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FeatureFlagTargetGroupRuleArgs', 'FeatureFlagTargetGroupRuleArgsDict']]]]] = None) -> 'FeatureFlagTargetGroup':
        """
        Get an existing FeatureFlagTargetGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account Identifier
        :param pulumi.Input[_builtins.str] environment: Environment Identifier
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excludeds: A list of targets to exclude from the target group
        :param pulumi.Input[_builtins.str] identifier: The unique identifier of the feature flag target group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] includeds: A list of targets to include in the target group
        :param pulumi.Input[_builtins.str] name: The name of the feature flag target group.
        :param pulumi.Input[_builtins.str] org_id: Organization Identifier
        :param pulumi.Input[_builtins.str] project_id: Project Identifier
        :param pulumi.Input[Sequence[pulumi.Input[Union['FeatureFlagTargetGroupRuleArgs', 'FeatureFlagTargetGroupRuleArgsDict']]]] rules: The list of rules used to include targets in the target group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FeatureFlagTargetGroupState.__new__(_FeatureFlagTargetGroupState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["environment"] = environment
        __props__.__dict__["excludeds"] = excludeds
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["includeds"] = includeds
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["rules"] = rules
        return FeatureFlagTargetGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Account Identifier
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output[_builtins.str]:
        """
        Environment Identifier
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter
    def excludeds(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of targets to exclude from the target group
        """
        return pulumi.get(self, "excludeds")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the feature flag target group.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def includeds(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of targets to include in the target group
        """
        return pulumi.get(self, "includeds")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the feature flag target group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[_builtins.str]:
        """
        Organization Identifier
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Project Identifier
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.FeatureFlagTargetGroupRule']]:
        """
        The list of rules used to include targets in the target group.
        """
        return pulumi.get(self, "rules")

