# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDbSchemaResult',
    'AwaitableGetDbSchemaResult',
    'get_db_schema',
    'get_db_schema_output',
]

@pulumi.output_type
class GetDbSchemaResult:
    """
    A collection of values returned by getDbSchema.
    """
    def __init__(__self__, changelog_script=None, description=None, id=None, identifier=None, name=None, org_id=None, project_id=None, schema_sources=None, service=None, tags=None, type=None):
        if changelog_script and not isinstance(changelog_script, dict):
            raise TypeError("Expected argument 'changelog_script' to be a dict")
        pulumi.set(__self__, "changelog_script", changelog_script)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if schema_sources and not isinstance(schema_sources, list):
            raise TypeError("Expected argument 'schema_sources' to be a list")
        pulumi.set(__self__, "schema_sources", schema_sources)
        if service and not isinstance(service, str):
            raise TypeError("Expected argument 'service' to be a str")
        pulumi.set(__self__, "service", service)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="changelogScript")
    def changelog_script(self) -> 'outputs.GetDbSchemaChangelogScriptResult':
        """
        Configuration to clone changeSets using script
        """
        return pulumi.get(self, "changelog_script")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> _builtins.str:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> _builtins.str:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="schemaSources")
    def schema_sources(self) -> Sequence['outputs.GetDbSchemaSchemaSourceResult']:
        """
        Provides a connector and path at which to find the database schema representation
        """
        return pulumi.get(self, "schema_sources")

    @_builtins.property
    @pulumi.getter
    def service(self) -> _builtins.str:
        """
        The service associated with schema
        """
        return pulumi.get(self, "service")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of the database schema. Valid values are: Repository, Script
        """
        return pulumi.get(self, "type")


class AwaitableGetDbSchemaResult(GetDbSchemaResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbSchemaResult(
            changelog_script=self.changelog_script,
            description=self.description,
            id=self.id,
            identifier=self.identifier,
            name=self.name,
            org_id=self.org_id,
            project_id=self.project_id,
            schema_sources=self.schema_sources,
            service=self.service,
            tags=self.tags,
            type=self.type)


def get_db_schema(identifier: Optional[_builtins.str] = None,
                  name: Optional[_builtins.str] = None,
                  org_id: Optional[_builtins.str] = None,
                  project_id: Optional[_builtins.str] = None,
                  type: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbSchemaResult:
    """
    Data source for retrieving a Harness DBDevOps Schema.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_db_schema(identifier="identifier",
        org_id="org_id",
        project_id="project_id")
    ```


    :param _builtins.str identifier: Unique identifier of the resource.
    :param _builtins.str name: Name of the resource.
    :param _builtins.str org_id: Unique identifier of the organization.
    :param _builtins.str project_id: Unique identifier of the project.
    :param _builtins.str type: Type of the database schema. Valid values are: Repository, Script
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getDbSchema:getDbSchema', __args__, opts=opts, typ=GetDbSchemaResult).value

    return AwaitableGetDbSchemaResult(
        changelog_script=pulumi.get(__ret__, 'changelog_script'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        name=pulumi.get(__ret__, 'name'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        schema_sources=pulumi.get(__ret__, 'schema_sources'),
        service=pulumi.get(__ret__, 'service'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'))
def get_db_schema_output(identifier: Optional[pulumi.Input[_builtins.str]] = None,
                         name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         org_id: Optional[pulumi.Input[_builtins.str]] = None,
                         project_id: Optional[pulumi.Input[_builtins.str]] = None,
                         type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbSchemaResult]:
    """
    Data source for retrieving a Harness DBDevOps Schema.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_db_schema(identifier="identifier",
        org_id="org_id",
        project_id="project_id")
    ```


    :param _builtins.str identifier: Unique identifier of the resource.
    :param _builtins.str name: Name of the resource.
    :param _builtins.str org_id: Unique identifier of the organization.
    :param _builtins.str project_id: Unique identifier of the project.
    :param _builtins.str type: Type of the database schema. Valid values are: Repository, Script
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getDbSchema:getDbSchema', __args__, opts=opts, typ=GetDbSchemaResult)
    return __ret__.apply(lambda __response__: GetDbSchemaResult(
        changelog_script=pulumi.get(__response__, 'changelog_script'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        name=pulumi.get(__response__, 'name'),
        org_id=pulumi.get(__response__, 'org_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        schema_sources=pulumi.get(__response__, 'schema_sources'),
        service=pulumi.get(__response__, 'service'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type')))
