# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDelegatetokenResult',
    'AwaitableGetDelegatetokenResult',
    'get_delegatetoken',
    'get_delegatetoken_output',
]

@pulumi.output_type
class GetDelegatetokenResult:
    """
    A collection of values returned by getDelegatetoken.
    """
    def __init__(__self__, account_id=None, created_at=None, created_by=None, id=None, name=None, org_id=None, project_id=None, revoke_after=None, token_status=None, value=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if created_at and not isinstance(created_at, int):
            raise TypeError("Expected argument 'created_at' to be a int")
        pulumi.set(__self__, "created_at", created_at)
        if created_by and not isinstance(created_by, dict):
            raise TypeError("Expected argument 'created_by' to be a dict")
        pulumi.set(__self__, "created_by", created_by)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if revoke_after and not isinstance(revoke_after, int):
            raise TypeError("Expected argument 'revoke_after' to be a int")
        pulumi.set(__self__, "revoke_after", revoke_after)
        if token_status and not isinstance(token_status, str):
            raise TypeError("Expected argument 'token_status' to be a str")
        pulumi.set(__self__, "token_status", token_status)
        if value and not isinstance(value, str):
            raise TypeError("Expected argument 'value' to be a str")
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Account Identifier for the Entity
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.int:
        """
        Time when the delegate token is created. This is an epoch timestamp.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Mapping[str, _builtins.str]:
        """
        created by details
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the delegate token
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[_builtins.str]:
        """
        Org Identifier for the Entity
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        Project Identifier for the Entity
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="revokeAfter")
    def revoke_after(self) -> _builtins.int:
        """
        Epoch time in milliseconds after which the token will be marked as revoked. There can be a delay of up to one hour from the epoch value provided and actual revoking of the token.
        """
        return pulumi.get(self, "revoke_after")

    @_builtins.property
    @pulumi.getter(name="tokenStatus")
    def token_status(self) -> Optional[_builtins.str]:
        """
        Status of Delegate Token (ACTIVE or REVOKED). If left empty both active and revoked tokens will be assumed
        """
        return pulumi.get(self, "token_status")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the delegate token. Encoded in base64.
        """
        return pulumi.get(self, "value")


class AwaitableGetDelegatetokenResult(GetDelegatetokenResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDelegatetokenResult(
            account_id=self.account_id,
            created_at=self.created_at,
            created_by=self.created_by,
            id=self.id,
            name=self.name,
            org_id=self.org_id,
            project_id=self.project_id,
            revoke_after=self.revoke_after,
            token_status=self.token_status,
            value=self.value)


def get_delegatetoken(account_id: Optional[_builtins.str] = None,
                      name: Optional[_builtins.str] = None,
                      org_id: Optional[_builtins.str] = None,
                      project_id: Optional[_builtins.str] = None,
                      token_status: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDelegatetokenResult:
    """
    Data source for retrieving a Harness delegate Token.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    # Look up a delegate token at account level by name
    account_level = harness.platform.get_delegatetoken(name="account-delegate-token",
        account_id="account_id")
    # Look up a delegate token at organization level
    org_level = harness.platform.get_delegatetoken(name="org-delegate-token",
        account_id="account_id",
        org_id="org_id")
    # Look up a delegate token at project level
    project_level = harness.platform.get_delegatetoken(name="project-delegate-token",
        account_id="account_id",
        org_id="org_id",
        project_id="project_id")
    ```


    :param _builtins.str account_id: Account Identifier for the Entity
    :param _builtins.str name: Name of the delegate token
    :param _builtins.str org_id: Org Identifier for the Entity
    :param _builtins.str project_id: Project Identifier for the Entity
    :param _builtins.str token_status: Status of Delegate Token (ACTIVE or REVOKED). If left empty both active and revoked tokens will be assumed
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    __args__['tokenStatus'] = token_status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getDelegatetoken:getDelegatetoken', __args__, opts=opts, typ=GetDelegatetokenResult).value

    return AwaitableGetDelegatetokenResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        created_by=pulumi.get(__ret__, 'created_by'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        revoke_after=pulumi.get(__ret__, 'revoke_after'),
        token_status=pulumi.get(__ret__, 'token_status'),
        value=pulumi.get(__ret__, 'value'))
def get_delegatetoken_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                             name: Optional[pulumi.Input[_builtins.str]] = None,
                             org_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             token_status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDelegatetokenResult]:
    """
    Data source for retrieving a Harness delegate Token.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    # Look up a delegate token at account level by name
    account_level = harness.platform.get_delegatetoken(name="account-delegate-token",
        account_id="account_id")
    # Look up a delegate token at organization level
    org_level = harness.platform.get_delegatetoken(name="org-delegate-token",
        account_id="account_id",
        org_id="org_id")
    # Look up a delegate token at project level
    project_level = harness.platform.get_delegatetoken(name="project-delegate-token",
        account_id="account_id",
        org_id="org_id",
        project_id="project_id")
    ```


    :param _builtins.str account_id: Account Identifier for the Entity
    :param _builtins.str name: Name of the delegate token
    :param _builtins.str org_id: Org Identifier for the Entity
    :param _builtins.str project_id: Project Identifier for the Entity
    :param _builtins.str token_status: Status of Delegate Token (ACTIVE or REVOKED). If left empty both active and revoked tokens will be assumed
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    __args__['tokenStatus'] = token_status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getDelegatetoken:getDelegatetoken', __args__, opts=opts, typ=GetDelegatetokenResult)
    return __ret__.apply(lambda __response__: GetDelegatetokenResult(
        account_id=pulumi.get(__response__, 'account_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        created_by=pulumi.get(__response__, 'created_by'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        org_id=pulumi.get(__response__, 'org_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        revoke_after=pulumi.get(__response__, 'revoke_after'),
        token_status=pulumi.get(__response__, 'token_status'),
        value=pulumi.get(__response__, 'value')))
