# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetGcpConnectorResult',
    'AwaitableGetGcpConnectorResult',
    'get_gcp_connector',
    'get_gcp_connector_output',
]

@pulumi.output_type
class GetGcpConnectorResult:
    """
    A collection of values returned by getGcpConnector.
    """
    def __init__(__self__, description=None, id=None, identifier=None, inherit_from_delegates=None, manuals=None, name=None, oidc_authentications=None, org_id=None, project_id=None, tags=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if inherit_from_delegates and not isinstance(inherit_from_delegates, list):
            raise TypeError("Expected argument 'inherit_from_delegates' to be a list")
        pulumi.set(__self__, "inherit_from_delegates", inherit_from_delegates)
        if manuals and not isinstance(manuals, list):
            raise TypeError("Expected argument 'manuals' to be a list")
        pulumi.set(__self__, "manuals", manuals)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if oidc_authentications and not isinstance(oidc_authentications, list):
            raise TypeError("Expected argument 'oidc_authentications' to be a list")
        pulumi.set(__self__, "oidc_authentications", oidc_authentications)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> _builtins.str:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="inheritFromDelegates")
    def inherit_from_delegates(self) -> Sequence['outputs.GetGcpConnectorInheritFromDelegateResult']:
        """
        Inherit configuration from delegate.
        """
        return pulumi.get(self, "inherit_from_delegates")

    @_builtins.property
    @pulumi.getter
    def manuals(self) -> Sequence['outputs.GetGcpConnectorManualResult']:
        """
        Manual credential configuration.
        """
        return pulumi.get(self, "manuals")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="oidcAuthentications")
    def oidc_authentications(self) -> Sequence['outputs.GetGcpConnectorOidcAuthenticationResult']:
        """
        Authentication using harness oidc.
        """
        return pulumi.get(self, "oidc_authentications")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[_builtins.str]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetGcpConnectorResult(GetGcpConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGcpConnectorResult(
            description=self.description,
            id=self.id,
            identifier=self.identifier,
            inherit_from_delegates=self.inherit_from_delegates,
            manuals=self.manuals,
            name=self.name,
            oidc_authentications=self.oidc_authentications,
            org_id=self.org_id,
            project_id=self.project_id,
            tags=self.tags)


def get_gcp_connector(identifier: Optional[_builtins.str] = None,
                      name: Optional[_builtins.str] = None,
                      org_id: Optional[_builtins.str] = None,
                      project_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGcpConnectorResult:
    """
    Datasource for looking up a Gcp connector.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_gcp_connector(identifier="identifier")
    ```


    :param _builtins.str identifier: Unique identifier of the resource.
    :param _builtins.str name: Name of the resource.
    :param _builtins.str org_id: Unique identifier of the organization.
    :param _builtins.str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getGcpConnector:getGcpConnector', __args__, opts=opts, typ=GetGcpConnectorResult).value

    return AwaitableGetGcpConnectorResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        inherit_from_delegates=pulumi.get(__ret__, 'inherit_from_delegates'),
        manuals=pulumi.get(__ret__, 'manuals'),
        name=pulumi.get(__ret__, 'name'),
        oidc_authentications=pulumi.get(__ret__, 'oidc_authentications'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_gcp_connector_output(identifier: Optional[pulumi.Input[_builtins.str]] = None,
                             name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             org_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGcpConnectorResult]:
    """
    Datasource for looking up a Gcp connector.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_gcp_connector(identifier="identifier")
    ```


    :param _builtins.str identifier: Unique identifier of the resource.
    :param _builtins.str name: Name of the resource.
    :param _builtins.str org_id: Unique identifier of the organization.
    :param _builtins.str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getGcpConnector:getGcpConnector', __args__, opts=opts, typ=GetGcpConnectorResult)
    return __ret__.apply(lambda __response__: GetGcpConnectorResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        inherit_from_delegates=pulumi.get(__response__, 'inherit_from_delegates'),
        manuals=pulumi.get(__response__, 'manuals'),
        name=pulumi.get(__response__, 'name'),
        oidc_authentications=pulumi.get(__response__, 'oidc_authentications'),
        org_id=pulumi.get(__response__, 'org_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        tags=pulumi.get(__response__, 'tags')))
