# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetGitopsAgentResult',
    'AwaitableGetGitopsAgentResult',
    'get_gitops_agent',
    'get_gitops_agent_output',
]

@pulumi.output_type
class GetGitopsAgentResult:
    """
    A collection of values returned by getGitopsAgent.
    """
    def __init__(__self__, account_id=None, agent_token=None, description=None, id=None, identifier=None, is_authenticated=None, metadatas=None, name=None, operator=None, org_id=None, prefixed_identifier=None, project_id=None, tags=None, type=None, with_credentials=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if agent_token and not isinstance(agent_token, str):
            raise TypeError("Expected argument 'agent_token' to be a str")
        pulumi.set(__self__, "agent_token", agent_token)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if is_authenticated and not isinstance(is_authenticated, bool):
            raise TypeError("Expected argument 'is_authenticated' to be a bool")
        pulumi.set(__self__, "is_authenticated", is_authenticated)
        if metadatas and not isinstance(metadatas, list):
            raise TypeError("Expected argument 'metadatas' to be a list")
        pulumi.set(__self__, "metadatas", metadatas)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if operator and not isinstance(operator, str):
            raise TypeError("Expected argument 'operator' to be a str")
        pulumi.set(__self__, "operator", operator)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if prefixed_identifier and not isinstance(prefixed_identifier, str):
            raise TypeError("Expected argument 'prefixed_identifier' to be a str")
        pulumi.set(__self__, "prefixed_identifier", prefixed_identifier)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if with_credentials and not isinstance(with_credentials, bool):
            raise TypeError("Expected argument 'with_credentials' to be a bool")
        pulumi.set(__self__, "with_credentials", with_credentials)

    @_builtins.property
    @pulumi.getter(name="accountId")
    @_utilities.deprecated("""This field is deprecated and will be removed in a future release.""")
    def account_id(self) -> _builtins.str:
        """
        Account identifier of the GitOps agent.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="agentToken")
    def agent_token(self) -> _builtins.str:
        """
        Agent token to be used for authentication of the agent with Harness.
        """
        return pulumi.get(self, "agent_token")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the GitOps agent.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> _builtins.str:
        """
        Identifier of the GitOps agent.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="isAuthenticated")
    def is_authenticated(self) -> _builtins.bool:
        """
        This computed field specifies if the referenced agent ever successfully connected and was authenticated to harness. Note that this is different from whether the agent is currently connected. \\n\\nSet with_credentials to true to allow computing of this field.\\n\\n For retrieval of this information, the user associated to the token being used must have Gitops Agent Edit permissions
        """
        return pulumi.get(self, "is_authenticated")

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Sequence['outputs.GetGitopsAgentMetadataResult']:
        """
        Metadata of the agent.
        """
        return pulumi.get(self, "metadatas")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the GitOps agent.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        The Operator to use for the Harness GitOps agent. Enum: "ARGO" "FLAMINGO"
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[_builtins.str]:
        """
        Organization identifier of the GitOps agent.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="prefixedIdentifier")
    def prefixed_identifier(self) -> _builtins.str:
        """
        Prefixed identifier of the GitOps agent. Agent identifier prefixed with scope of the agent
        """
        return pulumi.get(self, "prefixed_identifier")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        Project identifier of the GitOps agent.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Tags for the GitOps agents. These can be used to search or filter the GitOps agents.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Default: "AGENT*TYPE*UNSET"
        Enum: "AGENT*TYPE*UNSET" "CONNECTED*ARGO*PROVIDER" "MANAGED*ARGO*PROVIDER"
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="withCredentials")
    def with_credentials(self) -> Optional[_builtins.bool]:
        """
        Specify whether to retrieve the gitops agent's token. (The field agent_token will be populated only if the agent has never connected to Harness before). For retrieval of this information, the user associated to the token being used must have Gitops Agent Edit permissions
        """
        return pulumi.get(self, "with_credentials")


class AwaitableGetGitopsAgentResult(GetGitopsAgentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGitopsAgentResult(
            account_id=self.account_id,
            agent_token=self.agent_token,
            description=self.description,
            id=self.id,
            identifier=self.identifier,
            is_authenticated=self.is_authenticated,
            metadatas=self.metadatas,
            name=self.name,
            operator=self.operator,
            org_id=self.org_id,
            prefixed_identifier=self.prefixed_identifier,
            project_id=self.project_id,
            tags=self.tags,
            type=self.type,
            with_credentials=self.with_credentials)


def get_gitops_agent(account_id: Optional[_builtins.str] = None,
                     identifier: Optional[_builtins.str] = None,
                     org_id: Optional[_builtins.str] = None,
                     project_id: Optional[_builtins.str] = None,
                     with_credentials: Optional[_builtins.bool] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGitopsAgentResult:
    """
    Datasource for fetching a Harness GitOps Agent.


    :param _builtins.str account_id: Account identifier of the GitOps agent.
    :param _builtins.str identifier: Identifier of the GitOps agent.
    :param _builtins.str org_id: Organization identifier of the GitOps agent.
    :param _builtins.str project_id: Project identifier of the GitOps agent.
    :param _builtins.bool with_credentials: Specify whether to retrieve the gitops agent's token. (The field agent_token will be populated only if the agent has never connected to Harness before). For retrieval of this information, the user associated to the token being used must have Gitops Agent Edit permissions
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['identifier'] = identifier
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    __args__['withCredentials'] = with_credentials
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getGitopsAgent:getGitopsAgent', __args__, opts=opts, typ=GetGitopsAgentResult).value

    return AwaitableGetGitopsAgentResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        agent_token=pulumi.get(__ret__, 'agent_token'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        is_authenticated=pulumi.get(__ret__, 'is_authenticated'),
        metadatas=pulumi.get(__ret__, 'metadatas'),
        name=pulumi.get(__ret__, 'name'),
        operator=pulumi.get(__ret__, 'operator'),
        org_id=pulumi.get(__ret__, 'org_id'),
        prefixed_identifier=pulumi.get(__ret__, 'prefixed_identifier'),
        project_id=pulumi.get(__ret__, 'project_id'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'),
        with_credentials=pulumi.get(__ret__, 'with_credentials'))
def get_gitops_agent_output(account_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            identifier: Optional[pulumi.Input[_builtins.str]] = None,
                            org_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            with_credentials: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGitopsAgentResult]:
    """
    Datasource for fetching a Harness GitOps Agent.


    :param _builtins.str account_id: Account identifier of the GitOps agent.
    :param _builtins.str identifier: Identifier of the GitOps agent.
    :param _builtins.str org_id: Organization identifier of the GitOps agent.
    :param _builtins.str project_id: Project identifier of the GitOps agent.
    :param _builtins.bool with_credentials: Specify whether to retrieve the gitops agent's token. (The field agent_token will be populated only if the agent has never connected to Harness before). For retrieval of this information, the user associated to the token being used must have Gitops Agent Edit permissions
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['identifier'] = identifier
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    __args__['withCredentials'] = with_credentials
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getGitopsAgent:getGitopsAgent', __args__, opts=opts, typ=GetGitopsAgentResult)
    return __ret__.apply(lambda __response__: GetGitopsAgentResult(
        account_id=pulumi.get(__response__, 'account_id'),
        agent_token=pulumi.get(__response__, 'agent_token'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        is_authenticated=pulumi.get(__response__, 'is_authenticated'),
        metadatas=pulumi.get(__response__, 'metadatas'),
        name=pulumi.get(__response__, 'name'),
        operator=pulumi.get(__response__, 'operator'),
        org_id=pulumi.get(__response__, 'org_id'),
        prefixed_identifier=pulumi.get(__response__, 'prefixed_identifier'),
        project_id=pulumi.get(__response__, 'project_id'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type'),
        with_credentials=pulumi.get(__response__, 'with_credentials')))
