# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetKubernetesConnectorResult',
    'AwaitableGetKubernetesConnectorResult',
    'get_kubernetes_connector',
    'get_kubernetes_connector_output',
]

@pulumi.output_type
class GetKubernetesConnectorResult:
    """
    A collection of values returned by getKubernetesConnector.
    """
    def __init__(__self__, client_key_certs=None, delegate_selectors=None, description=None, id=None, identifier=None, inherit_from_delegates=None, name=None, openid_connects=None, org_id=None, project_id=None, service_accounts=None, tags=None, username_passwords=None):
        if client_key_certs and not isinstance(client_key_certs, list):
            raise TypeError("Expected argument 'client_key_certs' to be a list")
        pulumi.set(__self__, "client_key_certs", client_key_certs)
        if delegate_selectors and not isinstance(delegate_selectors, list):
            raise TypeError("Expected argument 'delegate_selectors' to be a list")
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if inherit_from_delegates and not isinstance(inherit_from_delegates, list):
            raise TypeError("Expected argument 'inherit_from_delegates' to be a list")
        pulumi.set(__self__, "inherit_from_delegates", inherit_from_delegates)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if openid_connects and not isinstance(openid_connects, list):
            raise TypeError("Expected argument 'openid_connects' to be a list")
        pulumi.set(__self__, "openid_connects", openid_connects)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if service_accounts and not isinstance(service_accounts, list):
            raise TypeError("Expected argument 'service_accounts' to be a list")
        pulumi.set(__self__, "service_accounts", service_accounts)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if username_passwords and not isinstance(username_passwords, list):
            raise TypeError("Expected argument 'username_passwords' to be a list")
        pulumi.set(__self__, "username_passwords", username_passwords)

    @_builtins.property
    @pulumi.getter(name="clientKeyCerts")
    def client_key_certs(self) -> Sequence['outputs.GetKubernetesConnectorClientKeyCertResult']:
        """
        Client key and certificate config for the connector.
        """
        return pulumi.get(self, "client_key_certs")

    @_builtins.property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[_builtins.str]:
        """
        Selectors to use for the delegate.
        """
        return pulumi.get(self, "delegate_selectors")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> _builtins.str:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="inheritFromDelegates")
    def inherit_from_delegates(self) -> Sequence['outputs.GetKubernetesConnectorInheritFromDelegateResult']:
        """
        Credentials are inherited from the delegate.
        """
        return pulumi.get(self, "inherit_from_delegates")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="openidConnects")
    def openid_connects(self) -> Sequence['outputs.GetKubernetesConnectorOpenidConnectResult']:
        """
        OpenID configuration for the connector.
        """
        return pulumi.get(self, "openid_connects")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[_builtins.str]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="serviceAccounts")
    def service_accounts(self) -> Sequence['outputs.GetKubernetesConnectorServiceAccountResult']:
        """
        Service account for the connector.
        """
        return pulumi.get(self, "service_accounts")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="usernamePasswords")
    def username_passwords(self) -> Sequence['outputs.GetKubernetesConnectorUsernamePasswordResult']:
        """
        Username and password for the connector.
        """
        return pulumi.get(self, "username_passwords")


class AwaitableGetKubernetesConnectorResult(GetKubernetesConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKubernetesConnectorResult(
            client_key_certs=self.client_key_certs,
            delegate_selectors=self.delegate_selectors,
            description=self.description,
            id=self.id,
            identifier=self.identifier,
            inherit_from_delegates=self.inherit_from_delegates,
            name=self.name,
            openid_connects=self.openid_connects,
            org_id=self.org_id,
            project_id=self.project_id,
            service_accounts=self.service_accounts,
            tags=self.tags,
            username_passwords=self.username_passwords)


def get_kubernetes_connector(identifier: Optional[_builtins.str] = None,
                             name: Optional[_builtins.str] = None,
                             org_id: Optional[_builtins.str] = None,
                             project_id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKubernetesConnectorResult:
    """
    Datasource for looking up a Kubernetes connector.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_kubernetes_connector(identifier="identifier")
    ```


    :param _builtins.str identifier: Unique identifier of the resource.
    :param _builtins.str name: Name of the resource.
    :param _builtins.str org_id: Unique identifier of the organization.
    :param _builtins.str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getKubernetesConnector:getKubernetesConnector', __args__, opts=opts, typ=GetKubernetesConnectorResult).value

    return AwaitableGetKubernetesConnectorResult(
        client_key_certs=pulumi.get(__ret__, 'client_key_certs'),
        delegate_selectors=pulumi.get(__ret__, 'delegate_selectors'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        inherit_from_delegates=pulumi.get(__ret__, 'inherit_from_delegates'),
        name=pulumi.get(__ret__, 'name'),
        openid_connects=pulumi.get(__ret__, 'openid_connects'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        service_accounts=pulumi.get(__ret__, 'service_accounts'),
        tags=pulumi.get(__ret__, 'tags'),
        username_passwords=pulumi.get(__ret__, 'username_passwords'))
def get_kubernetes_connector_output(identifier: Optional[pulumi.Input[_builtins.str]] = None,
                                    name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    org_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKubernetesConnectorResult]:
    """
    Datasource for looking up a Kubernetes connector.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_kubernetes_connector(identifier="identifier")
    ```


    :param _builtins.str identifier: Unique identifier of the resource.
    :param _builtins.str name: Name of the resource.
    :param _builtins.str org_id: Unique identifier of the organization.
    :param _builtins.str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getKubernetesConnector:getKubernetesConnector', __args__, opts=opts, typ=GetKubernetesConnectorResult)
    return __ret__.apply(lambda __response__: GetKubernetesConnectorResult(
        client_key_certs=pulumi.get(__response__, 'client_key_certs'),
        delegate_selectors=pulumi.get(__response__, 'delegate_selectors'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        inherit_from_delegates=pulumi.get(__response__, 'inherit_from_delegates'),
        name=pulumi.get(__response__, 'name'),
        openid_connects=pulumi.get(__response__, 'openid_connects'),
        org_id=pulumi.get(__response__, 'org_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        service_accounts=pulumi.get(__response__, 'service_accounts'),
        tags=pulumi.get(__response__, 'tags'),
        username_passwords=pulumi.get(__response__, 'username_passwords')))
