# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOverridesResult',
    'AwaitableGetOverridesResult',
    'get_overrides',
    'get_overrides_output',
]

@pulumi.output_type
class GetOverridesResult:
    """
    A collection of values returned by getOverrides.
    """
    def __init__(__self__, cluster_id=None, env_id=None, git_details=None, id=None, identifier=None, infra_id=None, org_id=None, project_id=None, service_id=None, type=None, yaml=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if env_id and not isinstance(env_id, str):
            raise TypeError("Expected argument 'env_id' to be a str")
        pulumi.set(__self__, "env_id", env_id)
        if git_details and not isinstance(git_details, dict):
            raise TypeError("Expected argument 'git_details' to be a dict")
        pulumi.set(__self__, "git_details", git_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if infra_id and not isinstance(infra_id, str):
            raise TypeError("Expected argument 'infra_id' to be a str")
        pulumi.set(__self__, "infra_id", infra_id)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if service_id and not isinstance(service_id, str):
            raise TypeError("Expected argument 'service_id' to be a str")
        pulumi.set(__self__, "service_id", service_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if yaml and not isinstance(yaml, str):
            raise TypeError("Expected argument 'yaml' to be a str")
        pulumi.set(__self__, "yaml", yaml)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The cluster ID to which the override entity is associated.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="envId")
    def env_id(self) -> _builtins.str:
        """
        The environment ID to which the override entity is associated.
        """
        return pulumi.get(self, "env_id")

    @_builtins.property
    @pulumi.getter(name="gitDetails")
    def git_details(self) -> 'outputs.GetOverridesGitDetailsResult':
        """
        Contains parameters related to Git Experience for remote overrides
        """
        return pulumi.get(self, "git_details")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> _builtins.str:
        """
        The identifier of the override entity.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="infraId")
    def infra_id(self) -> _builtins.str:
        """
        The infrastructure ID to which the override entity is associated.
        """
        return pulumi.get(self, "infra_id")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[_builtins.str]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> _builtins.str:
        """
        The service ID to which the override entity is associated.
        """
        return pulumi.get(self, "service_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the override entity.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def yaml(self) -> _builtins.str:
        """
        The yaml of the override entity.
        """
        return pulumi.get(self, "yaml")


class AwaitableGetOverridesResult(GetOverridesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOverridesResult(
            cluster_id=self.cluster_id,
            env_id=self.env_id,
            git_details=self.git_details,
            id=self.id,
            identifier=self.identifier,
            infra_id=self.infra_id,
            org_id=self.org_id,
            project_id=self.project_id,
            service_id=self.service_id,
            type=self.type,
            yaml=self.yaml)


def get_overrides(git_details: Optional[Union['GetOverridesGitDetailsArgs', 'GetOverridesGitDetailsArgsDict']] = None,
                  identifier: Optional[_builtins.str] = None,
                  org_id: Optional[_builtins.str] = None,
                  project_id: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOverridesResult:
    """
    Data source for Harness Overrides V2.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    test = harness.platform.get_overrides(identifier="identifier",
        org_id="orgIdentifier",
        project_id="projectIdentifier")
    ```


    :param Union['GetOverridesGitDetailsArgs', 'GetOverridesGitDetailsArgsDict'] git_details: Contains parameters related to Git Experience for remote overrides
    :param _builtins.str identifier: The identifier of the override entity.
    :param _builtins.str org_id: Unique identifier of the organization.
    :param _builtins.str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['gitDetails'] = git_details
    __args__['identifier'] = identifier
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getOverrides:getOverrides', __args__, opts=opts, typ=GetOverridesResult).value

    return AwaitableGetOverridesResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        env_id=pulumi.get(__ret__, 'env_id'),
        git_details=pulumi.get(__ret__, 'git_details'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        infra_id=pulumi.get(__ret__, 'infra_id'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        service_id=pulumi.get(__ret__, 'service_id'),
        type=pulumi.get(__ret__, 'type'),
        yaml=pulumi.get(__ret__, 'yaml'))
def get_overrides_output(git_details: Optional[pulumi.Input[Optional[Union['GetOverridesGitDetailsArgs', 'GetOverridesGitDetailsArgsDict']]]] = None,
                         identifier: Optional[pulumi.Input[_builtins.str]] = None,
                         org_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOverridesResult]:
    """
    Data source for Harness Overrides V2.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    test = harness.platform.get_overrides(identifier="identifier",
        org_id="orgIdentifier",
        project_id="projectIdentifier")
    ```


    :param Union['GetOverridesGitDetailsArgs', 'GetOverridesGitDetailsArgsDict'] git_details: Contains parameters related to Git Experience for remote overrides
    :param _builtins.str identifier: The identifier of the override entity.
    :param _builtins.str org_id: Unique identifier of the organization.
    :param _builtins.str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['gitDetails'] = git_details
    __args__['identifier'] = identifier
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getOverrides:getOverrides', __args__, opts=opts, typ=GetOverridesResult)
    return __ret__.apply(lambda __response__: GetOverridesResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        env_id=pulumi.get(__response__, 'env_id'),
        git_details=pulumi.get(__response__, 'git_details'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        infra_id=pulumi.get(__response__, 'infra_id'),
        org_id=pulumi.get(__response__, 'org_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        service_id=pulumi.get(__response__, 'service_id'),
        type=pulumi.get(__response__, 'type'),
        yaml=pulumi.get(__response__, 'yaml')))
