# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRepoWebhookResult',
    'AwaitableGetRepoWebhookResult',
    'get_repo_webhook',
    'get_repo_webhook_output',
]

@pulumi.output_type
class GetRepoWebhookResult:
    """
    A collection of values returned by getRepoWebhook.
    """
    def __init__(__self__, created=None, created_by=None, description=None, enabled=None, has_secret=None, id=None, identifier=None, insecure=None, org_id=None, project_id=None, repo_identifier=None, secret=None, triggers=None, url=None):
        if created and not isinstance(created, int):
            raise TypeError("Expected argument 'created' to be a int")
        pulumi.set(__self__, "created", created)
        if created_by and not isinstance(created_by, int):
            raise TypeError("Expected argument 'created_by' to be a int")
        pulumi.set(__self__, "created_by", created_by)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if has_secret and not isinstance(has_secret, bool):
            raise TypeError("Expected argument 'has_secret' to be a bool")
        pulumi.set(__self__, "has_secret", has_secret)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if insecure and not isinstance(insecure, bool):
            raise TypeError("Expected argument 'insecure' to be a bool")
        pulumi.set(__self__, "insecure", insecure)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if repo_identifier and not isinstance(repo_identifier, str):
            raise TypeError("Expected argument 'repo_identifier' to be a str")
        pulumi.set(__self__, "repo_identifier", repo_identifier)
        if secret and not isinstance(secret, str):
            raise TypeError("Expected argument 'secret' to be a str")
        pulumi.set(__self__, "secret", secret)
        if triggers and not isinstance(triggers, list):
            raise TypeError("Expected argument 'triggers' to be a list")
        pulumi.set(__self__, "triggers", triggers)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.int:
        """
        Timestamp when the webhook was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.int:
        """
        ID of the user who created the webhook.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description of the webhook.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Webhook enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="hasSecret")
    def has_secret(self) -> _builtins.bool:
        """
        Created webhook has secret encoding.
        """
        return pulumi.get(self, "has_secret")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> _builtins.str:
        """
        Identifier of the webhook.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def insecure(self) -> _builtins.bool:
        """
        Allow insecure connections for provided webhook URL.
        """
        return pulumi.get(self, "insecure")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[_builtins.str]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="repoIdentifier")
    def repo_identifier(self) -> _builtins.str:
        """
        Identifier of the repository.
        """
        return pulumi.get(self, "repo_identifier")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> Optional[_builtins.str]:
        """
        Webhook secret which will be used to sign the webhook payload.
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of triggers of the webhook (keep empty for all triggers).
        """
        return pulumi.get(self, "triggers")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        URL that's called by the webhook.
        """
        return pulumi.get(self, "url")


class AwaitableGetRepoWebhookResult(GetRepoWebhookResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepoWebhookResult(
            created=self.created,
            created_by=self.created_by,
            description=self.description,
            enabled=self.enabled,
            has_secret=self.has_secret,
            id=self.id,
            identifier=self.identifier,
            insecure=self.insecure,
            org_id=self.org_id,
            project_id=self.project_id,
            repo_identifier=self.repo_identifier,
            secret=self.secret,
            triggers=self.triggers,
            url=self.url)


def get_repo_webhook(description: Optional[_builtins.str] = None,
                     enabled: Optional[_builtins.bool] = None,
                     identifier: Optional[_builtins.str] = None,
                     insecure: Optional[_builtins.bool] = None,
                     org_id: Optional[_builtins.str] = None,
                     project_id: Optional[_builtins.str] = None,
                     repo_identifier: Optional[_builtins.str] = None,
                     secret: Optional[_builtins.str] = None,
                     triggers: Optional[Sequence[_builtins.str]] = None,
                     url: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepoWebhookResult:
    """
    Data source for retrieving a Harness Repo Webhook.


    :param _builtins.str description: Description of the webhook.
    :param _builtins.bool enabled: Webhook enabled.
    :param _builtins.str identifier: Identifier of the webhook.
    :param _builtins.bool insecure: Allow insecure connections for provided webhook URL.
    :param _builtins.str org_id: Unique identifier of the organization.
    :param _builtins.str project_id: Unique identifier of the project.
    :param _builtins.str repo_identifier: Identifier of the repository.
    :param _builtins.str secret: Webhook secret which will be used to sign the webhook payload.
    :param Sequence[_builtins.str] triggers: List of triggers of the webhook (keep empty for all triggers).
    :param _builtins.str url: URL that's called by the webhook.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['enabled'] = enabled
    __args__['identifier'] = identifier
    __args__['insecure'] = insecure
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    __args__['repoIdentifier'] = repo_identifier
    __args__['secret'] = secret
    __args__['triggers'] = triggers
    __args__['url'] = url
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getRepoWebhook:getRepoWebhook', __args__, opts=opts, typ=GetRepoWebhookResult).value

    return AwaitableGetRepoWebhookResult(
        created=pulumi.get(__ret__, 'created'),
        created_by=pulumi.get(__ret__, 'created_by'),
        description=pulumi.get(__ret__, 'description'),
        enabled=pulumi.get(__ret__, 'enabled'),
        has_secret=pulumi.get(__ret__, 'has_secret'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        insecure=pulumi.get(__ret__, 'insecure'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        repo_identifier=pulumi.get(__ret__, 'repo_identifier'),
        secret=pulumi.get(__ret__, 'secret'),
        triggers=pulumi.get(__ret__, 'triggers'),
        url=pulumi.get(__ret__, 'url'))
def get_repo_webhook_output(description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                            identifier: Optional[pulumi.Input[_builtins.str]] = None,
                            insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                            org_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            repo_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                            secret: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            triggers: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                            url: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRepoWebhookResult]:
    """
    Data source for retrieving a Harness Repo Webhook.


    :param _builtins.str description: Description of the webhook.
    :param _builtins.bool enabled: Webhook enabled.
    :param _builtins.str identifier: Identifier of the webhook.
    :param _builtins.bool insecure: Allow insecure connections for provided webhook URL.
    :param _builtins.str org_id: Unique identifier of the organization.
    :param _builtins.str project_id: Unique identifier of the project.
    :param _builtins.str repo_identifier: Identifier of the repository.
    :param _builtins.str secret: Webhook secret which will be used to sign the webhook payload.
    :param Sequence[_builtins.str] triggers: List of triggers of the webhook (keep empty for all triggers).
    :param _builtins.str url: URL that's called by the webhook.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['enabled'] = enabled
    __args__['identifier'] = identifier
    __args__['insecure'] = insecure
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    __args__['repoIdentifier'] = repo_identifier
    __args__['secret'] = secret
    __args__['triggers'] = triggers
    __args__['url'] = url
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getRepoWebhook:getRepoWebhook', __args__, opts=opts, typ=GetRepoWebhookResult)
    return __ret__.apply(lambda __response__: GetRepoWebhookResult(
        created=pulumi.get(__response__, 'created'),
        created_by=pulumi.get(__response__, 'created_by'),
        description=pulumi.get(__response__, 'description'),
        enabled=pulumi.get(__response__, 'enabled'),
        has_secret=pulumi.get(__response__, 'has_secret'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        insecure=pulumi.get(__response__, 'insecure'),
        org_id=pulumi.get(__response__, 'org_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        repo_identifier=pulumi.get(__response__, 'repo_identifier'),
        secret=pulumi.get(__response__, 'secret'),
        triggers=pulumi.get(__response__, 'triggers'),
        url=pulumi.get(__response__, 'url')))
