# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTemplateFiltersResult',
    'AwaitableGetTemplateFiltersResult',
    'get_template_filters',
    'get_template_filters_output',
]

@pulumi.output_type
class GetTemplateFiltersResult:
    """
    A collection of values returned by getTemplateFilters.
    """
    def __init__(__self__, filter_properties=None, filter_visibility=None, id=None, identifier=None, name=None, org_id=None, project_id=None, type=None):
        if filter_properties and not isinstance(filter_properties, list):
            raise TypeError("Expected argument 'filter_properties' to be a list")
        pulumi.set(__self__, "filter_properties", filter_properties)
        if filter_visibility and not isinstance(filter_visibility, str):
            raise TypeError("Expected argument 'filter_visibility' to be a str")
        pulumi.set(__self__, "filter_visibility", filter_visibility)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="filterProperties")
    def filter_properties(self) -> Sequence['outputs.GetTemplateFiltersFilterPropertyResult']:
        """
        Properties of the filter entity defined in Harness.
        """
        return pulumi.get(self, "filter_properties")

    @_builtins.property
    @pulumi.getter(name="filterVisibility")
    def filter_visibility(self) -> _builtins.str:
        """
        This indicates visibility of filter. By default, everyone can view this filter.
        """
        return pulumi.get(self, "filter_visibility")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> _builtins.str:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the Filter.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[_builtins.str]:
        """
        Organization Identifier for the Entity.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        Project Identifier for the Entity.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of filter. Currently supported types are {TemplateSetup, TemplateExecution, Deployment, Template, EnvironmentGroup, Environment}.
        """
        return pulumi.get(self, "type")


class AwaitableGetTemplateFiltersResult(GetTemplateFiltersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTemplateFiltersResult(
            filter_properties=self.filter_properties,
            filter_visibility=self.filter_visibility,
            id=self.id,
            identifier=self.identifier,
            name=self.name,
            org_id=self.org_id,
            project_id=self.project_id,
            type=self.type)


def get_template_filters(identifier: Optional[_builtins.str] = None,
                         org_id: Optional[_builtins.str] = None,
                         project_id: Optional[_builtins.str] = None,
                         type: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTemplateFiltersResult:
    """
    Data source for retrieving a Harness Template Filter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    test = harness.platform.get_template_filters(identifier="identifier",
        org_id="org_id",
        project_id="project_id",
        type="Template")
    ```


    :param _builtins.str identifier: Unique identifier of the resource.
    :param _builtins.str org_id: Organization Identifier for the Entity.
    :param _builtins.str project_id: Project Identifier for the Entity.
    :param _builtins.str type: Type of filter. Currently supported types are {TemplateSetup, TemplateExecution, Deployment, Template, EnvironmentGroup, Environment}.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getTemplateFilters:getTemplateFilters', __args__, opts=opts, typ=GetTemplateFiltersResult).value

    return AwaitableGetTemplateFiltersResult(
        filter_properties=pulumi.get(__ret__, 'filter_properties'),
        filter_visibility=pulumi.get(__ret__, 'filter_visibility'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        name=pulumi.get(__ret__, 'name'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        type=pulumi.get(__ret__, 'type'))
def get_template_filters_output(identifier: Optional[pulumi.Input[_builtins.str]] = None,
                                org_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                type: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTemplateFiltersResult]:
    """
    Data source for retrieving a Harness Template Filter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    test = harness.platform.get_template_filters(identifier="identifier",
        org_id="org_id",
        project_id="project_id",
        type="Template")
    ```


    :param _builtins.str identifier: Unique identifier of the resource.
    :param _builtins.str org_id: Organization Identifier for the Entity.
    :param _builtins.str project_id: Project Identifier for the Entity.
    :param _builtins.str type: Type of filter. Currently supported types are {TemplateSetup, TemplateExecution, Deployment, Template, EnvironmentGroup, Environment}.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getTemplateFilters:getTemplateFilters', __args__, opts=opts, typ=GetTemplateFiltersResult)
    return __ret__.apply(lambda __response__: GetTemplateFiltersResult(
        filter_properties=pulumi.get(__response__, 'filter_properties'),
        filter_visibility=pulumi.get(__response__, 'filter_visibility'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        name=pulumi.get(__response__, 'name'),
        org_id=pulumi.get(__response__, 'org_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        type=pulumi.get(__response__, 'type')))
