# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetTriggersResult',
    'AwaitableGetTriggersResult',
    'get_triggers',
    'get_triggers_output',
]

@pulumi.output_type
class GetTriggersResult:
    """
    A collection of values returned by getTriggers.
    """
    def __init__(__self__, description=None, id=None, identifier=None, ignore_error=None, name=None, org_id=None, project_id=None, tags=None, target_id=None, yaml=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if ignore_error and not isinstance(ignore_error, bool):
            raise TypeError("Expected argument 'ignore_error' to be a bool")
        pulumi.set(__self__, "ignore_error", ignore_error)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if yaml and not isinstance(yaml, str):
            raise TypeError("Expected argument 'yaml' to be a str")
        pulumi.set(__self__, "yaml", yaml)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="ignoreError")
    def ignore_error(self) -> Optional[_builtins.bool]:
        """
        ignore error default false
        """
        return pulumi.get(self, "ignore_error")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> _builtins.str:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> _builtins.str:
        """
        Identifier of the target pipeline
        """
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter
    def yaml(self) -> _builtins.str:
        """
        trigger yaml
        """
        return pulumi.get(self, "yaml")


class AwaitableGetTriggersResult(GetTriggersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTriggersResult(
            description=self.description,
            id=self.id,
            identifier=self.identifier,
            ignore_error=self.ignore_error,
            name=self.name,
            org_id=self.org_id,
            project_id=self.project_id,
            tags=self.tags,
            target_id=self.target_id,
            yaml=self.yaml)


def get_triggers(identifier: Optional[_builtins.str] = None,
                 ignore_error: Optional[_builtins.bool] = None,
                 name: Optional[_builtins.str] = None,
                 org_id: Optional[_builtins.str] = None,
                 project_id: Optional[_builtins.str] = None,
                 target_id: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTriggersResult:
    """
    Data source for retrieving a Harness trigger.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_triggers(identifier="identifier",
        org_id="org_id",
        project_id="project_id",
        target_id="pipeline_id")
    ```


    :param _builtins.str identifier: Unique identifier of the resource.
    :param _builtins.bool ignore_error: ignore error default false
    :param _builtins.str name: Name of the resource.
    :param _builtins.str org_id: Unique identifier of the organization.
    :param _builtins.str project_id: Unique identifier of the project.
    :param _builtins.str target_id: Identifier of the target pipeline
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['ignoreError'] = ignore_error
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    __args__['targetId'] = target_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getTriggers:getTriggers', __args__, opts=opts, typ=GetTriggersResult).value

    return AwaitableGetTriggersResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        ignore_error=pulumi.get(__ret__, 'ignore_error'),
        name=pulumi.get(__ret__, 'name'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        tags=pulumi.get(__ret__, 'tags'),
        target_id=pulumi.get(__ret__, 'target_id'),
        yaml=pulumi.get(__ret__, 'yaml'))
def get_triggers_output(identifier: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        ignore_error: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                        name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        org_id: Optional[pulumi.Input[_builtins.str]] = None,
                        project_id: Optional[pulumi.Input[_builtins.str]] = None,
                        target_id: Optional[pulumi.Input[_builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTriggersResult]:
    """
    Data source for retrieving a Harness trigger.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_triggers(identifier="identifier",
        org_id="org_id",
        project_id="project_id",
        target_id="pipeline_id")
    ```


    :param _builtins.str identifier: Unique identifier of the resource.
    :param _builtins.bool ignore_error: ignore error default false
    :param _builtins.str name: Name of the resource.
    :param _builtins.str org_id: Unique identifier of the organization.
    :param _builtins.str project_id: Unique identifier of the project.
    :param _builtins.str target_id: Identifier of the target pipeline
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['ignoreError'] = ignore_error
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    __args__['targetId'] = target_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getTriggers:getTriggers', __args__, opts=opts, typ=GetTriggersResult)
    return __ret__.apply(lambda __response__: GetTriggersResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        ignore_error=pulumi.get(__response__, 'ignore_error'),
        name=pulumi.get(__response__, 'name'),
        org_id=pulumi.get(__response__, 'org_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        tags=pulumi.get(__response__, 'tags'),
        target_id=pulumi.get(__response__, 'target_id'),
        yaml=pulumi.get(__response__, 'yaml')))
