# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GitopsAppProjectArgs', 'GitopsAppProject']

@pulumi.input_type
class GitopsAppProjectArgs:
    def __init__(__self__, *,
                 agent_id: pulumi.Input[_builtins.str],
                 projects: pulumi.Input[Sequence[pulumi.Input['GitopsAppProjectProjectArgs']]],
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 query_name: Optional[pulumi.Input[_builtins.str]] = None,
                 upsert: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a GitopsAppProject resource.
        :param pulumi.Input[_builtins.str] agent_id: Agent identifier of the agent where argo project will exist (include scope prefix)
        :param pulumi.Input[Sequence[pulumi.Input['GitopsAppProjectProjectArgs']]] projects: GitOps project configuration.
        :param pulumi.Input[_builtins.str] account_id: Account identifier of the GitOps Agent where argo project will exist.
        :param pulumi.Input[_builtins.str] org_id: Org identifier of the GitOps Agent where argo project is to be created.
        :param pulumi.Input[_builtins.str] project_id: Project identifier of the Gitops Agent where argo project is to be created.
        :param pulumi.Input[_builtins.str] query_name: Identifier for the GitOps Argo project.
        :param pulumi.Input[_builtins.bool] upsert: Indicates if the argo project should be updated if existing and inserted if not.
        """
        pulumi.set(__self__, "agent_id", agent_id)
        pulumi.set(__self__, "projects", projects)
        if account_id is not None:
            warnings.warn("""This field is deprecated and will be removed in a future release.""", DeprecationWarning)
            pulumi.log.warn("""account_id is deprecated: This field is deprecated and will be removed in a future release.""")
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if query_name is not None:
            pulumi.set(__self__, "query_name", query_name)
        if upsert is not None:
            pulumi.set(__self__, "upsert", upsert)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Input[_builtins.str]:
        """
        Agent identifier of the agent where argo project will exist (include scope prefix)
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "agent_id", value)

    @_builtins.property
    @pulumi.getter
    def projects(self) -> pulumi.Input[Sequence[pulumi.Input['GitopsAppProjectProjectArgs']]]:
        """
        GitOps project configuration.
        """
        return pulumi.get(self, "projects")

    @projects.setter
    def projects(self, value: pulumi.Input[Sequence[pulumi.Input['GitopsAppProjectProjectArgs']]]):
        pulumi.set(self, "projects", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    @_utilities.deprecated("""This field is deprecated and will be removed in a future release.""")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account identifier of the GitOps Agent where argo project will exist.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Org identifier of the GitOps Agent where argo project is to be created.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project identifier of the Gitops Agent where argo project is to be created.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="queryName")
    def query_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier for the GitOps Argo project.
        """
        return pulumi.get(self, "query_name")

    @query_name.setter
    def query_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_name", value)

    @_builtins.property
    @pulumi.getter
    def upsert(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the argo project should be updated if existing and inserted if not.
        """
        return pulumi.get(self, "upsert")

    @upsert.setter
    def upsert(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "upsert", value)


@pulumi.input_type
class _GitopsAppProjectState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 projects: Optional[pulumi.Input[Sequence[pulumi.Input['GitopsAppProjectProjectArgs']]]] = None,
                 query_name: Optional[pulumi.Input[_builtins.str]] = None,
                 upsert: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering GitopsAppProject resources.
        :param pulumi.Input[_builtins.str] account_id: Account identifier of the GitOps Agent where argo project will exist.
        :param pulumi.Input[_builtins.str] agent_id: Agent identifier of the agent where argo project will exist (include scope prefix)
        :param pulumi.Input[_builtins.str] org_id: Org identifier of the GitOps Agent where argo project is to be created.
        :param pulumi.Input[_builtins.str] project_id: Project identifier of the Gitops Agent where argo project is to be created.
        :param pulumi.Input[Sequence[pulumi.Input['GitopsAppProjectProjectArgs']]] projects: GitOps project configuration.
        :param pulumi.Input[_builtins.str] query_name: Identifier for the GitOps Argo project.
        :param pulumi.Input[_builtins.bool] upsert: Indicates if the argo project should be updated if existing and inserted if not.
        """
        if account_id is not None:
            warnings.warn("""This field is deprecated and will be removed in a future release.""", DeprecationWarning)
            pulumi.log.warn("""account_id is deprecated: This field is deprecated and will be removed in a future release.""")
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if projects is not None:
            pulumi.set(__self__, "projects", projects)
        if query_name is not None:
            pulumi.set(__self__, "query_name", query_name)
        if upsert is not None:
            pulumi.set(__self__, "upsert", upsert)

    @_builtins.property
    @pulumi.getter(name="accountId")
    @_utilities.deprecated("""This field is deprecated and will be removed in a future release.""")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account identifier of the GitOps Agent where argo project will exist.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Agent identifier of the agent where argo project will exist (include scope prefix)
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_id", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Org identifier of the GitOps Agent where argo project is to be created.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project identifier of the Gitops Agent where argo project is to be created.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def projects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GitopsAppProjectProjectArgs']]]]:
        """
        GitOps project configuration.
        """
        return pulumi.get(self, "projects")

    @projects.setter
    def projects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GitopsAppProjectProjectArgs']]]]):
        pulumi.set(self, "projects", value)

    @_builtins.property
    @pulumi.getter(name="queryName")
    def query_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier for the GitOps Argo project.
        """
        return pulumi.get(self, "query_name")

    @query_name.setter
    def query_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_name", value)

    @_builtins.property
    @pulumi.getter
    def upsert(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the argo project should be updated if existing and inserted if not.
        """
        return pulumi.get(self, "upsert")

    @upsert.setter
    def upsert(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "upsert", value)


@pulumi.type_token("harness:platform/gitopsAppProject:GitopsAppProject")
class GitopsAppProject(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 projects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GitopsAppProjectProjectArgs', 'GitopsAppProjectProjectArgsDict']]]]] = None,
                 query_name: Optional[pulumi.Input[_builtins.str]] = None,
                 upsert: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        Import gitOps project with account level agent

        ```sh
        $ pulumi import harness:platform/gitopsAppProject:GitopsAppProject example <agent_id>/<app_proj_name>
        ```

        Import gitOps project with org level agent

        ```sh
        $ pulumi import harness:platform/gitopsAppProject:GitopsAppProject example <organization_id>/<agent_id>/<app_proj_name>
        ```

        Import gitOps project with project level agent

        ```sh
        $ pulumi import harness:platform/gitopsAppProject:GitopsAppProject example <organization_id>/<project_id>/<agent_id>/<app_proj_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account identifier of the GitOps Agent where argo project will exist.
        :param pulumi.Input[_builtins.str] agent_id: Agent identifier of the agent where argo project will exist (include scope prefix)
        :param pulumi.Input[_builtins.str] org_id: Org identifier of the GitOps Agent where argo project is to be created.
        :param pulumi.Input[_builtins.str] project_id: Project identifier of the Gitops Agent where argo project is to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GitopsAppProjectProjectArgs', 'GitopsAppProjectProjectArgsDict']]]] projects: GitOps project configuration.
        :param pulumi.Input[_builtins.str] query_name: Identifier for the GitOps Argo project.
        :param pulumi.Input[_builtins.bool] upsert: Indicates if the argo project should be updated if existing and inserted if not.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GitopsAppProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        Import gitOps project with account level agent

        ```sh
        $ pulumi import harness:platform/gitopsAppProject:GitopsAppProject example <agent_id>/<app_proj_name>
        ```

        Import gitOps project with org level agent

        ```sh
        $ pulumi import harness:platform/gitopsAppProject:GitopsAppProject example <organization_id>/<agent_id>/<app_proj_name>
        ```

        Import gitOps project with project level agent

        ```sh
        $ pulumi import harness:platform/gitopsAppProject:GitopsAppProject example <organization_id>/<project_id>/<agent_id>/<app_proj_name>
        ```

        :param str resource_name: The name of the resource.
        :param GitopsAppProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GitopsAppProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 projects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GitopsAppProjectProjectArgs', 'GitopsAppProjectProjectArgsDict']]]]] = None,
                 query_name: Optional[pulumi.Input[_builtins.str]] = None,
                 upsert: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GitopsAppProjectArgs.__new__(GitopsAppProjectArgs)

            __props__.__dict__["account_id"] = account_id
            if agent_id is None and not opts.urn:
                raise TypeError("Missing required property 'agent_id'")
            __props__.__dict__["agent_id"] = agent_id
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            if projects is None and not opts.urn:
                raise TypeError("Missing required property 'projects'")
            __props__.__dict__["projects"] = projects
            __props__.__dict__["query_name"] = query_name
            __props__.__dict__["upsert"] = upsert
        super(GitopsAppProject, __self__).__init__(
            'harness:platform/gitopsAppProject:GitopsAppProject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            agent_id: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            projects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GitopsAppProjectProjectArgs', 'GitopsAppProjectProjectArgsDict']]]]] = None,
            query_name: Optional[pulumi.Input[_builtins.str]] = None,
            upsert: Optional[pulumi.Input[_builtins.bool]] = None) -> 'GitopsAppProject':
        """
        Get an existing GitopsAppProject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account identifier of the GitOps Agent where argo project will exist.
        :param pulumi.Input[_builtins.str] agent_id: Agent identifier of the agent where argo project will exist (include scope prefix)
        :param pulumi.Input[_builtins.str] org_id: Org identifier of the GitOps Agent where argo project is to be created.
        :param pulumi.Input[_builtins.str] project_id: Project identifier of the Gitops Agent where argo project is to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GitopsAppProjectProjectArgs', 'GitopsAppProjectProjectArgsDict']]]] projects: GitOps project configuration.
        :param pulumi.Input[_builtins.str] query_name: Identifier for the GitOps Argo project.
        :param pulumi.Input[_builtins.bool] upsert: Indicates if the argo project should be updated if existing and inserted if not.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GitopsAppProjectState.__new__(_GitopsAppProjectState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["agent_id"] = agent_id
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["projects"] = projects
        __props__.__dict__["query_name"] = query_name
        __props__.__dict__["upsert"] = upsert
        return GitopsAppProject(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    @_utilities.deprecated("""This field is deprecated and will be removed in a future release.""")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Account identifier of the GitOps Agent where argo project will exist.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Output[_builtins.str]:
        """
        Agent identifier of the agent where argo project will exist (include scope prefix)
        """
        return pulumi.get(self, "agent_id")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Org identifier of the GitOps Agent where argo project is to be created.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Project identifier of the Gitops Agent where argo project is to be created.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def projects(self) -> pulumi.Output[Sequence['outputs.GitopsAppProjectProject']]:
        """
        GitOps project configuration.
        """
        return pulumi.get(self, "projects")

    @_builtins.property
    @pulumi.getter(name="queryName")
    def query_name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier for the GitOps Argo project.
        """
        return pulumi.get(self, "query_name")

    @_builtins.property
    @pulumi.getter
    def upsert(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates if the argo project should be updated if existing and inserted if not.
        """
        return pulumi.get(self, "upsert")

