# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GitopsFiltersArgs', 'GitopsFilters']

@pulumi.input_type
class GitopsFiltersArgs:
    def __init__(__self__, *,
                 filter_properties: pulumi.Input[_builtins.str],
                 identifier: pulumi.Input[_builtins.str],
                 org_id: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 filter_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GitopsFilters resource.
        :param pulumi.Input[_builtins.str] filter_properties: Properties of the filters entity defined in Harness as a JSON string. All values should be arrays of strings. Example: jsonencode({"healthStatus": ["Healthy", "Degraded"], "syncStatus": ["Synced"]})
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] org_id: Organization Identifier for the Entity.
        :param pulumi.Input[_builtins.str] project_id: Project Identifier for the Entity.
        :param pulumi.Input[_builtins.str] type: Type of GitOps filters.
        :param pulumi.Input[_builtins.str] filter_visibility: This indicates visibility of filters, by default it is Everyone.
        :param pulumi.Input[_builtins.str] name: Name of the GitOps filters.
        """
        pulumi.set(__self__, "filter_properties", filter_properties)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "type", type)
        if filter_visibility is not None:
            pulumi.set(__self__, "filter_visibility", filter_visibility)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="filterProperties")
    def filter_properties(self) -> pulumi.Input[_builtins.str]:
        """
        Properties of the filters entity defined in Harness as a JSON string. All values should be arrays of strings. Example: jsonencode({"healthStatus": ["Healthy", "Degraded"], "syncStatus": ["Synced"]})
        """
        return pulumi.get(self, "filter_properties")

    @filter_properties.setter
    def filter_properties(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "filter_properties", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[_builtins.str]:
        """
        Organization Identifier for the Entity.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        Project Identifier for the Entity.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of GitOps filters.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="filterVisibility")
    def filter_visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This indicates visibility of filters, by default it is Everyone.
        """
        return pulumi.get(self, "filter_visibility")

    @filter_visibility.setter
    def filter_visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter_visibility", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the GitOps filters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _GitopsFiltersState:
    def __init__(__self__, *,
                 filter_properties: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GitopsFilters resources.
        :param pulumi.Input[_builtins.str] filter_properties: Properties of the filters entity defined in Harness as a JSON string. All values should be arrays of strings. Example: jsonencode({"healthStatus": ["Healthy", "Degraded"], "syncStatus": ["Synced"]})
        :param pulumi.Input[_builtins.str] filter_visibility: This indicates visibility of filters, by default it is Everyone.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the GitOps filters.
        :param pulumi.Input[_builtins.str] org_id: Organization Identifier for the Entity.
        :param pulumi.Input[_builtins.str] project_id: Project Identifier for the Entity.
        :param pulumi.Input[_builtins.str] type: Type of GitOps filters.
        """
        if filter_properties is not None:
            pulumi.set(__self__, "filter_properties", filter_properties)
        if filter_visibility is not None:
            pulumi.set(__self__, "filter_visibility", filter_visibility)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="filterProperties")
    def filter_properties(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Properties of the filters entity defined in Harness as a JSON string. All values should be arrays of strings. Example: jsonencode({"healthStatus": ["Healthy", "Degraded"], "syncStatus": ["Synced"]})
        """
        return pulumi.get(self, "filter_properties")

    @filter_properties.setter
    def filter_properties(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter_properties", value)

    @_builtins.property
    @pulumi.getter(name="filterVisibility")
    def filter_visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This indicates visibility of filters, by default it is Everyone.
        """
        return pulumi.get(self, "filter_visibility")

    @filter_visibility.setter
    def filter_visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter_visibility", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the GitOps filters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Organization Identifier for the Entity.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project Identifier for the Entity.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of GitOps filters.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("harness:platform/gitopsFilters:GitopsFilters")
class GitopsFilters(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filter_properties: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for creating Harness GitOps Filters.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] filter_properties: Properties of the filters entity defined in Harness as a JSON string. All values should be arrays of strings. Example: jsonencode({"healthStatus": ["Healthy", "Degraded"], "syncStatus": ["Synced"]})
        :param pulumi.Input[_builtins.str] filter_visibility: This indicates visibility of filters, by default it is Everyone.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the GitOps filters.
        :param pulumi.Input[_builtins.str] org_id: Organization Identifier for the Entity.
        :param pulumi.Input[_builtins.str] project_id: Project Identifier for the Entity.
        :param pulumi.Input[_builtins.str] type: Type of GitOps filters.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GitopsFiltersArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating Harness GitOps Filters.

        :param str resource_name: The name of the resource.
        :param GitopsFiltersArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GitopsFiltersArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filter_properties: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GitopsFiltersArgs.__new__(GitopsFiltersArgs)

            if filter_properties is None and not opts.urn:
                raise TypeError("Missing required property 'filter_properties'")
            __props__.__dict__["filter_properties"] = filter_properties
            __props__.__dict__["filter_visibility"] = filter_visibility
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["name"] = name
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(GitopsFilters, __self__).__init__(
            'harness:platform/gitopsFilters:GitopsFilters',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            filter_properties: Optional[pulumi.Input[_builtins.str]] = None,
            filter_visibility: Optional[pulumi.Input[_builtins.str]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'GitopsFilters':
        """
        Get an existing GitopsFilters resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] filter_properties: Properties of the filters entity defined in Harness as a JSON string. All values should be arrays of strings. Example: jsonencode({"healthStatus": ["Healthy", "Degraded"], "syncStatus": ["Synced"]})
        :param pulumi.Input[_builtins.str] filter_visibility: This indicates visibility of filters, by default it is Everyone.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the GitOps filters.
        :param pulumi.Input[_builtins.str] org_id: Organization Identifier for the Entity.
        :param pulumi.Input[_builtins.str] project_id: Project Identifier for the Entity.
        :param pulumi.Input[_builtins.str] type: Type of GitOps filters.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GitopsFiltersState.__new__(_GitopsFiltersState)

        __props__.__dict__["filter_properties"] = filter_properties
        __props__.__dict__["filter_visibility"] = filter_visibility
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["type"] = type
        return GitopsFilters(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="filterProperties")
    def filter_properties(self) -> pulumi.Output[_builtins.str]:
        """
        Properties of the filters entity defined in Harness as a JSON string. All values should be arrays of strings. Example: jsonencode({"healthStatus": ["Healthy", "Degraded"], "syncStatus": ["Synced"]})
        """
        return pulumi.get(self, "filter_properties")

    @_builtins.property
    @pulumi.getter(name="filterVisibility")
    def filter_visibility(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        This indicates visibility of filters, by default it is Everyone.
        """
        return pulumi.get(self, "filter_visibility")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the GitOps filters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[_builtins.str]:
        """
        Organization Identifier for the Entity.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Project Identifier for the Entity.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of GitOps filters.
        """
        return pulumi.get(self, "type")

