# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InfraVariableSetArgs', 'InfraVariableSet']

@pulumi.input_type
class InfraVariableSetArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[_builtins.str],
                 connectors: Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetConnectorArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetEnvironmentVariableArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 terraform_variable_files: Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetTerraformVariableFileArgs']]]] = None,
                 terraform_variables: Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetTerraformVariableArgs']]]] = None):
        """
        The set of arguments for constructing a InfraVariableSet resource.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['InfraVariableSetConnectorArgs']]] connectors: Provider connectors configured on the Variable Set. Only one connector of a type is supported
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['InfraVariableSetEnvironmentVariableArgs']]] environment_variables: Environment variables configured on the Variable Set
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        pulumi.set(__self__, "identifier", identifier)
        if connectors is not None:
            pulumi.set(__self__, "connectors", connectors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if terraform_variable_files is not None:
            pulumi.set(__self__, "terraform_variable_files", terraform_variable_files)
        if terraform_variables is not None:
            pulumi.set(__self__, "terraform_variables", terraform_variables)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def connectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetConnectorArgs']]]]:
        """
        Provider connectors configured on the Variable Set. Only one connector of a type is supported
        """
        return pulumi.get(self, "connectors")

    @connectors.setter
    def connectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetConnectorArgs']]]]):
        pulumi.set(self, "connectors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetEnvironmentVariableArgs']]]]:
        """
        Environment variables configured on the Variable Set
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetEnvironmentVariableArgs']]]]):
        pulumi.set(self, "environment_variables", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="terraformVariableFiles")
    def terraform_variable_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetTerraformVariableFileArgs']]]]:
        return pulumi.get(self, "terraform_variable_files")

    @terraform_variable_files.setter
    def terraform_variable_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetTerraformVariableFileArgs']]]]):
        pulumi.set(self, "terraform_variable_files", value)

    @_builtins.property
    @pulumi.getter(name="terraformVariables")
    def terraform_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetTerraformVariableArgs']]]]:
        return pulumi.get(self, "terraform_variables")

    @terraform_variables.setter
    def terraform_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetTerraformVariableArgs']]]]):
        pulumi.set(self, "terraform_variables", value)


@pulumi.input_type
class _InfraVariableSetState:
    def __init__(__self__, *,
                 connectors: Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetConnectorArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetEnvironmentVariableArgs']]]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 terraform_variable_files: Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetTerraformVariableFileArgs']]]] = None,
                 terraform_variables: Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetTerraformVariableArgs']]]] = None):
        """
        Input properties used for looking up and filtering InfraVariableSet resources.
        :param pulumi.Input[Sequence[pulumi.Input['InfraVariableSetConnectorArgs']]] connectors: Provider connectors configured on the Variable Set. Only one connector of a type is supported
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['InfraVariableSetEnvironmentVariableArgs']]] environment_variables: Environment variables configured on the Variable Set
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        if connectors is not None:
            pulumi.set(__self__, "connectors", connectors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if terraform_variable_files is not None:
            pulumi.set(__self__, "terraform_variable_files", terraform_variable_files)
        if terraform_variables is not None:
            pulumi.set(__self__, "terraform_variables", terraform_variables)

    @_builtins.property
    @pulumi.getter
    def connectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetConnectorArgs']]]]:
        """
        Provider connectors configured on the Variable Set. Only one connector of a type is supported
        """
        return pulumi.get(self, "connectors")

    @connectors.setter
    def connectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetConnectorArgs']]]]):
        pulumi.set(self, "connectors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetEnvironmentVariableArgs']]]]:
        """
        Environment variables configured on the Variable Set
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetEnvironmentVariableArgs']]]]):
        pulumi.set(self, "environment_variables", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="terraformVariableFiles")
    def terraform_variable_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetTerraformVariableFileArgs']]]]:
        return pulumi.get(self, "terraform_variable_files")

    @terraform_variable_files.setter
    def terraform_variable_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetTerraformVariableFileArgs']]]]):
        pulumi.set(self, "terraform_variable_files", value)

    @_builtins.property
    @pulumi.getter(name="terraformVariables")
    def terraform_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetTerraformVariableArgs']]]]:
        return pulumi.get(self, "terraform_variables")

    @terraform_variables.setter
    def terraform_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfraVariableSetTerraformVariableArgs']]]]):
        pulumi.set(self, "terraform_variables", value)


@pulumi.type_token("harness:platform/infraVariableSet:InfraVariableSet")
class InfraVariableSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfraVariableSetConnectorArgs', 'InfraVariableSetConnectorArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfraVariableSetEnvironmentVariableArgs', 'InfraVariableSetEnvironmentVariableArgsDict']]]]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 terraform_variable_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfraVariableSetTerraformVariableFileArgs', 'InfraVariableSetTerraformVariableFileArgsDict']]]]] = None,
                 terraform_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfraVariableSetTerraformVariableArgs', 'InfraVariableSetTerraformVariableArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource for managing Variable Sets

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.InfraVariableSet("example",
            identifier="example",
            name="example",
            org_id=test["id"],
            project_id=test_harness_platform_project["id"],
            description="some description",
            environment_variables=[
                {
                    "key": "key1",
                    "value": "value1",
                    "value_type": "string",
                },
                {
                    "key": "key2",
                    "value": "harness_platform_secret_text.test.id",
                    "value_type": "secret",
                },
            ],
            terraform_variables=[
                {
                    "key": "key1",
                    "value": "1111",
                    "value_type": "string",
                },
                {
                    "key": "key2",
                    "value": "1111u",
                    "value_type": "string",
                },
            ],
            terraform_variable_files=[
                {
                    "repository": "https://github.com/org/repo",
                    "repository_branch": "main",
                    "repository_path": "tf/aws/basic",
                    "repository_connector": "harness_platform_connector_github.test.id",
                },
                {
                    "repository": "https://github.com/org/repo",
                    "repository_branch": "br2",
                    "repository_path": "tf/aws/basic",
                    "repository_connector": "harness_platform_connector_github.test.id",
                },
            ],
            connectors=[
                {
                    "connector_ref": "harness_platform_connector_aws.test.id",
                    "type": "aws",
                },
                {
                    "connector_ref": "harness_platform_connector_azure.test.id",
                    "type": "azure",
                },
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level variable set

        ```sh
        $ pulumi import harness:platform/infraVariableSet:InfraVariableSet example <variable_set_id>
        ```

        Import org level variable set

        ```sh
        $ pulumi import harness:platform/infraVariableSet:InfraVariableSet example <ord_id>/<variable_set_id>
        ```

        Import project level variable set

        ```sh
        $ pulumi import harness:platform/infraVariableSet:InfraVariableSet example <org_id>/<project_id>/<variable_set_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfraVariableSetConnectorArgs', 'InfraVariableSetConnectorArgsDict']]]] connectors: Provider connectors configured on the Variable Set. Only one connector of a type is supported
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfraVariableSetEnvironmentVariableArgs', 'InfraVariableSetEnvironmentVariableArgsDict']]]] environment_variables: Environment variables configured on the Variable Set
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InfraVariableSetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing Variable Sets

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.InfraVariableSet("example",
            identifier="example",
            name="example",
            org_id=test["id"],
            project_id=test_harness_platform_project["id"],
            description="some description",
            environment_variables=[
                {
                    "key": "key1",
                    "value": "value1",
                    "value_type": "string",
                },
                {
                    "key": "key2",
                    "value": "harness_platform_secret_text.test.id",
                    "value_type": "secret",
                },
            ],
            terraform_variables=[
                {
                    "key": "key1",
                    "value": "1111",
                    "value_type": "string",
                },
                {
                    "key": "key2",
                    "value": "1111u",
                    "value_type": "string",
                },
            ],
            terraform_variable_files=[
                {
                    "repository": "https://github.com/org/repo",
                    "repository_branch": "main",
                    "repository_path": "tf/aws/basic",
                    "repository_connector": "harness_platform_connector_github.test.id",
                },
                {
                    "repository": "https://github.com/org/repo",
                    "repository_branch": "br2",
                    "repository_path": "tf/aws/basic",
                    "repository_connector": "harness_platform_connector_github.test.id",
                },
            ],
            connectors=[
                {
                    "connector_ref": "harness_platform_connector_aws.test.id",
                    "type": "aws",
                },
                {
                    "connector_ref": "harness_platform_connector_azure.test.id",
                    "type": "azure",
                },
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level variable set

        ```sh
        $ pulumi import harness:platform/infraVariableSet:InfraVariableSet example <variable_set_id>
        ```

        Import org level variable set

        ```sh
        $ pulumi import harness:platform/infraVariableSet:InfraVariableSet example <ord_id>/<variable_set_id>
        ```

        Import project level variable set

        ```sh
        $ pulumi import harness:platform/infraVariableSet:InfraVariableSet example <org_id>/<project_id>/<variable_set_id>
        ```

        :param str resource_name: The name of the resource.
        :param InfraVariableSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InfraVariableSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfraVariableSetConnectorArgs', 'InfraVariableSetConnectorArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfraVariableSetEnvironmentVariableArgs', 'InfraVariableSetEnvironmentVariableArgsDict']]]]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 terraform_variable_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfraVariableSetTerraformVariableFileArgs', 'InfraVariableSetTerraformVariableFileArgsDict']]]]] = None,
                 terraform_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfraVariableSetTerraformVariableArgs', 'InfraVariableSetTerraformVariableArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InfraVariableSetArgs.__new__(InfraVariableSetArgs)

            __props__.__dict__["connectors"] = connectors
            __props__.__dict__["description"] = description
            __props__.__dict__["environment_variables"] = environment_variables
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["name"] = name
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["terraform_variable_files"] = terraform_variable_files
            __props__.__dict__["terraform_variables"] = terraform_variables
        super(InfraVariableSet, __self__).__init__(
            'harness:platform/infraVariableSet:InfraVariableSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfraVariableSetConnectorArgs', 'InfraVariableSetConnectorArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfraVariableSetEnvironmentVariableArgs', 'InfraVariableSetEnvironmentVariableArgsDict']]]]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            terraform_variable_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfraVariableSetTerraformVariableFileArgs', 'InfraVariableSetTerraformVariableFileArgsDict']]]]] = None,
            terraform_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfraVariableSetTerraformVariableArgs', 'InfraVariableSetTerraformVariableArgsDict']]]]] = None) -> 'InfraVariableSet':
        """
        Get an existing InfraVariableSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfraVariableSetConnectorArgs', 'InfraVariableSetConnectorArgsDict']]]] connectors: Provider connectors configured on the Variable Set. Only one connector of a type is supported
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfraVariableSetEnvironmentVariableArgs', 'InfraVariableSetEnvironmentVariableArgsDict']]]] environment_variables: Environment variables configured on the Variable Set
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InfraVariableSetState.__new__(_InfraVariableSetState)

        __props__.__dict__["connectors"] = connectors
        __props__.__dict__["description"] = description
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["terraform_variable_files"] = terraform_variable_files
        __props__.__dict__["terraform_variables"] = terraform_variables
        return InfraVariableSet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def connectors(self) -> pulumi.Output[Optional[Sequence['outputs.InfraVariableSetConnector']]]:
        """
        Provider connectors configured on the Variable Set. Only one connector of a type is supported
        """
        return pulumi.get(self, "connectors")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Optional[Sequence['outputs.InfraVariableSetEnvironmentVariable']]]:
        """
        Environment variables configured on the Variable Set
        """
        return pulumi.get(self, "environment_variables")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="terraformVariableFiles")
    def terraform_variable_files(self) -> pulumi.Output[Optional[Sequence['outputs.InfraVariableSetTerraformVariableFile']]]:
        return pulumi.get(self, "terraform_variable_files")

    @_builtins.property
    @pulumi.getter(name="terraformVariables")
    def terraform_variables(self) -> pulumi.Output[Optional[Sequence['outputs.InfraVariableSetTerraformVariable']]]:
        return pulumi.get(self, "terraform_variables")

