# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OverridesArgs', 'Overrides']

@pulumi.input_type
class OverridesArgs:
    def __init__(__self__, *,
                 env_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 git_details: Optional[pulumi.Input['OverridesGitDetailsArgs']] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 import_from_git: Optional[pulumi.Input[_builtins.bool]] = None,
                 infra_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_force_import: Optional[pulumi.Input[_builtins.bool]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 yaml: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Overrides resource.
        :param pulumi.Input[_builtins.str] env_id: The environment ID to which the overrides are associated.
        :param pulumi.Input[_builtins.str] type: The type of the overrides.
        :param pulumi.Input[_builtins.str] cluster_id: The cluster ID to which the overrides are associated.
        :param pulumi.Input['OverridesGitDetailsArgs'] git_details: Contains parameters related to creating an Entity for Git Experience.
        :param pulumi.Input[_builtins.str] identifier: The identifier of the override entity.
        :param pulumi.Input[_builtins.bool] import_from_git: import override from git
        :param pulumi.Input[_builtins.str] infra_id: The infrastructure ID to which the overrides are associated.
        :param pulumi.Input[_builtins.bool] is_force_import: force import override from remote even if same file path already exist
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.str] service_id: The service ID to which the overrides applies.
        :param pulumi.Input[_builtins.str] yaml: The yaml of the override entity
        """
        pulumi.set(__self__, "env_id", env_id)
        pulumi.set(__self__, "type", type)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if git_details is not None:
            pulumi.set(__self__, "git_details", git_details)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if import_from_git is not None:
            pulumi.set(__self__, "import_from_git", import_from_git)
        if infra_id is not None:
            pulumi.set(__self__, "infra_id", infra_id)
        if is_force_import is not None:
            pulumi.set(__self__, "is_force_import", is_force_import)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)
        if yaml is not None:
            pulumi.set(__self__, "yaml", yaml)

    @_builtins.property
    @pulumi.getter(name="envId")
    def env_id(self) -> pulumi.Input[_builtins.str]:
        """
        The environment ID to which the overrides are associated.
        """
        return pulumi.get(self, "env_id")

    @env_id.setter
    def env_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "env_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the overrides.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster ID to which the overrides are associated.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="gitDetails")
    def git_details(self) -> Optional[pulumi.Input['OverridesGitDetailsArgs']]:
        """
        Contains parameters related to creating an Entity for Git Experience.
        """
        return pulumi.get(self, "git_details")

    @git_details.setter
    def git_details(self, value: Optional[pulumi.Input['OverridesGitDetailsArgs']]):
        pulumi.set(self, "git_details", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the override entity.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="importFromGit")
    def import_from_git(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        import override from git
        """
        return pulumi.get(self, "import_from_git")

    @import_from_git.setter
    def import_from_git(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "import_from_git", value)

    @_builtins.property
    @pulumi.getter(name="infraId")
    def infra_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The infrastructure ID to which the overrides are associated.
        """
        return pulumi.get(self, "infra_id")

    @infra_id.setter
    def infra_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "infra_id", value)

    @_builtins.property
    @pulumi.getter(name="isForceImport")
    def is_force_import(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        force import override from remote even if same file path already exist
        """
        return pulumi.get(self, "is_force_import")

    @is_force_import.setter
    def is_force_import(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_force_import", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service ID to which the overrides applies.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_id", value)

    @_builtins.property
    @pulumi.getter
    def yaml(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The yaml of the override entity
        """
        return pulumi.get(self, "yaml")

    @yaml.setter
    def yaml(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "yaml", value)


@pulumi.input_type
class _OverridesState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 env_id: Optional[pulumi.Input[_builtins.str]] = None,
                 git_details: Optional[pulumi.Input['OverridesGitDetailsArgs']] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 import_from_git: Optional[pulumi.Input[_builtins.bool]] = None,
                 infra_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_force_import: Optional[pulumi.Input[_builtins.bool]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 yaml: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Overrides resources.
        :param pulumi.Input[_builtins.str] cluster_id: The cluster ID to which the overrides are associated.
        :param pulumi.Input[_builtins.str] env_id: The environment ID to which the overrides are associated.
        :param pulumi.Input['OverridesGitDetailsArgs'] git_details: Contains parameters related to creating an Entity for Git Experience.
        :param pulumi.Input[_builtins.str] identifier: The identifier of the override entity.
        :param pulumi.Input[_builtins.bool] import_from_git: import override from git
        :param pulumi.Input[_builtins.str] infra_id: The infrastructure ID to which the overrides are associated.
        :param pulumi.Input[_builtins.bool] is_force_import: force import override from remote even if same file path already exist
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.str] service_id: The service ID to which the overrides applies.
        :param pulumi.Input[_builtins.str] type: The type of the overrides.
        :param pulumi.Input[_builtins.str] yaml: The yaml of the override entity
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if env_id is not None:
            pulumi.set(__self__, "env_id", env_id)
        if git_details is not None:
            pulumi.set(__self__, "git_details", git_details)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if import_from_git is not None:
            pulumi.set(__self__, "import_from_git", import_from_git)
        if infra_id is not None:
            pulumi.set(__self__, "infra_id", infra_id)
        if is_force_import is not None:
            pulumi.set(__self__, "is_force_import", is_force_import)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if yaml is not None:
            pulumi.set(__self__, "yaml", yaml)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster ID to which the overrides are associated.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="envId")
    def env_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The environment ID to which the overrides are associated.
        """
        return pulumi.get(self, "env_id")

    @env_id.setter
    def env_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "env_id", value)

    @_builtins.property
    @pulumi.getter(name="gitDetails")
    def git_details(self) -> Optional[pulumi.Input['OverridesGitDetailsArgs']]:
        """
        Contains parameters related to creating an Entity for Git Experience.
        """
        return pulumi.get(self, "git_details")

    @git_details.setter
    def git_details(self, value: Optional[pulumi.Input['OverridesGitDetailsArgs']]):
        pulumi.set(self, "git_details", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the override entity.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="importFromGit")
    def import_from_git(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        import override from git
        """
        return pulumi.get(self, "import_from_git")

    @import_from_git.setter
    def import_from_git(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "import_from_git", value)

    @_builtins.property
    @pulumi.getter(name="infraId")
    def infra_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The infrastructure ID to which the overrides are associated.
        """
        return pulumi.get(self, "infra_id")

    @infra_id.setter
    def infra_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "infra_id", value)

    @_builtins.property
    @pulumi.getter(name="isForceImport")
    def is_force_import(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        force import override from remote even if same file path already exist
        """
        return pulumi.get(self, "is_force_import")

    @is_force_import.setter
    def is_force_import(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_force_import", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service ID to which the overrides applies.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the overrides.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def yaml(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The yaml of the override entity
        """
        return pulumi.get(self, "yaml")

    @yaml.setter
    def yaml(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "yaml", value)


@pulumi.type_token("harness:platform/overrides:Overrides")
class Overrides(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 env_id: Optional[pulumi.Input[_builtins.str]] = None,
                 git_details: Optional[pulumi.Input[Union['OverridesGitDetailsArgs', 'OverridesGitDetailsArgsDict']]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 import_from_git: Optional[pulumi.Input[_builtins.bool]] = None,
                 infra_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_force_import: Optional[pulumi.Input[_builtins.bool]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 yaml: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for creating a Harness Override V2.

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level override

        ```sh
        $ pulumi import harness:platform/overrides:Overrides example <override_id>
        ```

        Import org level override

        ```sh
        $ pulumi import harness:platform/overrides:Overrides example <org_id>/<override_id>
        ```

        Import project level override

        ```sh
        $ pulumi import harness:platform/overrides:Overrides example <org_id>/<project_id>/<override_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The cluster ID to which the overrides are associated.
        :param pulumi.Input[_builtins.str] env_id: The environment ID to which the overrides are associated.
        :param pulumi.Input[Union['OverridesGitDetailsArgs', 'OverridesGitDetailsArgsDict']] git_details: Contains parameters related to creating an Entity for Git Experience.
        :param pulumi.Input[_builtins.str] identifier: The identifier of the override entity.
        :param pulumi.Input[_builtins.bool] import_from_git: import override from git
        :param pulumi.Input[_builtins.str] infra_id: The infrastructure ID to which the overrides are associated.
        :param pulumi.Input[_builtins.bool] is_force_import: force import override from remote even if same file path already exist
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.str] service_id: The service ID to which the overrides applies.
        :param pulumi.Input[_builtins.str] type: The type of the overrides.
        :param pulumi.Input[_builtins.str] yaml: The yaml of the override entity
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OverridesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating a Harness Override V2.

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level override

        ```sh
        $ pulumi import harness:platform/overrides:Overrides example <override_id>
        ```

        Import org level override

        ```sh
        $ pulumi import harness:platform/overrides:Overrides example <org_id>/<override_id>
        ```

        Import project level override

        ```sh
        $ pulumi import harness:platform/overrides:Overrides example <org_id>/<project_id>/<override_id>
        ```

        :param str resource_name: The name of the resource.
        :param OverridesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OverridesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 env_id: Optional[pulumi.Input[_builtins.str]] = None,
                 git_details: Optional[pulumi.Input[Union['OverridesGitDetailsArgs', 'OverridesGitDetailsArgsDict']]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 import_from_git: Optional[pulumi.Input[_builtins.bool]] = None,
                 infra_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_force_import: Optional[pulumi.Input[_builtins.bool]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 yaml: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OverridesArgs.__new__(OverridesArgs)

            __props__.__dict__["cluster_id"] = cluster_id
            if env_id is None and not opts.urn:
                raise TypeError("Missing required property 'env_id'")
            __props__.__dict__["env_id"] = env_id
            __props__.__dict__["git_details"] = git_details
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["import_from_git"] = import_from_git
            __props__.__dict__["infra_id"] = infra_id
            __props__.__dict__["is_force_import"] = is_force_import
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["service_id"] = service_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["yaml"] = yaml
        super(Overrides, __self__).__init__(
            'harness:platform/overrides:Overrides',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            env_id: Optional[pulumi.Input[_builtins.str]] = None,
            git_details: Optional[pulumi.Input[Union['OverridesGitDetailsArgs', 'OverridesGitDetailsArgsDict']]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            import_from_git: Optional[pulumi.Input[_builtins.bool]] = None,
            infra_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_force_import: Optional[pulumi.Input[_builtins.bool]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_id: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            yaml: Optional[pulumi.Input[_builtins.str]] = None) -> 'Overrides':
        """
        Get an existing Overrides resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The cluster ID to which the overrides are associated.
        :param pulumi.Input[_builtins.str] env_id: The environment ID to which the overrides are associated.
        :param pulumi.Input[Union['OverridesGitDetailsArgs', 'OverridesGitDetailsArgsDict']] git_details: Contains parameters related to creating an Entity for Git Experience.
        :param pulumi.Input[_builtins.str] identifier: The identifier of the override entity.
        :param pulumi.Input[_builtins.bool] import_from_git: import override from git
        :param pulumi.Input[_builtins.str] infra_id: The infrastructure ID to which the overrides are associated.
        :param pulumi.Input[_builtins.bool] is_force_import: force import override from remote even if same file path already exist
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.str] service_id: The service ID to which the overrides applies.
        :param pulumi.Input[_builtins.str] type: The type of the overrides.
        :param pulumi.Input[_builtins.str] yaml: The yaml of the override entity
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OverridesState.__new__(_OverridesState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["env_id"] = env_id
        __props__.__dict__["git_details"] = git_details
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["import_from_git"] = import_from_git
        __props__.__dict__["infra_id"] = infra_id
        __props__.__dict__["is_force_import"] = is_force_import
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["service_id"] = service_id
        __props__.__dict__["type"] = type
        __props__.__dict__["yaml"] = yaml
        return Overrides(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster ID to which the overrides are associated.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="envId")
    def env_id(self) -> pulumi.Output[_builtins.str]:
        """
        The environment ID to which the overrides are associated.
        """
        return pulumi.get(self, "env_id")

    @_builtins.property
    @pulumi.getter(name="gitDetails")
    def git_details(self) -> pulumi.Output['outputs.OverridesGitDetails']:
        """
        Contains parameters related to creating an Entity for Git Experience.
        """
        return pulumi.get(self, "git_details")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier of the override entity.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="importFromGit")
    def import_from_git(self) -> pulumi.Output[_builtins.bool]:
        """
        import override from git
        """
        return pulumi.get(self, "import_from_git")

    @_builtins.property
    @pulumi.getter(name="infraId")
    def infra_id(self) -> pulumi.Output[_builtins.str]:
        """
        The infrastructure ID to which the overrides are associated.
        """
        return pulumi.get(self, "infra_id")

    @_builtins.property
    @pulumi.getter(name="isForceImport")
    def is_force_import(self) -> pulumi.Output[_builtins.bool]:
        """
        force import override from remote even if same file path already exist
        """
        return pulumi.get(self, "is_force_import")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[_builtins.str]:
        """
        The service ID to which the overrides applies.
        """
        return pulumi.get(self, "service_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the overrides.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def yaml(self) -> pulumi.Output[_builtins.str]:
        """
        The yaml of the override entity
        """
        return pulumi.get(self, "yaml")

