# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TemplateArgs', 'Template']

@pulumi.input_type
class TemplateArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[_builtins.str],
                 version: pulumi.Input[_builtins.str],
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 git_details: Optional[pulumi.Input['TemplateGitDetailsArgs']] = None,
                 git_import_details: Optional[pulumi.Input['TemplateGitImportDetailsArgs']] = None,
                 import_from_git: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_stable: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 template_import_request: Optional[pulumi.Input['TemplateTemplateImportRequestArgs']] = None,
                 template_yaml: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Template resource.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource. Cannot be changed once the resource is created. Must match the identifier in the template_yaml.
        :param pulumi.Input[_builtins.str] version: Version Label for Template.
        :param pulumi.Input[_builtins.str] comments: Specify comment with respect to changes.
        :param pulumi.Input[_builtins.str] description: Description of the entity. Description field is deprecated
        :param pulumi.Input[_builtins.bool] force_delete: Enable this flag for force deletion of template. It will delete the Harness entity even if your pipelines or other entities reference it
        :param pulumi.Input['TemplateGitDetailsArgs'] git_details: Contains parameters related to creating an Entity for Git Experience.
        :param pulumi.Input['TemplateGitImportDetailsArgs'] git_import_details: Contains Git Information for importing entities from Git
        :param pulumi.Input[_builtins.bool] import_from_git: Flag to set if importing from Git
        :param pulumi.Input[_builtins.bool] is_stable: True if given version for template to be set as stable.
        :param pulumi.Input[_builtins.str] name: Name of the Variable
        :param pulumi.Input[_builtins.str] org_id: Organization Identifier for the Entity
        :param pulumi.Input[_builtins.str] project_id: Project Identifier for the Entity
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input['TemplateTemplateImportRequestArgs'] template_import_request: Contains parameters for importing template.
        :param pulumi.Input[_builtins.str] template_yaml: Yaml for creating new Template. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}. For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as connectorRef: org.connectorId.
        """
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "version", version)
        if comments is not None:
            pulumi.set(__self__, "comments", comments)
        if description is not None:
            warnings.warn("""description field is deprecated""", DeprecationWarning)
            pulumi.log.warn("""description is deprecated: description field is deprecated""")
        if description is not None:
            pulumi.set(__self__, "description", description)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if git_details is not None:
            pulumi.set(__self__, "git_details", git_details)
        if git_import_details is not None:
            pulumi.set(__self__, "git_import_details", git_import_details)
        if import_from_git is not None:
            pulumi.set(__self__, "import_from_git", import_from_git)
        if is_stable is not None:
            pulumi.set(__self__, "is_stable", is_stable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_import_request is not None:
            pulumi.set(__self__, "template_import_request", template_import_request)
        if template_yaml is not None:
            pulumi.set(__self__, "template_yaml", template_yaml)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the resource. Cannot be changed once the resource is created. Must match the identifier in the template_yaml.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        Version Label for Template.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def comments(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify comment with respect to changes.
        """
        return pulumi.get(self, "comments")

    @comments.setter
    def comments(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comments", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""description field is deprecated""")
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the entity. Description field is deprecated
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable this flag for force deletion of template. It will delete the Harness entity even if your pipelines or other entities reference it
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="gitDetails")
    def git_details(self) -> Optional[pulumi.Input['TemplateGitDetailsArgs']]:
        """
        Contains parameters related to creating an Entity for Git Experience.
        """
        return pulumi.get(self, "git_details")

    @git_details.setter
    def git_details(self, value: Optional[pulumi.Input['TemplateGitDetailsArgs']]):
        pulumi.set(self, "git_details", value)

    @_builtins.property
    @pulumi.getter(name="gitImportDetails")
    def git_import_details(self) -> Optional[pulumi.Input['TemplateGitImportDetailsArgs']]:
        """
        Contains Git Information for importing entities from Git
        """
        return pulumi.get(self, "git_import_details")

    @git_import_details.setter
    def git_import_details(self, value: Optional[pulumi.Input['TemplateGitImportDetailsArgs']]):
        pulumi.set(self, "git_import_details", value)

    @_builtins.property
    @pulumi.getter(name="importFromGit")
    def import_from_git(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to set if importing from Git
        """
        return pulumi.get(self, "import_from_git")

    @import_from_git.setter
    def import_from_git(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "import_from_git", value)

    @_builtins.property
    @pulumi.getter(name="isStable")
    def is_stable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if given version for template to be set as stable.
        """
        return pulumi.get(self, "is_stable")

    @is_stable.setter
    def is_stable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_stable", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Variable
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Organization Identifier for the Entity
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project Identifier for the Entity
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="templateImportRequest")
    def template_import_request(self) -> Optional[pulumi.Input['TemplateTemplateImportRequestArgs']]:
        """
        Contains parameters for importing template.
        """
        return pulumi.get(self, "template_import_request")

    @template_import_request.setter
    def template_import_request(self, value: Optional[pulumi.Input['TemplateTemplateImportRequestArgs']]):
        pulumi.set(self, "template_import_request", value)

    @_builtins.property
    @pulumi.getter(name="templateYaml")
    def template_yaml(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Yaml for creating new Template. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}. For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as connectorRef: org.connectorId.
        """
        return pulumi.get(self, "template_yaml")

    @template_yaml.setter
    def template_yaml(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_yaml", value)


@pulumi.input_type
class _TemplateState:
    def __init__(__self__, *,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 git_details: Optional[pulumi.Input['TemplateGitDetailsArgs']] = None,
                 git_import_details: Optional[pulumi.Input['TemplateGitImportDetailsArgs']] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 import_from_git: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_stable: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 template_import_request: Optional[pulumi.Input['TemplateTemplateImportRequestArgs']] = None,
                 template_yaml: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Template resources.
        :param pulumi.Input[_builtins.str] comments: Specify comment with respect to changes.
        :param pulumi.Input[_builtins.str] description: Description of the entity. Description field is deprecated
        :param pulumi.Input[_builtins.bool] force_delete: Enable this flag for force deletion of template. It will delete the Harness entity even if your pipelines or other entities reference it
        :param pulumi.Input['TemplateGitDetailsArgs'] git_details: Contains parameters related to creating an Entity for Git Experience.
        :param pulumi.Input['TemplateGitImportDetailsArgs'] git_import_details: Contains Git Information for importing entities from Git
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource. Cannot be changed once the resource is created. Must match the identifier in the template_yaml.
        :param pulumi.Input[_builtins.bool] import_from_git: Flag to set if importing from Git
        :param pulumi.Input[_builtins.bool] is_stable: True if given version for template to be set as stable.
        :param pulumi.Input[_builtins.str] name: Name of the Variable
        :param pulumi.Input[_builtins.str] org_id: Organization Identifier for the Entity
        :param pulumi.Input[_builtins.str] project_id: Project Identifier for the Entity
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input['TemplateTemplateImportRequestArgs'] template_import_request: Contains parameters for importing template.
        :param pulumi.Input[_builtins.str] template_yaml: Yaml for creating new Template. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}. For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as connectorRef: org.connectorId.
        :param pulumi.Input[_builtins.str] version: Version Label for Template.
        """
        if comments is not None:
            pulumi.set(__self__, "comments", comments)
        if description is not None:
            warnings.warn("""description field is deprecated""", DeprecationWarning)
            pulumi.log.warn("""description is deprecated: description field is deprecated""")
        if description is not None:
            pulumi.set(__self__, "description", description)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if git_details is not None:
            pulumi.set(__self__, "git_details", git_details)
        if git_import_details is not None:
            pulumi.set(__self__, "git_import_details", git_import_details)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if import_from_git is not None:
            pulumi.set(__self__, "import_from_git", import_from_git)
        if is_stable is not None:
            pulumi.set(__self__, "is_stable", is_stable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_import_request is not None:
            pulumi.set(__self__, "template_import_request", template_import_request)
        if template_yaml is not None:
            pulumi.set(__self__, "template_yaml", template_yaml)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def comments(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify comment with respect to changes.
        """
        return pulumi.get(self, "comments")

    @comments.setter
    def comments(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comments", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""description field is deprecated""")
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the entity. Description field is deprecated
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable this flag for force deletion of template. It will delete the Harness entity even if your pipelines or other entities reference it
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="gitDetails")
    def git_details(self) -> Optional[pulumi.Input['TemplateGitDetailsArgs']]:
        """
        Contains parameters related to creating an Entity for Git Experience.
        """
        return pulumi.get(self, "git_details")

    @git_details.setter
    def git_details(self, value: Optional[pulumi.Input['TemplateGitDetailsArgs']]):
        pulumi.set(self, "git_details", value)

    @_builtins.property
    @pulumi.getter(name="gitImportDetails")
    def git_import_details(self) -> Optional[pulumi.Input['TemplateGitImportDetailsArgs']]:
        """
        Contains Git Information for importing entities from Git
        """
        return pulumi.get(self, "git_import_details")

    @git_import_details.setter
    def git_import_details(self, value: Optional[pulumi.Input['TemplateGitImportDetailsArgs']]):
        pulumi.set(self, "git_import_details", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the resource. Cannot be changed once the resource is created. Must match the identifier in the template_yaml.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="importFromGit")
    def import_from_git(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to set if importing from Git
        """
        return pulumi.get(self, "import_from_git")

    @import_from_git.setter
    def import_from_git(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "import_from_git", value)

    @_builtins.property
    @pulumi.getter(name="isStable")
    def is_stable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if given version for template to be set as stable.
        """
        return pulumi.get(self, "is_stable")

    @is_stable.setter
    def is_stable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_stable", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Variable
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Organization Identifier for the Entity
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project Identifier for the Entity
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="templateImportRequest")
    def template_import_request(self) -> Optional[pulumi.Input['TemplateTemplateImportRequestArgs']]:
        """
        Contains parameters for importing template.
        """
        return pulumi.get(self, "template_import_request")

    @template_import_request.setter
    def template_import_request(self, value: Optional[pulumi.Input['TemplateTemplateImportRequestArgs']]):
        pulumi.set(self, "template_import_request", value)

    @_builtins.property
    @pulumi.getter(name="templateYaml")
    def template_yaml(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Yaml for creating new Template. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}. For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as connectorRef: org.connectorId.
        """
        return pulumi.get(self, "template_yaml")

    @template_yaml.setter
    def template_yaml(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_yaml", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version Label for Template.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("harness:platform/template:Template")
class Template(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 git_details: Optional[pulumi.Input[Union['TemplateGitDetailsArgs', 'TemplateGitDetailsArgsDict']]] = None,
                 git_import_details: Optional[pulumi.Input[Union['TemplateGitImportDetailsArgs', 'TemplateGitImportDetailsArgsDict']]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 import_from_git: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_stable: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 template_import_request: Optional[pulumi.Input[Union['TemplateTemplateImportRequestArgs', 'TemplateTemplateImportRequestArgsDict']]] = None,
                 template_yaml: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for creating a Template. Description field is deprecated

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level template

        ```sh
        $ pulumi import harness:platform/template:Template example <template_id>
        ```

        Import org level template

        ```sh
        $ pulumi import harness:platform/template:Template example <ord_id>/<template_id>
        ```

        Import project level template

        ```sh
        $ pulumi import harness:platform/template:Template example <org_id>/<project_id>/<template_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comments: Specify comment with respect to changes.
        :param pulumi.Input[_builtins.str] description: Description of the entity. Description field is deprecated
        :param pulumi.Input[_builtins.bool] force_delete: Enable this flag for force deletion of template. It will delete the Harness entity even if your pipelines or other entities reference it
        :param pulumi.Input[Union['TemplateGitDetailsArgs', 'TemplateGitDetailsArgsDict']] git_details: Contains parameters related to creating an Entity for Git Experience.
        :param pulumi.Input[Union['TemplateGitImportDetailsArgs', 'TemplateGitImportDetailsArgsDict']] git_import_details: Contains Git Information for importing entities from Git
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource. Cannot be changed once the resource is created. Must match the identifier in the template_yaml.
        :param pulumi.Input[_builtins.bool] import_from_git: Flag to set if importing from Git
        :param pulumi.Input[_builtins.bool] is_stable: True if given version for template to be set as stable.
        :param pulumi.Input[_builtins.str] name: Name of the Variable
        :param pulumi.Input[_builtins.str] org_id: Organization Identifier for the Entity
        :param pulumi.Input[_builtins.str] project_id: Project Identifier for the Entity
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[Union['TemplateTemplateImportRequestArgs', 'TemplateTemplateImportRequestArgsDict']] template_import_request: Contains parameters for importing template.
        :param pulumi.Input[_builtins.str] template_yaml: Yaml for creating new Template. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}. For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as connectorRef: org.connectorId.
        :param pulumi.Input[_builtins.str] version: Version Label for Template.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating a Template. Description field is deprecated

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level template

        ```sh
        $ pulumi import harness:platform/template:Template example <template_id>
        ```

        Import org level template

        ```sh
        $ pulumi import harness:platform/template:Template example <ord_id>/<template_id>
        ```

        Import project level template

        ```sh
        $ pulumi import harness:platform/template:Template example <org_id>/<project_id>/<template_id>
        ```

        :param str resource_name: The name of the resource.
        :param TemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 git_details: Optional[pulumi.Input[Union['TemplateGitDetailsArgs', 'TemplateGitDetailsArgsDict']]] = None,
                 git_import_details: Optional[pulumi.Input[Union['TemplateGitImportDetailsArgs', 'TemplateGitImportDetailsArgsDict']]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 import_from_git: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_stable: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 template_import_request: Optional[pulumi.Input[Union['TemplateTemplateImportRequestArgs', 'TemplateTemplateImportRequestArgsDict']]] = None,
                 template_yaml: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TemplateArgs.__new__(TemplateArgs)

            __props__.__dict__["comments"] = comments
            __props__.__dict__["description"] = description
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["git_details"] = git_details
            __props__.__dict__["git_import_details"] = git_import_details
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["import_from_git"] = import_from_git
            __props__.__dict__["is_stable"] = is_stable
            __props__.__dict__["name"] = name
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["template_import_request"] = template_import_request
            __props__.__dict__["template_yaml"] = template_yaml
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
        super(Template, __self__).__init__(
            'harness:platform/template:Template',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comments: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            git_details: Optional[pulumi.Input[Union['TemplateGitDetailsArgs', 'TemplateGitDetailsArgsDict']]] = None,
            git_import_details: Optional[pulumi.Input[Union['TemplateGitImportDetailsArgs', 'TemplateGitImportDetailsArgsDict']]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            import_from_git: Optional[pulumi.Input[_builtins.bool]] = None,
            is_stable: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            template_import_request: Optional[pulumi.Input[Union['TemplateTemplateImportRequestArgs', 'TemplateTemplateImportRequestArgsDict']]] = None,
            template_yaml: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'Template':
        """
        Get an existing Template resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comments: Specify comment with respect to changes.
        :param pulumi.Input[_builtins.str] description: Description of the entity. Description field is deprecated
        :param pulumi.Input[_builtins.bool] force_delete: Enable this flag for force deletion of template. It will delete the Harness entity even if your pipelines or other entities reference it
        :param pulumi.Input[Union['TemplateGitDetailsArgs', 'TemplateGitDetailsArgsDict']] git_details: Contains parameters related to creating an Entity for Git Experience.
        :param pulumi.Input[Union['TemplateGitImportDetailsArgs', 'TemplateGitImportDetailsArgsDict']] git_import_details: Contains Git Information for importing entities from Git
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource. Cannot be changed once the resource is created. Must match the identifier in the template_yaml.
        :param pulumi.Input[_builtins.bool] import_from_git: Flag to set if importing from Git
        :param pulumi.Input[_builtins.bool] is_stable: True if given version for template to be set as stable.
        :param pulumi.Input[_builtins.str] name: Name of the Variable
        :param pulumi.Input[_builtins.str] org_id: Organization Identifier for the Entity
        :param pulumi.Input[_builtins.str] project_id: Project Identifier for the Entity
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[Union['TemplateTemplateImportRequestArgs', 'TemplateTemplateImportRequestArgsDict']] template_import_request: Contains parameters for importing template.
        :param pulumi.Input[_builtins.str] template_yaml: Yaml for creating new Template. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}. For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as connectorRef: org.connectorId.
        :param pulumi.Input[_builtins.str] version: Version Label for Template.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TemplateState.__new__(_TemplateState)

        __props__.__dict__["comments"] = comments
        __props__.__dict__["description"] = description
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["git_details"] = git_details
        __props__.__dict__["git_import_details"] = git_import_details
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["import_from_git"] = import_from_git
        __props__.__dict__["is_stable"] = is_stable
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["template_import_request"] = template_import_request
        __props__.__dict__["template_yaml"] = template_yaml
        __props__.__dict__["version"] = version
        return Template(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def comments(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specify comment with respect to changes.
        """
        return pulumi.get(self, "comments")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""description field is deprecated""")
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the entity. Description field is deprecated
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable this flag for force deletion of template. It will delete the Harness entity even if your pipelines or other entities reference it
        """
        return pulumi.get(self, "force_delete")

    @_builtins.property
    @pulumi.getter(name="gitDetails")
    def git_details(self) -> pulumi.Output['outputs.TemplateGitDetails']:
        """
        Contains parameters related to creating an Entity for Git Experience.
        """
        return pulumi.get(self, "git_details")

    @_builtins.property
    @pulumi.getter(name="gitImportDetails")
    def git_import_details(self) -> pulumi.Output[Optional['outputs.TemplateGitImportDetails']]:
        """
        Contains Git Information for importing entities from Git
        """
        return pulumi.get(self, "git_import_details")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the resource. Cannot be changed once the resource is created. Must match the identifier in the template_yaml.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="importFromGit")
    def import_from_git(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to set if importing from Git
        """
        return pulumi.get(self, "import_from_git")

    @_builtins.property
    @pulumi.getter(name="isStable")
    def is_stable(self) -> pulumi.Output[_builtins.bool]:
        """
        True if given version for template to be set as stable.
        """
        return pulumi.get(self, "is_stable")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Variable
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Organization Identifier for the Entity
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Project Identifier for the Entity
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="templateImportRequest")
    def template_import_request(self) -> pulumi.Output[Optional['outputs.TemplateTemplateImportRequest']]:
        """
        Contains parameters for importing template.
        """
        return pulumi.get(self, "template_import_request")

    @_builtins.property
    @pulumi.getter(name="templateYaml")
    def template_yaml(self) -> pulumi.Output[_builtins.str]:
        """
        Yaml for creating new Template. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}. For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as connectorRef: org.connectorId.
        """
        return pulumi.get(self, "template_yaml")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        Version Label for Template.
        """
        return pulumi.get(self, "version")

