# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PlatformApiKeyArgs', 'PlatformApiKey']

@pulumi.input_type
class PlatformApiKeyArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 apikey_type: pulumi.Input[_builtins.str],
                 identifier: pulumi.Input[_builtins.str],
                 parent_id: pulumi.Input[_builtins.str],
                 default_time_to_expire_token: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a PlatformApiKey resource.
        :param pulumi.Input[_builtins.str] account_id: Account Identifier for the Entity
        :param pulumi.Input[_builtins.str] apikey_type: Type of the API Key
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] parent_id: Parent Entity Identifier of the API Key
        :param pulumi.Input[_builtins.int] default_time_to_expire_token: Default expiration time of the Token within API Key
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "apikey_type", apikey_type)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "parent_id", parent_id)
        if default_time_to_expire_token is not None:
            pulumi.set(__self__, "default_time_to_expire_token", default_time_to_expire_token)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Account Identifier for the Entity
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="apikeyType")
    def apikey_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the API Key
        """
        return pulumi.get(self, "apikey_type")

    @apikey_type.setter
    def apikey_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "apikey_type", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Input[_builtins.str]:
        """
        Parent Entity Identifier of the API Key
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "parent_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultTimeToExpireToken")
    def default_time_to_expire_token(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default expiration time of the Token within API Key
        """
        return pulumi.get(self, "default_time_to_expire_token")

    @default_time_to_expire_token.setter
    def default_time_to_expire_token(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_time_to_expire_token", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _PlatformApiKeyState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 apikey_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_time_to_expire_token: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering PlatformApiKey resources.
        :param pulumi.Input[_builtins.str] account_id: Account Identifier for the Entity
        :param pulumi.Input[_builtins.str] apikey_type: Type of the API Key
        :param pulumi.Input[_builtins.int] default_time_to_expire_token: Default expiration time of the Token within API Key
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] parent_id: Parent Entity Identifier of the API Key
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if apikey_type is not None:
            pulumi.set(__self__, "apikey_type", apikey_type)
        if default_time_to_expire_token is not None:
            pulumi.set(__self__, "default_time_to_expire_token", default_time_to_expire_token)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account Identifier for the Entity
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="apikeyType")
    def apikey_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the API Key
        """
        return pulumi.get(self, "apikey_type")

    @apikey_type.setter
    def apikey_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "apikey_type", value)

    @_builtins.property
    @pulumi.getter(name="defaultTimeToExpireToken")
    def default_time_to_expire_token(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default expiration time of the Token within API Key
        """
        return pulumi.get(self, "default_time_to_expire_token")

    @default_time_to_expire_token.setter
    def default_time_to_expire_token(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_time_to_expire_token", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Parent Entity Identifier of the API Key
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("harness:index/platformApiKey:PlatformApiKey")
class PlatformApiKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 apikey_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_time_to_expire_token: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for creating ApiKeys.

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level apikey

        ```sh
        $ pulumi import harness:index/platformApiKey:PlatformApiKey harness_platform_apikey <parent_id>/<apikey_id>/<apikey_type>
        ```

        Import org level apikey

        ```sh
        $ pulumi import harness:index/platformApiKey:PlatformApiKey harness_platform_apikey <org_id>/<parent_id>/<apikey_id>/<apikey_type>
        ```

        Import project level apikey

        ```sh
        $ pulumi import harness:index/platformApiKey:PlatformApiKey harness_platform_apikey <org_id>/<project_id>/<parent_id>/<apikey_id>/<apikey_type>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account Identifier for the Entity
        :param pulumi.Input[_builtins.str] apikey_type: Type of the API Key
        :param pulumi.Input[_builtins.int] default_time_to_expire_token: Default expiration time of the Token within API Key
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] parent_id: Parent Entity Identifier of the API Key
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PlatformApiKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating ApiKeys.

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level apikey

        ```sh
        $ pulumi import harness:index/platformApiKey:PlatformApiKey harness_platform_apikey <parent_id>/<apikey_id>/<apikey_type>
        ```

        Import org level apikey

        ```sh
        $ pulumi import harness:index/platformApiKey:PlatformApiKey harness_platform_apikey <org_id>/<parent_id>/<apikey_id>/<apikey_type>
        ```

        Import project level apikey

        ```sh
        $ pulumi import harness:index/platformApiKey:PlatformApiKey harness_platform_apikey <org_id>/<project_id>/<parent_id>/<apikey_id>/<apikey_type>
        ```

        :param str resource_name: The name of the resource.
        :param PlatformApiKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PlatformApiKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 apikey_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_time_to_expire_token: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PlatformApiKeyArgs.__new__(PlatformApiKeyArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if apikey_type is None and not opts.urn:
                raise TypeError("Missing required property 'apikey_type'")
            __props__.__dict__["apikey_type"] = apikey_type
            __props__.__dict__["default_time_to_expire_token"] = default_time_to_expire_token
            __props__.__dict__["description"] = description
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["name"] = name
            __props__.__dict__["org_id"] = org_id
            if parent_id is None and not opts.urn:
                raise TypeError("Missing required property 'parent_id'")
            __props__.__dict__["parent_id"] = parent_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["tags"] = tags
        super(PlatformApiKey, __self__).__init__(
            'harness:index/platformApiKey:PlatformApiKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            apikey_type: Optional[pulumi.Input[_builtins.str]] = None,
            default_time_to_expire_token: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            parent_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'PlatformApiKey':
        """
        Get an existing PlatformApiKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account Identifier for the Entity
        :param pulumi.Input[_builtins.str] apikey_type: Type of the API Key
        :param pulumi.Input[_builtins.int] default_time_to_expire_token: Default expiration time of the Token within API Key
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] parent_id: Parent Entity Identifier of the API Key
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PlatformApiKeyState.__new__(_PlatformApiKeyState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["apikey_type"] = apikey_type
        __props__.__dict__["default_time_to_expire_token"] = default_time_to_expire_token
        __props__.__dict__["description"] = description
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["parent_id"] = parent_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["tags"] = tags
        return PlatformApiKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Account Identifier for the Entity
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="apikeyType")
    def apikey_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the API Key
        """
        return pulumi.get(self, "apikey_type")

    @_builtins.property
    @pulumi.getter(name="defaultTimeToExpireToken")
    def default_time_to_expire_token(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Default expiration time of the Token within API Key
        """
        return pulumi.get(self, "default_time_to_expire_token")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Output[_builtins.str]:
        """
        Parent Entity Identifier of the API Key
        """
        return pulumi.get(self, "parent_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

