# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DiscoveryAgentArgs', 'DiscoveryAgent']

@pulumi.input_type
class DiscoveryAgentArgs:
    def __init__(__self__, *,
                 configs: pulumi.Input[Sequence[pulumi.Input['DiscoveryAgentConfigArgs']]],
                 environment_identifier: pulumi.Input[_builtins.str],
                 infra_identifier: pulumi.Input[_builtins.str],
                 correlation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 installation_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 permanent_installation: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 webhook_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DiscoveryAgent resource.
        :param pulumi.Input[Sequence[pulumi.Input['DiscoveryAgentConfigArgs']]] configs: Configuration for the agent. This is a required field.
        :param pulumi.Input[_builtins.str] environment_identifier: The environment identifier of the agent. This is a required field.
        :param pulumi.Input[_builtins.str] infra_identifier: The infrastructure identifier of the agent. This is a required field.
        :param pulumi.Input[_builtins.str] correlation_id: Correlation ID for the agent.
        :param pulumi.Input[_builtins.str] installation_type: Type of installation for the agent.
        :param pulumi.Input[_builtins.str] name: The name of the agent. This is a required field.
        :param pulumi.Input[_builtins.str] org_identifier: The organization identifier of the agent. Must be 1-64 characters and contain only alphanumeric characters, hyphens, or underscores.
        :param pulumi.Input[_builtins.bool] permanent_installation: Whether this is a permanent installation.
        :param pulumi.Input[_builtins.str] project_identifier: The project identifier of the agent. Must be 1-64 characters and contain only alphanumeric characters, hyphens, or underscores.
        :param pulumi.Input[_builtins.str] webhook_url: Webhook URL for the agent.
        """
        pulumi.set(__self__, "configs", configs)
        pulumi.set(__self__, "environment_identifier", environment_identifier)
        pulumi.set(__self__, "infra_identifier", infra_identifier)
        if correlation_id is not None:
            pulumi.set(__self__, "correlation_id", correlation_id)
        if installation_type is not None:
            pulumi.set(__self__, "installation_type", installation_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_identifier is not None:
            pulumi.set(__self__, "org_identifier", org_identifier)
        if permanent_installation is not None:
            pulumi.set(__self__, "permanent_installation", permanent_installation)
        if project_identifier is not None:
            pulumi.set(__self__, "project_identifier", project_identifier)
        if webhook_url is not None:
            pulumi.set(__self__, "webhook_url", webhook_url)

    @_builtins.property
    @pulumi.getter
    def configs(self) -> pulumi.Input[Sequence[pulumi.Input['DiscoveryAgentConfigArgs']]]:
        """
        Configuration for the agent. This is a required field.
        """
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: pulumi.Input[Sequence[pulumi.Input['DiscoveryAgentConfigArgs']]]):
        pulumi.set(self, "configs", value)

    @_builtins.property
    @pulumi.getter(name="environmentIdentifier")
    def environment_identifier(self) -> pulumi.Input[_builtins.str]:
        """
        The environment identifier of the agent. This is a required field.
        """
        return pulumi.get(self, "environment_identifier")

    @environment_identifier.setter
    def environment_identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "environment_identifier", value)

    @_builtins.property
    @pulumi.getter(name="infraIdentifier")
    def infra_identifier(self) -> pulumi.Input[_builtins.str]:
        """
        The infrastructure identifier of the agent. This is a required field.
        """
        return pulumi.get(self, "infra_identifier")

    @infra_identifier.setter
    def infra_identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "infra_identifier", value)

    @_builtins.property
    @pulumi.getter(name="correlationId")
    def correlation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Correlation ID for the agent.
        """
        return pulumi.get(self, "correlation_id")

    @correlation_id.setter
    def correlation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "correlation_id", value)

    @_builtins.property
    @pulumi.getter(name="installationType")
    def installation_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of installation for the agent.
        """
        return pulumi.get(self, "installation_type")

    @installation_type.setter
    def installation_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "installation_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the agent. This is a required field.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgIdentifier")
    def org_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organization identifier of the agent. Must be 1-64 characters and contain only alphanumeric characters, hyphens, or underscores.
        """
        return pulumi.get(self, "org_identifier")

    @org_identifier.setter
    def org_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_identifier", value)

    @_builtins.property
    @pulumi.getter(name="permanentInstallation")
    def permanent_installation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this is a permanent installation.
        """
        return pulumi.get(self, "permanent_installation")

    @permanent_installation.setter
    def permanent_installation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "permanent_installation", value)

    @_builtins.property
    @pulumi.getter(name="projectIdentifier")
    def project_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project identifier of the agent. Must be 1-64 characters and contain only alphanumeric characters, hyphens, or underscores.
        """
        return pulumi.get(self, "project_identifier")

    @project_identifier.setter
    def project_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_identifier", value)

    @_builtins.property
    @pulumi.getter(name="webhookUrl")
    def webhook_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Webhook URL for the agent.
        """
        return pulumi.get(self, "webhook_url")

    @webhook_url.setter
    def webhook_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "webhook_url", value)


@pulumi.input_type
class _DiscoveryAgentState:
    def __init__(__self__, *,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input['DiscoveryAgentConfigArgs']]]] = None,
                 correlation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[_builtins.str]] = None,
                 infra_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 installation_details: Optional[pulumi.Input[Sequence[pulumi.Input['DiscoveryAgentInstallationDetailArgs']]]] = None,
                 installation_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_map_count: Optional[pulumi.Input[_builtins.int]] = None,
                 org_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 permanent_installation: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 removed: Optional[pulumi.Input[_builtins.bool]] = None,
                 removed_at: Optional[pulumi.Input[_builtins.str]] = None,
                 service_count: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_by: Optional[pulumi.Input[_builtins.str]] = None,
                 webhook_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DiscoveryAgent resources.
        :param pulumi.Input[Sequence[pulumi.Input['DiscoveryAgentConfigArgs']]] configs: Configuration for the agent. This is a required field.
        :param pulumi.Input[_builtins.str] correlation_id: Correlation ID for the agent.
        :param pulumi.Input[_builtins.str] created_at: Timestamp when the agent was created.
        :param pulumi.Input[_builtins.str] created_by: User who created the agent.
        :param pulumi.Input[_builtins.str] description: Description of the agent.
        :param pulumi.Input[_builtins.str] environment_identifier: The environment identifier of the agent. This is a required field.
        :param pulumi.Input[_builtins.str] identity: The unique identity of the agent.
        :param pulumi.Input[_builtins.str] infra_identifier: The infrastructure identifier of the agent. This is a required field.
        :param pulumi.Input[Sequence[pulumi.Input['DiscoveryAgentInstallationDetailArgs']]] installation_details: Installation details of the agent.
        :param pulumi.Input[_builtins.str] installation_type: Type of installation for the agent.
        :param pulumi.Input[_builtins.str] name: The name of the agent. This is a required field.
        :param pulumi.Input[_builtins.int] network_map_count: Number of network maps associated with this agent.
        :param pulumi.Input[_builtins.str] org_identifier: The organization identifier of the agent. Must be 1-64 characters and contain only alphanumeric characters, hyphens, or underscores.
        :param pulumi.Input[_builtins.bool] permanent_installation: Whether this is a permanent installation.
        :param pulumi.Input[_builtins.str] project_identifier: The project identifier of the agent. Must be 1-64 characters and contain only alphanumeric characters, hyphens, or underscores.
        :param pulumi.Input[_builtins.bool] removed: Whether the agent has been removed.
        :param pulumi.Input[_builtins.str] removed_at: Timestamp when the agent was removed.
        :param pulumi.Input[_builtins.int] service_count: Number of services managed by this agent.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of resource tags for the agent.
        :param pulumi.Input[_builtins.str] updated_at: Timestamp when the agent was last updated.
        :param pulumi.Input[_builtins.str] updated_by: User who last updated the agent.
        :param pulumi.Input[_builtins.str] webhook_url: Webhook URL for the agent.
        """
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if correlation_id is not None:
            pulumi.set(__self__, "correlation_id", correlation_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_identifier is not None:
            pulumi.set(__self__, "environment_identifier", environment_identifier)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if infra_identifier is not None:
            pulumi.set(__self__, "infra_identifier", infra_identifier)
        if installation_details is not None:
            pulumi.set(__self__, "installation_details", installation_details)
        if installation_type is not None:
            pulumi.set(__self__, "installation_type", installation_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_map_count is not None:
            pulumi.set(__self__, "network_map_count", network_map_count)
        if org_identifier is not None:
            pulumi.set(__self__, "org_identifier", org_identifier)
        if permanent_installation is not None:
            pulumi.set(__self__, "permanent_installation", permanent_installation)
        if project_identifier is not None:
            pulumi.set(__self__, "project_identifier", project_identifier)
        if removed is not None:
            pulumi.set(__self__, "removed", removed)
        if removed_at is not None:
            pulumi.set(__self__, "removed_at", removed_at)
        if service_count is not None:
            pulumi.set(__self__, "service_count", service_count)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if updated_by is not None:
            pulumi.set(__self__, "updated_by", updated_by)
        if webhook_url is not None:
            pulumi.set(__self__, "webhook_url", webhook_url)

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiscoveryAgentConfigArgs']]]]:
        """
        Configuration for the agent. This is a required field.
        """
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiscoveryAgentConfigArgs']]]]):
        pulumi.set(self, "configs", value)

    @_builtins.property
    @pulumi.getter(name="correlationId")
    def correlation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Correlation ID for the agent.
        """
        return pulumi.get(self, "correlation_id")

    @correlation_id.setter
    def correlation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "correlation_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the agent was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User who created the agent.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the agent.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="environmentIdentifier")
    def environment_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The environment identifier of the agent. This is a required field.
        """
        return pulumi.get(self, "environment_identifier")

    @environment_identifier.setter
    def environment_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment_identifier", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identity of the agent.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="infraIdentifier")
    def infra_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The infrastructure identifier of the agent. This is a required field.
        """
        return pulumi.get(self, "infra_identifier")

    @infra_identifier.setter
    def infra_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "infra_identifier", value)

    @_builtins.property
    @pulumi.getter(name="installationDetails")
    def installation_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiscoveryAgentInstallationDetailArgs']]]]:
        """
        Installation details of the agent.
        """
        return pulumi.get(self, "installation_details")

    @installation_details.setter
    def installation_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiscoveryAgentInstallationDetailArgs']]]]):
        pulumi.set(self, "installation_details", value)

    @_builtins.property
    @pulumi.getter(name="installationType")
    def installation_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of installation for the agent.
        """
        return pulumi.get(self, "installation_type")

    @installation_type.setter
    def installation_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "installation_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the agent. This is a required field.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkMapCount")
    def network_map_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of network maps associated with this agent.
        """
        return pulumi.get(self, "network_map_count")

    @network_map_count.setter
    def network_map_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "network_map_count", value)

    @_builtins.property
    @pulumi.getter(name="orgIdentifier")
    def org_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organization identifier of the agent. Must be 1-64 characters and contain only alphanumeric characters, hyphens, or underscores.
        """
        return pulumi.get(self, "org_identifier")

    @org_identifier.setter
    def org_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_identifier", value)

    @_builtins.property
    @pulumi.getter(name="permanentInstallation")
    def permanent_installation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this is a permanent installation.
        """
        return pulumi.get(self, "permanent_installation")

    @permanent_installation.setter
    def permanent_installation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "permanent_installation", value)

    @_builtins.property
    @pulumi.getter(name="projectIdentifier")
    def project_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project identifier of the agent. Must be 1-64 characters and contain only alphanumeric characters, hyphens, or underscores.
        """
        return pulumi.get(self, "project_identifier")

    @project_identifier.setter
    def project_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_identifier", value)

    @_builtins.property
    @pulumi.getter
    def removed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the agent has been removed.
        """
        return pulumi.get(self, "removed")

    @removed.setter
    def removed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "removed", value)

    @_builtins.property
    @pulumi.getter(name="removedAt")
    def removed_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the agent was removed.
        """
        return pulumi.get(self, "removed_at")

    @removed_at.setter
    def removed_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "removed_at", value)

    @_builtins.property
    @pulumi.getter(name="serviceCount")
    def service_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of services managed by this agent.
        """
        return pulumi.get(self, "service_count")

    @service_count.setter
    def service_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "service_count", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of resource tags for the agent.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the agent was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User who last updated the agent.
        """
        return pulumi.get(self, "updated_by")

    @updated_by.setter
    def updated_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_by", value)

    @_builtins.property
    @pulumi.getter(name="webhookUrl")
    def webhook_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Webhook URL for the agent.
        """
        return pulumi.get(self, "webhook_url")

    @webhook_url.setter
    def webhook_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "webhook_url", value)


@pulumi.type_token("harness:service/discoveryAgent:DiscoveryAgent")
class DiscoveryAgent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiscoveryAgentConfigArgs', 'DiscoveryAgentConfigArgsDict']]]]] = None,
                 correlation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 infra_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 installation_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 permanent_installation: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 webhook_url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing a Harness Service Discovery Agent.

        This resource allows you to create, read, update, and delete a Service Discovery Agent in Harness.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.service.DiscoveryAgent("example",
            name="ExampleAgent",
            org_identifier="your_org_id",
            project_identifier="your_project_id",
            environment_identifier="your_environment_id",
            infra_identifier="your_infra_id",
            configs=[{
                "collector_image": "harness/service-discovery-collector:main-latest",
                "log_watcher_image": "harness/chaos-log-watcher:main-latest",
                "kubernetes": [{
                    "namespace": "harness-sd",
                }],
            }])
        ```

        ### Additional Examples

        ```python
        import pulumi
        import pulumi_harness as harness

        # Create a new service discovery agent with minimal configuration
        example = harness.service.DiscoveryAgent("example",
            name="example-agent",
            org_identifier=org_identifier,
            project_identifier=project_identifier,
            environment_identifier=environment_identifier,
            infra_identifier="example-infra",
            configs=[{
                "kubernetes": [{
                    "namespace": "harness-sd",
                }],
            }])
        # Create a new service discovery agent with node agent enabled
        node_agent = harness.service.DiscoveryAgent("node_agent",
            name="node-agent-example",
            org_identifier=org_identifier,
            project_identifier=project_identifier,
            environment_identifier=environment_identifier,
            infra_identifier="node-agent-example",
            configs=[{
                "kubernetes": [{
                    "namespace": "harness-sd",
                }],
                "datas": [{
                    "enable_node_agent": True,
                }],
            }])
        # Create a new service discovery agent with full configuration
        full_config = harness.service.DiscoveryAgent("full_config",
            name="full-config-example",
            org_identifier=org_identifier,
            project_identifier=project_identifier,
            environment_identifier=environment_identifier,
            infra_identifier="full-config-example",
            permanent_installation=False,
            correlation_id="full-config-correlation-123",
            configs=[{
                "collector_image": "harness/service-discovery-collector:main-latest",
                "log_watcher_image": "harness/chaos-log-watcher:main-latest",
                "skip_secure_verify": False,
                "kubernetes": [{
                    "namespace": "harness-sd",
                    "service_account": "harness-sd-sa",
                    "image_pull_policy": "IfNotPresent",
                    "run_as_user": 2000,
                    "run_as_group": 2000,
                    "labels": {
                        "app": "service-discovery",
                        "env": "dev",
                    },
                    "annotations": {
                        "example.com/annotation": "value",
                    },
                    "node_selector": {
                        "kubernetes.io/os": "linux",
                    },
                    "resources": [{
                        "limits": {
                            "cpu": "500m",
                            "memory": "512Mi",
                        },
                        "requests": {
                            "cpu": "250m",
                            "memory": "256Mi",
                        },
                    }],
                    "tolerations": [{
                        "key": "key1",
                        "operator": "Equal",
                        "value": "value1",
                        "effect": "NoSchedule",
                    }],
                }],
                "datas": [{
                    "enable_node_agent": True,
                    "node_agent_selector": "node-role.kubernetes.io/worker=",
                    "enable_batch_resources": True,
                    "enable_orphaned_pod": True,
                    "namespace_selector": "environment=dev",
                    "collection_window_in_min": 15,
                    "blacklisted_namespaces": [
                        "kube-system",
                        "kube-public",
                    ],
                    "observed_namespaces": [
                        "default",
                        "harness",
                    ],
                    "crons": [{
                        "expression": "0/10 * * * *",
                    }],
                }],
                "mtls": [{
                    "cert_path": "/etc/certs/tls.crt",
                    "key_path": "/etc/certs/tls.key",
                    "secret_name": "mtls-secret",
                    "url": "https://mtls.example.com:8443",
                }],
                "proxies": [{
                    "http_proxy": "http://proxy.example.com:8080",
                    "https_proxy": "https://proxy.example.com:8080",
                    "no_proxy": "localhost,127.0.0.1,.svc,.cluster.local",
                    "url": "https://proxy.example.com",
                }],
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Import Project level Service Discovery Agent

        Account and Org level agents are not supported yet

        ```sh
        $ pulumi import harness:service/discoveryAgent:DiscoveryAgent example <org_identifier>/<project_identifier>/<environment_identifier>/<infra_identifier>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DiscoveryAgentConfigArgs', 'DiscoveryAgentConfigArgsDict']]]] configs: Configuration for the agent. This is a required field.
        :param pulumi.Input[_builtins.str] correlation_id: Correlation ID for the agent.
        :param pulumi.Input[_builtins.str] environment_identifier: The environment identifier of the agent. This is a required field.
        :param pulumi.Input[_builtins.str] infra_identifier: The infrastructure identifier of the agent. This is a required field.
        :param pulumi.Input[_builtins.str] installation_type: Type of installation for the agent.
        :param pulumi.Input[_builtins.str] name: The name of the agent. This is a required field.
        :param pulumi.Input[_builtins.str] org_identifier: The organization identifier of the agent. Must be 1-64 characters and contain only alphanumeric characters, hyphens, or underscores.
        :param pulumi.Input[_builtins.bool] permanent_installation: Whether this is a permanent installation.
        :param pulumi.Input[_builtins.str] project_identifier: The project identifier of the agent. Must be 1-64 characters and contain only alphanumeric characters, hyphens, or underscores.
        :param pulumi.Input[_builtins.str] webhook_url: Webhook URL for the agent.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DiscoveryAgentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing a Harness Service Discovery Agent.

        This resource allows you to create, read, update, and delete a Service Discovery Agent in Harness.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.service.DiscoveryAgent("example",
            name="ExampleAgent",
            org_identifier="your_org_id",
            project_identifier="your_project_id",
            environment_identifier="your_environment_id",
            infra_identifier="your_infra_id",
            configs=[{
                "collector_image": "harness/service-discovery-collector:main-latest",
                "log_watcher_image": "harness/chaos-log-watcher:main-latest",
                "kubernetes": [{
                    "namespace": "harness-sd",
                }],
            }])
        ```

        ### Additional Examples

        ```python
        import pulumi
        import pulumi_harness as harness

        # Create a new service discovery agent with minimal configuration
        example = harness.service.DiscoveryAgent("example",
            name="example-agent",
            org_identifier=org_identifier,
            project_identifier=project_identifier,
            environment_identifier=environment_identifier,
            infra_identifier="example-infra",
            configs=[{
                "kubernetes": [{
                    "namespace": "harness-sd",
                }],
            }])
        # Create a new service discovery agent with node agent enabled
        node_agent = harness.service.DiscoveryAgent("node_agent",
            name="node-agent-example",
            org_identifier=org_identifier,
            project_identifier=project_identifier,
            environment_identifier=environment_identifier,
            infra_identifier="node-agent-example",
            configs=[{
                "kubernetes": [{
                    "namespace": "harness-sd",
                }],
                "datas": [{
                    "enable_node_agent": True,
                }],
            }])
        # Create a new service discovery agent with full configuration
        full_config = harness.service.DiscoveryAgent("full_config",
            name="full-config-example",
            org_identifier=org_identifier,
            project_identifier=project_identifier,
            environment_identifier=environment_identifier,
            infra_identifier="full-config-example",
            permanent_installation=False,
            correlation_id="full-config-correlation-123",
            configs=[{
                "collector_image": "harness/service-discovery-collector:main-latest",
                "log_watcher_image": "harness/chaos-log-watcher:main-latest",
                "skip_secure_verify": False,
                "kubernetes": [{
                    "namespace": "harness-sd",
                    "service_account": "harness-sd-sa",
                    "image_pull_policy": "IfNotPresent",
                    "run_as_user": 2000,
                    "run_as_group": 2000,
                    "labels": {
                        "app": "service-discovery",
                        "env": "dev",
                    },
                    "annotations": {
                        "example.com/annotation": "value",
                    },
                    "node_selector": {
                        "kubernetes.io/os": "linux",
                    },
                    "resources": [{
                        "limits": {
                            "cpu": "500m",
                            "memory": "512Mi",
                        },
                        "requests": {
                            "cpu": "250m",
                            "memory": "256Mi",
                        },
                    }],
                    "tolerations": [{
                        "key": "key1",
                        "operator": "Equal",
                        "value": "value1",
                        "effect": "NoSchedule",
                    }],
                }],
                "datas": [{
                    "enable_node_agent": True,
                    "node_agent_selector": "node-role.kubernetes.io/worker=",
                    "enable_batch_resources": True,
                    "enable_orphaned_pod": True,
                    "namespace_selector": "environment=dev",
                    "collection_window_in_min": 15,
                    "blacklisted_namespaces": [
                        "kube-system",
                        "kube-public",
                    ],
                    "observed_namespaces": [
                        "default",
                        "harness",
                    ],
                    "crons": [{
                        "expression": "0/10 * * * *",
                    }],
                }],
                "mtls": [{
                    "cert_path": "/etc/certs/tls.crt",
                    "key_path": "/etc/certs/tls.key",
                    "secret_name": "mtls-secret",
                    "url": "https://mtls.example.com:8443",
                }],
                "proxies": [{
                    "http_proxy": "http://proxy.example.com:8080",
                    "https_proxy": "https://proxy.example.com:8080",
                    "no_proxy": "localhost,127.0.0.1,.svc,.cluster.local",
                    "url": "https://proxy.example.com",
                }],
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Import Project level Service Discovery Agent

        Account and Org level agents are not supported yet

        ```sh
        $ pulumi import harness:service/discoveryAgent:DiscoveryAgent example <org_identifier>/<project_identifier>/<environment_identifier>/<infra_identifier>
        ```

        :param str resource_name: The name of the resource.
        :param DiscoveryAgentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DiscoveryAgentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiscoveryAgentConfigArgs', 'DiscoveryAgentConfigArgsDict']]]]] = None,
                 correlation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 infra_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 installation_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 permanent_installation: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 webhook_url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DiscoveryAgentArgs.__new__(DiscoveryAgentArgs)

            if configs is None and not opts.urn:
                raise TypeError("Missing required property 'configs'")
            __props__.__dict__["configs"] = configs
            __props__.__dict__["correlation_id"] = correlation_id
            if environment_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'environment_identifier'")
            __props__.__dict__["environment_identifier"] = environment_identifier
            if infra_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'infra_identifier'")
            __props__.__dict__["infra_identifier"] = infra_identifier
            __props__.__dict__["installation_type"] = installation_type
            __props__.__dict__["name"] = name
            __props__.__dict__["org_identifier"] = org_identifier
            __props__.__dict__["permanent_installation"] = permanent_installation
            __props__.__dict__["project_identifier"] = project_identifier
            __props__.__dict__["webhook_url"] = webhook_url
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["identity"] = None
            __props__.__dict__["installation_details"] = None
            __props__.__dict__["network_map_count"] = None
            __props__.__dict__["removed"] = None
            __props__.__dict__["removed_at"] = None
            __props__.__dict__["service_count"] = None
            __props__.__dict__["tags"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["updated_by"] = None
        super(DiscoveryAgent, __self__).__init__(
            'harness:service/discoveryAgent:DiscoveryAgent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiscoveryAgentConfigArgs', 'DiscoveryAgentConfigArgsDict']]]]] = None,
            correlation_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            environment_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[_builtins.str]] = None,
            infra_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            installation_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiscoveryAgentInstallationDetailArgs', 'DiscoveryAgentInstallationDetailArgsDict']]]]] = None,
            installation_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_map_count: Optional[pulumi.Input[_builtins.int]] = None,
            org_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            permanent_installation: Optional[pulumi.Input[_builtins.bool]] = None,
            project_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            removed: Optional[pulumi.Input[_builtins.bool]] = None,
            removed_at: Optional[pulumi.Input[_builtins.str]] = None,
            service_count: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            updated_by: Optional[pulumi.Input[_builtins.str]] = None,
            webhook_url: Optional[pulumi.Input[_builtins.str]] = None) -> 'DiscoveryAgent':
        """
        Get an existing DiscoveryAgent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DiscoveryAgentConfigArgs', 'DiscoveryAgentConfigArgsDict']]]] configs: Configuration for the agent. This is a required field.
        :param pulumi.Input[_builtins.str] correlation_id: Correlation ID for the agent.
        :param pulumi.Input[_builtins.str] created_at: Timestamp when the agent was created.
        :param pulumi.Input[_builtins.str] created_by: User who created the agent.
        :param pulumi.Input[_builtins.str] description: Description of the agent.
        :param pulumi.Input[_builtins.str] environment_identifier: The environment identifier of the agent. This is a required field.
        :param pulumi.Input[_builtins.str] identity: The unique identity of the agent.
        :param pulumi.Input[_builtins.str] infra_identifier: The infrastructure identifier of the agent. This is a required field.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DiscoveryAgentInstallationDetailArgs', 'DiscoveryAgentInstallationDetailArgsDict']]]] installation_details: Installation details of the agent.
        :param pulumi.Input[_builtins.str] installation_type: Type of installation for the agent.
        :param pulumi.Input[_builtins.str] name: The name of the agent. This is a required field.
        :param pulumi.Input[_builtins.int] network_map_count: Number of network maps associated with this agent.
        :param pulumi.Input[_builtins.str] org_identifier: The organization identifier of the agent. Must be 1-64 characters and contain only alphanumeric characters, hyphens, or underscores.
        :param pulumi.Input[_builtins.bool] permanent_installation: Whether this is a permanent installation.
        :param pulumi.Input[_builtins.str] project_identifier: The project identifier of the agent. Must be 1-64 characters and contain only alphanumeric characters, hyphens, or underscores.
        :param pulumi.Input[_builtins.bool] removed: Whether the agent has been removed.
        :param pulumi.Input[_builtins.str] removed_at: Timestamp when the agent was removed.
        :param pulumi.Input[_builtins.int] service_count: Number of services managed by this agent.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of resource tags for the agent.
        :param pulumi.Input[_builtins.str] updated_at: Timestamp when the agent was last updated.
        :param pulumi.Input[_builtins.str] updated_by: User who last updated the agent.
        :param pulumi.Input[_builtins.str] webhook_url: Webhook URL for the agent.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DiscoveryAgentState.__new__(_DiscoveryAgentState)

        __props__.__dict__["configs"] = configs
        __props__.__dict__["correlation_id"] = correlation_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["description"] = description
        __props__.__dict__["environment_identifier"] = environment_identifier
        __props__.__dict__["identity"] = identity
        __props__.__dict__["infra_identifier"] = infra_identifier
        __props__.__dict__["installation_details"] = installation_details
        __props__.__dict__["installation_type"] = installation_type
        __props__.__dict__["name"] = name
        __props__.__dict__["network_map_count"] = network_map_count
        __props__.__dict__["org_identifier"] = org_identifier
        __props__.__dict__["permanent_installation"] = permanent_installation
        __props__.__dict__["project_identifier"] = project_identifier
        __props__.__dict__["removed"] = removed
        __props__.__dict__["removed_at"] = removed_at
        __props__.__dict__["service_count"] = service_count
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["updated_by"] = updated_by
        __props__.__dict__["webhook_url"] = webhook_url
        return DiscoveryAgent(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def configs(self) -> pulumi.Output[Sequence['outputs.DiscoveryAgentConfig']]:
        """
        Configuration for the agent. This is a required field.
        """
        return pulumi.get(self, "configs")

    @_builtins.property
    @pulumi.getter(name="correlationId")
    def correlation_id(self) -> pulumi.Output[_builtins.str]:
        """
        Correlation ID for the agent.
        """
        return pulumi.get(self, "correlation_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the agent was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        User who created the agent.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description of the agent.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="environmentIdentifier")
    def environment_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The environment identifier of the agent. This is a required field.
        """
        return pulumi.get(self, "environment_identifier")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identity of the agent.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="infraIdentifier")
    def infra_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The infrastructure identifier of the agent. This is a required field.
        """
        return pulumi.get(self, "infra_identifier")

    @_builtins.property
    @pulumi.getter(name="installationDetails")
    def installation_details(self) -> pulumi.Output[Sequence['outputs.DiscoveryAgentInstallationDetail']]:
        """
        Installation details of the agent.
        """
        return pulumi.get(self, "installation_details")

    @_builtins.property
    @pulumi.getter(name="installationType")
    def installation_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Type of installation for the agent.
        """
        return pulumi.get(self, "installation_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the agent. This is a required field.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkMapCount")
    def network_map_count(self) -> pulumi.Output[_builtins.int]:
        """
        Number of network maps associated with this agent.
        """
        return pulumi.get(self, "network_map_count")

    @_builtins.property
    @pulumi.getter(name="orgIdentifier")
    def org_identifier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The organization identifier of the agent. Must be 1-64 characters and contain only alphanumeric characters, hyphens, or underscores.
        """
        return pulumi.get(self, "org_identifier")

    @_builtins.property
    @pulumi.getter(name="permanentInstallation")
    def permanent_installation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether this is a permanent installation.
        """
        return pulumi.get(self, "permanent_installation")

    @_builtins.property
    @pulumi.getter(name="projectIdentifier")
    def project_identifier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The project identifier of the agent. Must be 1-64 characters and contain only alphanumeric characters, hyphens, or underscores.
        """
        return pulumi.get(self, "project_identifier")

    @_builtins.property
    @pulumi.getter
    def removed(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the agent has been removed.
        """
        return pulumi.get(self, "removed")

    @_builtins.property
    @pulumi.getter(name="removedAt")
    def removed_at(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the agent was removed.
        """
        return pulumi.get(self, "removed_at")

    @_builtins.property
    @pulumi.getter(name="serviceCount")
    def service_count(self) -> pulumi.Output[_builtins.int]:
        """
        Number of services managed by this agent.
        """
        return pulumi.get(self, "service_count")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of resource tags for the agent.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the agent was last updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> pulumi.Output[_builtins.str]:
        """
        User who last updated the agent.
        """
        return pulumi.get(self, "updated_by")

    @_builtins.property
    @pulumi.getter(name="webhookUrl")
    def webhook_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Webhook URL for the agent.
        """
        return pulumi.get(self, "webhook_url")

