# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DiscoverySettingArgs', 'DiscoverySetting']

@pulumi.input_type
class DiscoverySettingArgs:
    def __init__(__self__, *,
                 correlation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_registry: Optional[pulumi.Input['DiscoverySettingImageRegistryArgs']] = None,
                 org_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 project_identifier: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DiscoverySetting resource.
        :param pulumi.Input[_builtins.str] correlation_id: Correlation ID for the request.
        :param pulumi.Input['DiscoverySettingImageRegistryArgs'] image_registry: Image registry configuration.
        :param pulumi.Input[_builtins.str] org_identifier: The organization identifier.
        :param pulumi.Input[_builtins.str] project_identifier: The project identifier.
        """
        if correlation_id is not None:
            pulumi.set(__self__, "correlation_id", correlation_id)
        if image_registry is not None:
            pulumi.set(__self__, "image_registry", image_registry)
        if org_identifier is not None:
            pulumi.set(__self__, "org_identifier", org_identifier)
        if project_identifier is not None:
            pulumi.set(__self__, "project_identifier", project_identifier)

    @_builtins.property
    @pulumi.getter(name="correlationId")
    def correlation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Correlation ID for the request.
        """
        return pulumi.get(self, "correlation_id")

    @correlation_id.setter
    def correlation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "correlation_id", value)

    @_builtins.property
    @pulumi.getter(name="imageRegistry")
    def image_registry(self) -> Optional[pulumi.Input['DiscoverySettingImageRegistryArgs']]:
        """
        Image registry configuration.
        """
        return pulumi.get(self, "image_registry")

    @image_registry.setter
    def image_registry(self, value: Optional[pulumi.Input['DiscoverySettingImageRegistryArgs']]):
        pulumi.set(self, "image_registry", value)

    @_builtins.property
    @pulumi.getter(name="orgIdentifier")
    def org_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organization identifier.
        """
        return pulumi.get(self, "org_identifier")

    @org_identifier.setter
    def org_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_identifier", value)

    @_builtins.property
    @pulumi.getter(name="projectIdentifier")
    def project_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project identifier.
        """
        return pulumi.get(self, "project_identifier")

    @project_identifier.setter
    def project_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_identifier", value)


@pulumi.input_type
class _DiscoverySettingState:
    def __init__(__self__, *,
                 correlation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 image_registry: Optional[pulumi.Input['DiscoverySettingImageRegistryArgs']] = None,
                 org_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 project_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DiscoverySetting resources.
        :param pulumi.Input[_builtins.str] correlation_id: Correlation ID for the request.
        :param pulumi.Input[_builtins.str] created_at: Timestamp when the setting was created.
        :param pulumi.Input['DiscoverySettingImageRegistryArgs'] image_registry: Image registry configuration.
        :param pulumi.Input[_builtins.str] org_identifier: The organization identifier.
        :param pulumi.Input[_builtins.str] project_identifier: The project identifier.
        :param pulumi.Input[_builtins.str] updated_at: Timestamp when the setting was last updated.
        """
        if correlation_id is not None:
            pulumi.set(__self__, "correlation_id", correlation_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if image_registry is not None:
            pulumi.set(__self__, "image_registry", image_registry)
        if org_identifier is not None:
            pulumi.set(__self__, "org_identifier", org_identifier)
        if project_identifier is not None:
            pulumi.set(__self__, "project_identifier", project_identifier)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="correlationId")
    def correlation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Correlation ID for the request.
        """
        return pulumi.get(self, "correlation_id")

    @correlation_id.setter
    def correlation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "correlation_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the setting was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="imageRegistry")
    def image_registry(self) -> Optional[pulumi.Input['DiscoverySettingImageRegistryArgs']]:
        """
        Image registry configuration.
        """
        return pulumi.get(self, "image_registry")

    @image_registry.setter
    def image_registry(self, value: Optional[pulumi.Input['DiscoverySettingImageRegistryArgs']]):
        pulumi.set(self, "image_registry", value)

    @_builtins.property
    @pulumi.getter(name="orgIdentifier")
    def org_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organization identifier.
        """
        return pulumi.get(self, "org_identifier")

    @org_identifier.setter
    def org_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_identifier", value)

    @_builtins.property
    @pulumi.getter(name="projectIdentifier")
    def project_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project identifier.
        """
        return pulumi.get(self, "project_identifier")

    @project_identifier.setter
    def project_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_identifier", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the setting was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("harness:service/discoverySetting:DiscoverySetting")
class DiscoverySetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 correlation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_registry: Optional[pulumi.Input[Union['DiscoverySettingImageRegistryArgs', 'DiscoverySettingImageRegistryArgsDict']]] = None,
                 org_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 project_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing service discovery settings.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        # Update image registry settings for service discovery
        example = harness.service.DiscoverySetting("example",
            org_identifier="sechaosworkshop",
            project_identifier="se1",
            image_registry={
                "account": "<account_name>",
                "server": "<registry_server>",
                "secrets": ["<secret_name>"],
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] correlation_id: Correlation ID for the request.
        :param pulumi.Input[Union['DiscoverySettingImageRegistryArgs', 'DiscoverySettingImageRegistryArgsDict']] image_registry: Image registry configuration.
        :param pulumi.Input[_builtins.str] org_identifier: The organization identifier.
        :param pulumi.Input[_builtins.str] project_identifier: The project identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DiscoverySettingArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing service discovery settings.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        # Update image registry settings for service discovery
        example = harness.service.DiscoverySetting("example",
            org_identifier="sechaosworkshop",
            project_identifier="se1",
            image_registry={
                "account": "<account_name>",
                "server": "<registry_server>",
                "secrets": ["<secret_name>"],
            })
        ```

        :param str resource_name: The name of the resource.
        :param DiscoverySettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DiscoverySettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 correlation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_registry: Optional[pulumi.Input[Union['DiscoverySettingImageRegistryArgs', 'DiscoverySettingImageRegistryArgsDict']]] = None,
                 org_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 project_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DiscoverySettingArgs.__new__(DiscoverySettingArgs)

            __props__.__dict__["correlation_id"] = correlation_id
            __props__.__dict__["image_registry"] = image_registry
            __props__.__dict__["org_identifier"] = org_identifier
            __props__.__dict__["project_identifier"] = project_identifier
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        super(DiscoverySetting, __self__).__init__(
            'harness:service/discoverySetting:DiscoverySetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            correlation_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            image_registry: Optional[pulumi.Input[Union['DiscoverySettingImageRegistryArgs', 'DiscoverySettingImageRegistryArgsDict']]] = None,
            org_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            project_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'DiscoverySetting':
        """
        Get an existing DiscoverySetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] correlation_id: Correlation ID for the request.
        :param pulumi.Input[_builtins.str] created_at: Timestamp when the setting was created.
        :param pulumi.Input[Union['DiscoverySettingImageRegistryArgs', 'DiscoverySettingImageRegistryArgsDict']] image_registry: Image registry configuration.
        :param pulumi.Input[_builtins.str] org_identifier: The organization identifier.
        :param pulumi.Input[_builtins.str] project_identifier: The project identifier.
        :param pulumi.Input[_builtins.str] updated_at: Timestamp when the setting was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DiscoverySettingState.__new__(_DiscoverySettingState)

        __props__.__dict__["correlation_id"] = correlation_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["image_registry"] = image_registry
        __props__.__dict__["org_identifier"] = org_identifier
        __props__.__dict__["project_identifier"] = project_identifier
        __props__.__dict__["updated_at"] = updated_at
        return DiscoverySetting(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="correlationId")
    def correlation_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Correlation ID for the request.
        """
        return pulumi.get(self, "correlation_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the setting was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="imageRegistry")
    def image_registry(self) -> pulumi.Output[Optional['outputs.DiscoverySettingImageRegistry']]:
        """
        Image registry configuration.
        """
        return pulumi.get(self, "image_registry")

    @_builtins.property
    @pulumi.getter(name="orgIdentifier")
    def org_identifier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The organization identifier.
        """
        return pulumi.get(self, "org_identifier")

    @_builtins.property
    @pulumi.getter(name="projectIdentifier")
    def project_identifier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The project identifier.
        """
        return pulumi.get(self, "project_identifier")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the setting was last updated.
        """
        return pulumi.get(self, "updated_at")

