"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
*
Defines the structure of protobuf messages for Camera On the Home Network
"""

import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
from . import response_generic_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions
DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _EnumCOHNStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _EnumCOHNStatusEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_EnumCOHNStatus.ValueType], builtins.type
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    COHN_UNPROVISIONED: _EnumCOHNStatus.ValueType
    COHN_PROVISIONED: _EnumCOHNStatus.ValueType

class EnumCOHNStatus(_EnumCOHNStatus, metaclass=_EnumCOHNStatusEnumTypeWrapper): ...

COHN_UNPROVISIONED: EnumCOHNStatus.ValueType
COHN_PROVISIONED: EnumCOHNStatus.ValueType
global___EnumCOHNStatus = EnumCOHNStatus

class _EnumCOHNNetworkState:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _EnumCOHNNetworkStateEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_EnumCOHNNetworkState.ValueType], builtins.type
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    COHN_STATE_Init: _EnumCOHNNetworkState.ValueType
    COHN_STATE_Error: _EnumCOHNNetworkState.ValueType
    COHN_STATE_Exit: _EnumCOHNNetworkState.ValueType
    COHN_STATE_Idle: _EnumCOHNNetworkState.ValueType
    COHN_STATE_NetworkConnected: _EnumCOHNNetworkState.ValueType
    COHN_STATE_NetworkDisconnected: _EnumCOHNNetworkState.ValueType
    COHN_STATE_ConnectingToNetwork: _EnumCOHNNetworkState.ValueType
    COHN_STATE_Invalid: _EnumCOHNNetworkState.ValueType

class EnumCOHNNetworkState(_EnumCOHNNetworkState, metaclass=_EnumCOHNNetworkStateEnumTypeWrapper): ...

COHN_STATE_Init: EnumCOHNNetworkState.ValueType
COHN_STATE_Error: EnumCOHNNetworkState.ValueType
COHN_STATE_Exit: EnumCOHNNetworkState.ValueType
COHN_STATE_Idle: EnumCOHNNetworkState.ValueType
COHN_STATE_NetworkConnected: EnumCOHNNetworkState.ValueType
COHN_STATE_NetworkDisconnected: EnumCOHNNetworkState.ValueType
COHN_STATE_ConnectingToNetwork: EnumCOHNNetworkState.ValueType
COHN_STATE_Invalid: EnumCOHNNetworkState.ValueType
global___EnumCOHNNetworkState = EnumCOHNNetworkState

@typing_extensions.final
class RequestGetCOHNStatus(google.protobuf.message.Message):
    """*
    Get the current COHN status.

    Response: @ref NotifyCOHNStatus

    Additionally, asynchronous updates can also be registered to return more @ref NotifyCOHNStatus when a value
    changes.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    REGISTER_COHN_STATUS_FIELD_NUMBER: builtins.int
    register_cohn_status: builtins.bool
    "1 to register, 0 to unregister"

    def __init__(self, *, register_cohn_status: builtins.bool | None = ...) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["register_cohn_status", b"register_cohn_status"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["register_cohn_status", b"register_cohn_status"]
    ) -> None: ...

global___RequestGetCOHNStatus = RequestGetCOHNStatus

@typing_extensions.final
class NotifyCOHNStatus(google.protobuf.message.Message):
    """
    Current COHN status triggered by a @ref RequestGetCOHNStatus
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    STATUS_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    USERNAME_FIELD_NUMBER: builtins.int
    PASSWORD_FIELD_NUMBER: builtins.int
    IPADDRESS_FIELD_NUMBER: builtins.int
    ENABLED_FIELD_NUMBER: builtins.int
    SSID_FIELD_NUMBER: builtins.int
    MACADDRESS_FIELD_NUMBER: builtins.int
    status: global___EnumCOHNStatus.ValueType
    "Current COHN status"
    state: global___EnumCOHNNetworkState.ValueType
    "Current COHN network state"
    username: builtins.str
    "Username used for http basic auth header"
    password: builtins.str
    "Password used for http basic auth header"
    ipaddress: builtins.str
    "Camera's IP address on the local network"
    enabled: builtins.bool
    "Is COHN currently enabled?"
    ssid: builtins.str
    "Currently connected SSID"
    macaddress: builtins.str
    "MAC address of the wifi adapter"

    def __init__(
        self,
        *,
        status: global___EnumCOHNStatus.ValueType | None = ...,
        state: global___EnumCOHNNetworkState.ValueType | None = ...,
        username: builtins.str | None = ...,
        password: builtins.str | None = ...,
        ipaddress: builtins.str | None = ...,
        enabled: builtins.bool | None = ...,
        ssid: builtins.str | None = ...,
        macaddress: builtins.str | None = ...
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "enabled",
            b"enabled",
            "ipaddress",
            b"ipaddress",
            "macaddress",
            b"macaddress",
            "password",
            b"password",
            "ssid",
            b"ssid",
            "state",
            b"state",
            "status",
            b"status",
            "username",
            b"username",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "enabled",
            b"enabled",
            "ipaddress",
            b"ipaddress",
            "macaddress",
            b"macaddress",
            "password",
            b"password",
            "ssid",
            b"ssid",
            "state",
            b"state",
            "status",
            b"status",
            "username",
            b"username",
        ],
    ) -> None: ...

global___NotifyCOHNStatus = NotifyCOHNStatus

@typing_extensions.final
class RequestCreateCOHNCert(google.protobuf.message.Message):
    """*
    Create the Camera On the Home Network SSL/TLS certificate.

    Returns a @ref ResponseGeneric with the status of the creation
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    OVERRIDE_FIELD_NUMBER: builtins.int
    override: builtins.bool
    "Override current provisioning and create new cert"

    def __init__(self, *, override: builtins.bool | None = ...) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["override", b"override"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["override", b"override"]) -> None: ...

global___RequestCreateCOHNCert = RequestCreateCOHNCert

@typing_extensions.final
class RequestClearCOHNCert(google.protobuf.message.Message):
    """*
    Clear the COHN certificate.

    Returns a @ref ResponseGeneric with the status of the clear
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(self) -> None: ...

global___RequestClearCOHNCert = RequestClearCOHNCert

@typing_extensions.final
class RequestCOHNCert(google.protobuf.message.Message):
    """*
    Get the COHN certificate.

    Returns a @ref ResponseCOHNCert
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(self) -> None: ...

global___RequestCOHNCert = RequestCOHNCert

@typing_extensions.final
class ResponseCOHNCert(google.protobuf.message.Message):
    """
    COHN Certificate response triggered by @ref RequestCOHNCert
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    RESULT_FIELD_NUMBER: builtins.int
    CERT_FIELD_NUMBER: builtins.int
    result: response_generic_pb2.EnumResultGeneric.ValueType
    "Was request successful?"
    cert: builtins.str
    "Root CA cert (ASCII text)"

    def __init__(
        self, *, result: response_generic_pb2.EnumResultGeneric.ValueType | None = ..., cert: builtins.str | None = ...
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["cert", b"cert", "result", b"result"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cert", b"cert", "result", b"result"]) -> None: ...

global___ResponseCOHNCert = ResponseCOHNCert

@typing_extensions.final
class RequestSetCOHNSetting(google.protobuf.message.Message):
    """*
    Configure a COHN Setting

    Returns a @ref ResponseGeneric
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    COHN_ACTIVE_FIELD_NUMBER: builtins.int
    cohn_active: builtins.bool
    "*\n    1 to enable COHN, 0 to disable COHN\n\n    When set to 1, STA Mode connection will be dropped and camera will not automatically re-connect for COHN.\n    "

    def __init__(self, *, cohn_active: builtins.bool | None = ...) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cohn_active", b"cohn_active"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cohn_active", b"cohn_active"]) -> None: ...

global___RequestSetCOHNSetting = RequestSetCOHNSetting
