"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
*
Defines the structure of protobuf messages for obtaining preset status
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions
DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _EnumRegisterPresetStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _EnumRegisterPresetStatusEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_EnumRegisterPresetStatus.ValueType], builtins.type
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    REGISTER_PRESET_STATUS_PRESET: _EnumRegisterPresetStatus.ValueType
    "Send notification when properties of a preset change"
    REGISTER_PRESET_STATUS_PRESET_GROUP_ARRAY: _EnumRegisterPresetStatus.ValueType
    "Send notification when properties of a preset group change"

class EnumRegisterPresetStatus(_EnumRegisterPresetStatus, metaclass=_EnumRegisterPresetStatusEnumTypeWrapper): ...

REGISTER_PRESET_STATUS_PRESET: EnumRegisterPresetStatus.ValueType
"Send notification when properties of a preset change"
REGISTER_PRESET_STATUS_PRESET_GROUP_ARRAY: EnumRegisterPresetStatus.ValueType
"Send notification when properties of a preset group change"
global___EnumRegisterPresetStatus = EnumRegisterPresetStatus

@typing_extensions.final
class RequestGetPresetStatus(google.protobuf.message.Message):
    """*
    Get the set of currently available presets and optionally register to be notified when it changes.

    Response: @ref NotifyPresetStatus sent immediately

    Notification: @ref NotifyPresetStatus sent periodically as preset status changes, if registered.

    The preset status changes when:

    - A client changes one of a preset's captioned settings via the API
    - The user exits from a preset's settings UI on the camera (e.g. long-press the preset pill and then press the back arrow)
    - The user creates/deletes/reorders a preset within a group
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    REGISTER_PRESET_STATUS_FIELD_NUMBER: builtins.int
    UNREGISTER_PRESET_STATUS_FIELD_NUMBER: builtins.int
    USE_CONSTANT_SETTING_IDS_FIELD_NUMBER: builtins.int

    @property
    def register_preset_status(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___EnumRegisterPresetStatus.ValueType]:
        """Array of Preset statuses to be notified about"""

    @property
    def unregister_preset_status(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___EnumRegisterPresetStatus.ValueType]:
        """Array of Preset statuses to stop being notified about"""
    use_constant_setting_ids: builtins.bool
    "*\n    Configures the set of Setting IDs that are returned by @ref NotifyPresetStatus.\n\n    Defaults to False if not set\n\n    When False, Setting IDs are tied to their camera UI string representation and may vary between cameras.\n\n    When True, Setting IDs are tied to their functional representation and are consistent across cameras.\n    "

    def __init__(
        self,
        *,
        register_preset_status: collections.abc.Iterable[global___EnumRegisterPresetStatus.ValueType] | None = ...,
        unregister_preset_status: collections.abc.Iterable[global___EnumRegisterPresetStatus.ValueType] | None = ...,
        use_constant_setting_ids: builtins.bool | None = ...
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["use_constant_setting_ids", b"use_constant_setting_ids"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "register_preset_status",
            b"register_preset_status",
            "unregister_preset_status",
            b"unregister_preset_status",
            "use_constant_setting_ids",
            b"use_constant_setting_ids",
        ],
    ) -> None: ...

global___RequestGetPresetStatus = RequestGetPresetStatus
