# Contributing to `graph-env`
We want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features
- Becoming a maintainer

## We Develop with GitHub
We use GitHub to host code, to track issues and feature requests, as well as accept pull requests.

## We Use [GitHub Flow](https://guides.github.com/introduction/flow/index.html), So All Code Changes Happen Through Pull Requests
Pull requests are the best way to propose changes to the codebase (we use [Github Flow](https://guides.github.com/introduction/flow/index.html)). We actively welcome your pull requests:

1. Fork the repo and create your branch from `main`.
2. If you've added code that should be tested, add tests.
3. If you've changed APIs, update the documentation.
4. Ensure the test suite passes.
5. Make sure your code lints.
6. Issue that pull request!

## Report bugs using GitHub's [issues](https://github.com/nrel/graph-env/issues)
We use GitHub issues to track public bugs. Report a bug by [opening a new issue](https://github.com/NREL/graph-env/issues/new).

## License
By contributing, you agree that your contributions will be licensed under the same [BSD 3-Clause License](http://choosealicense.com/licenses/bsd-3-clause/) that covers the project.

## Code of Conduct
All members of the `graph-env` community must agree to abide by its [Code of Conduct](CODE_OF_CONDUCT.md)

## References
This document was adapted from the open-source contribution guidelines for [Facebook's Draft](https://github.com/facebook/draft-js/blob/a9316a723f9e918afde44dea68b5f9f39b7d9b00/CONTRIBUTING.md)