# vrt_ud
Программный интерфейс продукта Urban Delivery

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.7.159116
- Package version: 2.7.159116
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import vrt_ud
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import vrt_ud
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import vrt_ud
from vrt_ud.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://client.demo.veeroute.tech/openapi
# See configuration.py for a list of all supported configuration parameters.
configuration = vrt_ud.Configuration(
    host = "https://client.demo.veeroute.tech/openapi"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): ApiKeyAuth
configuration = vrt_ud.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with vrt_ud.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = vrt_ud.ConfiguratorApi(api_client)
    name = 'Mcc' # str | 
configuration = vrt_ud.Configuration() # Configuration | Запрос на изменение конфигурации

    try:
        # Изменение конфигурации
        api_response = api_instance.create_cfg(name, configuration)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ConfiguratorApi->create_cfg: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://client.demo.veeroute.tech/openapi*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ConfiguratorApi* | [**create_cfg**](docs/ConfiguratorApi.md#create_cfg) | **POST** /cfg/{name} | Изменение конфигурации
*ConfiguratorApi* | [**delete_cfg**](docs/ConfiguratorApi.md#delete_cfg) | **DELETE** /cfg/{name} | Удаление конфигурации
*ConfiguratorApi* | [**read_cfg**](docs/ConfiguratorApi.md#read_cfg) | **GET** /cfg/{name} | Чтение конфигурации
*ConfiguratorApi* | [**read_cfg_names**](docs/ConfiguratorApi.md#read_cfg_names) | **GET** /cfg | Чтение названий конфигурации
*ConfiguratorApi* | [**update_cfg**](docs/ConfiguratorApi.md#update_cfg) | **PUT** /cfg/{name} | Изменение параметра конфигурации
*DataApi* | [**clean_data**](docs/DataApi.md#clean_data) | **DELETE** /data | Удаление данных за временной промежуток
*DataApi* | [**download_photo**](docs/DataApi.md#download_photo) | **GET** /photos/{id} | Скачивание фотографии по id
*DataApi* | [**find_photos**](docs/DataApi.md#find_photos) | **POST** /photos/find | Получение идентификаторов фотографий по фильтру
*DataApi* | [**load_data**](docs/DataApi.md#load_data) | **POST** /data | Загрузка данных из файла в виде base64 строки
*DataApi* | [**load_data_file**](docs/DataApi.md#load_data_file) | **POST** /data/file | Загрузка данных из файла
*DataApi* | [**read_orders**](docs/DataApi.md#read_orders) | **POST** /data/orders | Получение заказа по фильтру
*DataApi* | [**remove_orders**](docs/DataApi.md#remove_orders) | **DELETE** /data/orders | Удаление заказов по фильтру
*MonitorApi* | [**read_facts**](docs/MonitorApi.md#read_facts) | **POST** /monitor/facts | Получение фактов за промежуток времени
*MonitorApi* | [**read_performers**](docs/MonitorApi.md#read_performers) | **POST** /monitor/tracks | Получение текущей информации об исполнителе по фильтру
*MonitorApi* | [**read_trips**](docs/MonitorApi.md#read_trips) | **POST** /monitor/trips | Получение рейсов по фильтру
*MonitorApi* | [**run_trips**](docs/MonitorApi.md#run_trips) | **POST** /monitor/run_trips | Запуск рейсов
*PredictorApi* | [**predictor_check**](docs/PredictorApi.md#predictor_check) | **POST** /predictor/check | Проверка механизма подсказки временных окон.
*PredictorApi* | [**predictor_insert**](docs/PredictorApi.md#predictor_insert) | **POST** /predictor/insert | Добавление нового заказа.
*PredictorApi* | [**predictor_predict**](docs/PredictorApi.md#predictor_predict) | **POST** /predictor/predict | Подсказка временного окна
*ReportsApi* | [**generate_report**](docs/ReportsApi.md#generate_report) | **POST** /reports | Генерация отчета по фильтру


## Documentation For Models

 - [AdvancedLocation](docs/AdvancedLocation.md)
 - [AssignedShift](docs/AssignedShift.md)
 - [Capacity](docs/Capacity.md)
 - [Cargo](docs/Cargo.md)
 - [CargoPlacement](docs/CargoPlacement.md)
 - [Configuration](docs/Configuration.md)
 - [DataLoadMultipartTask](docs/DataLoadMultipartTask.md)
 - [DataLoadTask](docs/DataLoadTask.md)
 - [DeleteFilter](docs/DeleteFilter.md)
 - [Demand](docs/Demand.md)
 - [FactDemandCancellation](docs/FactDemandCancellation.md)
 - [FactDemandDone](docs/FactDemandDone.md)
 - [FactDemandPayment](docs/FactDemandPayment.md)
 - [FactDemandResumed](docs/FactDemandResumed.md)
 - [FactEventWindowChanged](docs/FactEventWindowChanged.md)
 - [FactJobDone](docs/FactJobDone.md)
 - [FactPerformerMessage](docs/FactPerformerMessage.md)
 - [FactPhoto](docs/FactPhoto.md)
 - [FactTripProgress](docs/FactTripProgress.md)
 - [FactTripStatusNotice](docs/FactTripStatusNotice.md)
 - [FactTripactionCommentChanged](docs/FactTripactionCommentChanged.md)
 - [FactWorkStarted](docs/FactWorkStarted.md)
 - [FactsFilter](docs/FactsFilter.md)
 - [FactsResult](docs/FactsResult.md)
 - [InlineResponse400](docs/InlineResponse400.md)
 - [InlineResponse401](docs/InlineResponse401.md)
 - [InlineResponse403](docs/InlineResponse403.md)
 - [InlineResponse404](docs/InlineResponse404.md)
 - [InlineResponse415](docs/InlineResponse415.md)
 - [InlineResponse429](docs/InlineResponse429.md)
 - [InlineResponse500](docs/InlineResponse500.md)
 - [InlineResponse501](docs/InlineResponse501.md)
 - [InlineResponse502](docs/InlineResponse502.md)
 - [InlineResponse503](docs/InlineResponse503.md)
 - [InlineResponse504](docs/InlineResponse504.md)
 - [InlineResponseDefault](docs/InlineResponseDefault.md)
 - [LoadWindow](docs/LoadWindow.md)
 - [Location](docs/Location.md)
 - [MerchandiseLine](docs/MerchandiseLine.md)
 - [Order](docs/Order.md)
 - [OrderCancellation](docs/OrderCancellation.md)
 - [OrdersFilter](docs/OrdersFilter.md)
 - [OrdersResult](docs/OrdersResult.md)
 - [PaymentDetails](docs/PaymentDetails.md)
 - [PerformerTrack](docs/PerformerTrack.md)
 - [PerformersFilter](docs/PerformersFilter.md)
 - [PhotosFilter](docs/PhotosFilter.md)
 - [PossibleEvent](docs/PossibleEvent.md)
 - [PredictResultWindow](docs/PredictResultWindow.md)
 - [PredictorCheckResult](docs/PredictorCheckResult.md)
 - [PredictorInsertTask](docs/PredictorInsertTask.md)
 - [PredictorResult](docs/PredictorResult.md)
 - [PredictorTask](docs/PredictorTask.md)
 - [ReportFilter](docs/ReportFilter.md)
 - [RunTripsTask](docs/RunTripsTask.md)
 - [TimeWindow](docs/TimeWindow.md)
 - [TraceData](docs/TraceData.md)
 - [TrackPoint](docs/TrackPoint.md)
 - [TracksResult](docs/TracksResult.md)
 - [Trip](docs/Trip.md)
 - [TripAction](docs/TripAction.md)
 - [TripJob](docs/TripJob.md)
 - [TripsFilter](docs/TripsFilter.md)
 - [TripsResult](docs/TripsResult.md)


## Documentation For Authorization


## ApiKeyAuth

- **Type**: Bearer authentication (JWT)


## Author

support@veeroute.com


