# coding: utf-8

"""
    VeeRoute Urban Delivery API

    Программный интерфейс продукта Urban Delivery  # noqa: E501

    The version of the OpenAPI document: 2.7.159116
    Contact: support@veeroute.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from vrt_ud.configuration import Configuration


class Order(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'key': 'str',
        'id': 'str',
        'state': 'str',
        'trip_id': 'str',
        'trip_short_key': 'str',
        'order_features': 'list[str]',
        'order_restrictions': 'list[str]',
        'performer_restrictions': 'list[str]',
        'cargos': 'list[Cargo]',
        'demands': 'list[Demand]'
    }

    attribute_map = {
        'key': 'key',
        'id': 'id',
        'state': 'state',
        'trip_id': 'trip_id',
        'trip_short_key': 'trip_short_key',
        'order_features': 'order_features',
        'order_restrictions': 'order_restrictions',
        'performer_restrictions': 'performer_restrictions',
        'cargos': 'cargos',
        'demands': 'demands'
    }

    def __init__(self, key=None, id=None, state=None, trip_id=None, trip_short_key=None, order_features=None, order_restrictions=None, performer_restrictions=None, cargos=None, demands=None, local_vars_configuration=None):  # noqa: E501
        """Order - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._key = None
        self._id = None
        self._state = None
        self._trip_id = None
        self._trip_short_key = None
        self._order_features = None
        self._order_restrictions = None
        self._performer_restrictions = None
        self._cargos = None
        self._demands = None
        self.discriminator = None

        self.key = key
        self.id = id
        self.state = state
        if trip_id is not None:
            self.trip_id = trip_id
        if trip_short_key is not None:
            self.trip_short_key = trip_short_key
        if order_features is not None:
            self.order_features = order_features
        if order_restrictions is not None:
            self.order_restrictions = order_restrictions
        if performer_restrictions is not None:
            self.performer_restrictions = performer_restrictions
        if cargos is not None:
            self.cargos = cargos
        self.demands = demands

    @property
    def key(self):
        """Gets the key of this Order.  # noqa: E501

        Уникальный ключ заказа  # noqa: E501

        :return: The key of this Order.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this Order.

        Уникальный ключ заказа  # noqa: E501

        :param key: The key of this Order.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and key is None:  # noqa: E501
            raise ValueError("Invalid value for `key`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                key is not None and len(key) > 1024):
            raise ValueError("Invalid value for `key`, length must be less than or equal to `1024`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                key is not None and len(key) < 1):
            raise ValueError("Invalid value for `key`, length must be greater than or equal to `1`")  # noqa: E501

        self._key = key

    @property
    def id(self):
        """Gets the id of this Order.  # noqa: E501

        Внутренний идентификатор заказа  # noqa: E501

        :return: The id of this Order.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Order.

        Внутренний идентификатор заказа  # noqa: E501

        :param id: The id of this Order.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def state(self):
        """Gets the state of this Order.  # noqa: E501

        Текущее состояние заказа  # noqa: E501

        :return: The state of this Order.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Order.

        Текущее состояние заказа  # noqa: E501

        :param state: The state of this Order.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and state is None:  # noqa: E501
            raise ValueError("Invalid value for `state`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                state is not None and len(state) > 256):
            raise ValueError("Invalid value for `state`, length must be less than or equal to `256`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                state is not None and len(state) < 1):
            raise ValueError("Invalid value for `state`, length must be greater than or equal to `1`")  # noqa: E501

        self._state = state

    @property
    def trip_id(self):
        """Gets the trip_id of this Order.  # noqa: E501

        Идентификатор рейса, в котором находится заказ  # noqa: E501

        :return: The trip_id of this Order.  # noqa: E501
        :rtype: str
        """
        return self._trip_id

    @trip_id.setter
    def trip_id(self, trip_id):
        """Sets the trip_id of this Order.

        Идентификатор рейса, в котором находится заказ  # noqa: E501

        :param trip_id: The trip_id of this Order.  # noqa: E501
        :type: str
        """

        self._trip_id = trip_id

    @property
    def trip_short_key(self):
        """Gets the trip_short_key of this Order.  # noqa: E501

        Короткий идентификатор рейса, в котором находится заказ  # noqa: E501

        :return: The trip_short_key of this Order.  # noqa: E501
        :rtype: str
        """
        return self._trip_short_key

    @trip_short_key.setter
    def trip_short_key(self, trip_short_key):
        """Sets the trip_short_key of this Order.

        Короткий идентификатор рейса, в котором находится заказ  # noqa: E501

        :param trip_short_key: The trip_short_key of this Order.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                trip_short_key is not None and len(trip_short_key) > 256):
            raise ValueError("Invalid value for `trip_short_key`, length must be less than or equal to `256`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                trip_short_key is not None and len(trip_short_key) < 1):
            raise ValueError("Invalid value for `trip_short_key`, length must be greater than or equal to `1`")  # noqa: E501

        self._trip_short_key = trip_short_key

    @property
    def order_features(self):
        """Gets the order_features of this Order.  # noqa: E501

        Список особенностей заказа  # noqa: E501

        :return: The order_features of this Order.  # noqa: E501
        :rtype: list[str]
        """
        return self._order_features

    @order_features.setter
    def order_features(self, order_features):
        """Sets the order_features of this Order.

        Список особенностей заказа  # noqa: E501

        :param order_features: The order_features of this Order.  # noqa: E501
        :type: list[str]
        """

        self._order_features = order_features

    @property
    def order_restrictions(self):
        """Gets the order_restrictions of this Order.  # noqa: E501

        Список требований к заказу, выполняемому в этом же рейсе  # noqa: E501

        :return: The order_restrictions of this Order.  # noqa: E501
        :rtype: list[str]
        """
        return self._order_restrictions

    @order_restrictions.setter
    def order_restrictions(self, order_restrictions):
        """Sets the order_restrictions of this Order.

        Список требований к заказу, выполняемому в этом же рейсе  # noqa: E501

        :param order_restrictions: The order_restrictions of this Order.  # noqa: E501
        :type: list[str]
        """

        self._order_restrictions = order_restrictions

    @property
    def performer_restrictions(self):
        """Gets the performer_restrictions of this Order.  # noqa: E501

        Список необходимых требований к исполнителю работы, используется для проверки совместимости исполнителя данной работе по списку возможностей исполнителя  # noqa: E501

        :return: The performer_restrictions of this Order.  # noqa: E501
        :rtype: list[str]
        """
        return self._performer_restrictions

    @performer_restrictions.setter
    def performer_restrictions(self, performer_restrictions):
        """Sets the performer_restrictions of this Order.

        Список необходимых требований к исполнителю работы, используется для проверки совместимости исполнителя данной работе по списку возможностей исполнителя  # noqa: E501

        :param performer_restrictions: The performer_restrictions of this Order.  # noqa: E501
        :type: list[str]
        """

        self._performer_restrictions = performer_restrictions

    @property
    def cargos(self):
        """Gets the cargos of this Order.  # noqa: E501

        Список грузов (может содержать один груз для DROP, список для PICKUP, пустой для WORK)  # noqa: E501

        :return: The cargos of this Order.  # noqa: E501
        :rtype: list[Cargo]
        """
        return self._cargos

    @cargos.setter
    def cargos(self, cargos):
        """Sets the cargos of this Order.

        Список грузов (может содержать один груз для DROP, список для PICKUP, пустой для WORK)  # noqa: E501

        :param cargos: The cargos of this Order.  # noqa: E501
        :type: list[Cargo]
        """

        self._cargos = cargos

    @property
    def demands(self):
        """Gets the demands of this Order.  # noqa: E501

        Список заявок  # noqa: E501

        :return: The demands of this Order.  # noqa: E501
        :rtype: list[Demand]
        """
        return self._demands

    @demands.setter
    def demands(self, demands):
        """Sets the demands of this Order.

        Список заявок  # noqa: E501

        :param demands: The demands of this Order.  # noqa: E501
        :type: list[Demand]
        """
        if self.local_vars_configuration.client_side_validation and demands is None:  # noqa: E501
            raise ValueError("Invalid value for `demands`, must not be `None`")  # noqa: E501

        self._demands = demands

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Order):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Order):
            return True

        return self.to_dict() != other.to_dict()
