# coding: utf-8

"""
    VeeRoute Urban Delivery API

    Программный интерфейс продукта Urban Delivery  # noqa: E501

    The version of the OpenAPI document: 2.7.159116
    Contact: support@veeroute.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from vrt_ud.configuration import Configuration


class Trip(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'key': 'str',
        'trip_id': 'str',
        'assigned_shifts': 'list[AssignedShift]',
        'actions': 'list[TripAction]',
        'waitlist': 'list[str]'
    }

    attribute_map = {
        'key': 'key',
        'trip_id': 'trip_id',
        'assigned_shifts': 'assigned_shifts',
        'actions': 'actions',
        'waitlist': 'waitlist'
    }

    def __init__(self, key=None, trip_id=None, assigned_shifts=None, actions=None, waitlist=None, local_vars_configuration=None):  # noqa: E501
        """Trip - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._key = None
        self._trip_id = None
        self._assigned_shifts = None
        self._actions = None
        self._waitlist = None
        self.discriminator = None

        self.key = key
        if trip_id is not None:
            self.trip_id = trip_id
        self.assigned_shifts = assigned_shifts
        if actions is not None:
            self.actions = actions
        if waitlist is not None:
            self.waitlist = waitlist

    @property
    def key(self):
        """Gets the key of this Trip.  # noqa: E501

        Ключ рейса, уникальный идентификатор рейса.  # noqa: E501

        :return: The key of this Trip.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this Trip.

        Ключ рейса, уникальный идентификатор рейса.  # noqa: E501

        :param key: The key of this Trip.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and key is None:  # noqa: E501
            raise ValueError("Invalid value for `key`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                key is not None and len(key) > 1024):
            raise ValueError("Invalid value for `key`, length must be less than or equal to `1024`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                key is not None and len(key) < 1):
            raise ValueError("Invalid value for `key`, length must be greater than or equal to `1`")  # noqa: E501

        self._key = key

    @property
    def trip_id(self):
        """Gets the trip_id of this Trip.  # noqa: E501

        Внутренний идентификатор рейса, в котором находится заказ.  # noqa: E501

        :return: The trip_id of this Trip.  # noqa: E501
        :rtype: str
        """
        return self._trip_id

    @trip_id.setter
    def trip_id(self, trip_id):
        """Sets the trip_id of this Trip.

        Внутренний идентификатор рейса, в котором находится заказ.  # noqa: E501

        :param trip_id: The trip_id of this Trip.  # noqa: E501
        :type: str
        """

        self._trip_id = trip_id

    @property
    def assigned_shifts(self):
        """Gets the assigned_shifts of this Trip.  # noqa: E501

        Список назначенных смен.  # noqa: E501

        :return: The assigned_shifts of this Trip.  # noqa: E501
        :rtype: list[AssignedShift]
        """
        return self._assigned_shifts

    @assigned_shifts.setter
    def assigned_shifts(self, assigned_shifts):
        """Sets the assigned_shifts of this Trip.

        Список назначенных смен.  # noqa: E501

        :param assigned_shifts: The assigned_shifts of this Trip.  # noqa: E501
        :type: list[AssignedShift]
        """
        if self.local_vars_configuration.client_side_validation and assigned_shifts is None:  # noqa: E501
            raise ValueError("Invalid value for `assigned_shifts`, must not be `None`")  # noqa: E501

        self._assigned_shifts = assigned_shifts

    @property
    def actions(self):
        """Gets the actions of this Trip.  # noqa: E501

        Список действий над заказами.  # noqa: E501

        :return: The actions of this Trip.  # noqa: E501
        :rtype: list[TripAction]
        """
        return self._actions

    @actions.setter
    def actions(self, actions):
        """Sets the actions of this Trip.

        Список действий над заказами.  # noqa: E501

        :param actions: The actions of this Trip.  # noqa: E501
        :type: list[TripAction]
        """

        self._actions = actions

    @property
    def waitlist(self):
        """Gets the waitlist of this Trip.  # noqa: E501

        Список ключей назначенных, но не запланированные на определенное время заказов  # noqa: E501

        :return: The waitlist of this Trip.  # noqa: E501
        :rtype: list[str]
        """
        return self._waitlist

    @waitlist.setter
    def waitlist(self, waitlist):
        """Sets the waitlist of this Trip.

        Список ключей назначенных, но не запланированные на определенное время заказов  # noqa: E501

        :param waitlist: The waitlist of this Trip.  # noqa: E501
        :type: list[str]
        """

        self._waitlist = waitlist

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Trip):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Trip):
            return True

        return self.to_dict() != other.to_dict()
